/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class JavadocElement
extends SimpleRefactoringElementImpl {
    ClassMember feature;
    int textoffset;
    String text;
    private String plainText;
    private PositionBounds bounds = null;
    private String htmlText;

    public JavadocElement(int n, String string, ClassMember classMember) {
        this.textoffset = n;
        this.text = string;
        this.feature = classMember;
        this.computeText();
    }

    public String getDisplayText() {
        return "/** " + this.htmlText;
    }

    public Element getJavaElement() {
        return this.feature;
    }

    public FileObject getParentFile() {
        return null;
    }

    public PositionBounds getPosition() {
        if (this.bounds == null) {
            this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.feature.getJavadoc());
        }
        return this.bounds;
    }

    public String getText() {
        return this.plainText;
    }

    public void performChange() {
    }

    private void computeText() {
        String string = this.feature.getJavadocText();
        int n = string.lastIndexOf(10, this.textoffset);
        int n2 = string.indexOf(10, this.textoffset);
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == -1) {
            n2 = string.length();
        }
        stringBuffer.append("<i>");
        stringBuffer.append(CheckUtils.htmlize(string.substring(n + 1, this.textoffset)));
        stringBuffer.append("<b>");
        stringBuffer.append(string.substring(this.textoffset, this.textoffset + this.text.length()));
        stringBuffer.append("</b>");
        stringBuffer.append(CheckUtils.trimToEnd(CheckUtils.htmlize(string.substring(this.textoffset + this.text.length(), n2))));
        stringBuffer.append("</i>");
        this.htmlText = stringBuffer.toString();
        this.plainText = string.substring(n + 1, n2);
    }
}

