/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class SafeDeleteRefactoringElement
extends SimpleRefactoringElementImpl {
    private final String text;
    private Element refactoredElement;
    private ExternalChange extChange;

    public SafeDeleteRefactoringElement(Element element) {
        this.refactoredElement = element;
        if (this.refactoredElement instanceof Resource) {
            this.extChange = new ResourceDeletionChange((Resource)this.refactoredElement);
            FileObject fileObject = JavaModel.getFileObject((Resource)((Resource)this.refactoredElement));
            this.text = NbBundle.getMessage((Class)SafeDeleteRefactoringElement.class, (String)"TXT_SafeDel_Delete", (Object)fileObject.getNameExt());
        } else if (this.refactoredElement instanceof NamedElement) {
            this.text = NbBundle.getMessage((Class)SafeDeleteRefactoringElement.class, (String)"TXT_SafeDel_Delete", (Object)((NamedElement)this.refactoredElement).getName());
        } else {
            String string = NbBundle.getMessage((Class)SafeDeleteRefactoringElement.class, (String)"TXT_SafeDel_Delete");
            this.text = MessageFormat.format(string, this.refactoredElement);
        }
    }

    public void performChange() {
        List list;
        RefFeatured refFeatured;
        if (this.refactoredElement instanceof Resource) {
            this.extChange.performExternalChange();
            JavaMetamodel.getManager().registerUndoElement(this.extChange);
            return;
        }
        if (this.refactoredElement instanceof LocalVariable && (refFeatured = this.refactoredElement.refImmediateComposite()) instanceof LocalVarDeclaration && (list = ((LocalVarDeclaration)refFeatured).getVariables()).size() == 1) {
            this.refactoredElement = (Element)refFeatured;
        }
        this.refactoredElement.refDelete();
    }

    public String getText() {
        return this.text;
    }

    public PositionBounds getPosition() {
        return JavaMetamodel.getManager().getElementPosition(this.refactoredElement);
    }

    public FileObject getParentFile() {
        return JavaMetamodel.getManager().getFileObject(this.refactoredElement.getResource());
    }

    public Element getJavaElement() {
        return this.refactoredElement;
    }

    public String getDisplayText() {
        return this.getText();
    }

    private static class ResourceDeletionChange
    implements ExternalChange {
        private DataObject primaryDataObj;
        private FileObject parentFileObj;
        private Resource refactoredResource;
        private Map fileObjMap = new HashMap();
        private boolean initialExecution = true;

        private ResourceDeletionChange(Resource resource) {
            this.refactoredResource = resource;
            try {
                this.backupFileObjects(resource);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }

        public void performExternalChange() {
            try {
                if (!this.initialExecution) {
                    this.backupFileObjects(this.refactoredResource);
                } else {
                    this.initialExecution = false;
                }
                this.primaryDataObj.delete();
                this.refactoredResource.refDelete();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
        }

        public void undoExternalChange() {
            try {
                this.populateFileObjects();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        private void backupFileObjects(Resource resource) throws DataObjectNotFoundException {
            FileObject fileObject = JavaModel.getFileObject((Resource)resource);
            this.parentFileObj = fileObject.getParent();
            this.primaryDataObj = DataObject.find((FileObject)fileObject);
            Set set = this.primaryDataObj.files();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject2 = (FileObject)iterator.next();
                String string = fileObject2.getNameExt();
                try {
                    String string2 = this.readFileContent(fileObject2);
                    this.fileObjMap.put(string, string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)fileNotFoundException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        private String readFileContent(FileObject fileObject) throws FileNotFoundException, IOException {
            Resource resource = JavaModel.getResource((FileObject)fileObject);
            if (resource != null) {
                return resource.getSourceText();
            }
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }

        private void populateFileObjects() throws DataObjectNotFoundException, IOException {
            Iterator iterator = this.fileObjMap.keySet().iterator();
            FileObject fileObject = null;
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                fileObject = this.parentFileObj.createData(string);
                this.writeToFile(fileObject, (String)this.fileObjMap.get(string));
            }
            this.primaryDataObj = DataObject.find(fileObject);
            this.refactoredResource = JavaMetamodel.getManager().getResource(this.primaryDataObj.getPrimaryFile());
        }

        private void writeToFile(FileObject fileObject, String string) throws IOException {
            OutputStream outputStream = fileObject.getOutputStream(fileObject.lock());
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.print(string);
            printWriter.close();
        }
    }
}

