/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;

public final class Utilities {
    private Utilities() {
    }

    public static boolean isFromSource(JavaClass javaClass) {
        Resource resource = javaClass.getResource();
        return resource != null && (resource.getStatus() & Integer.MIN_VALUE) == 0;
    }

    public static List getFeatureParamTypes(CallableFeature callableFeature) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator iterator = callableFeature.getParameters().iterator();
        while (iterator.hasNext()) {
            Type type = ((Parameter)iterator.next()).getType();
            while (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getDefinition();
            }
            arrayList.add(type);
        }
        return arrayList;
    }

    public static List duplicateList(Collection collection, JavaModelPackage javaModelPackage) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MetadataElement metadataElement = (MetadataElement)iterator.next();
            arrayList.add(metadataElement.duplicate(javaModelPackage));
        }
        return arrayList;
    }

    public static JavaClass getRealClass(JavaClass javaClass) {
        while (javaClass instanceof ParameterizedType) {
            javaClass = ((ParameterizedType)javaClass).getDefinition();
        }
        return javaClass;
    }

    public static boolean hasMembers(JavaClass javaClass) {
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (!(feature instanceof Field) && !(feature instanceof Method) && !(feature instanceof JavaClass)) continue;
            return true;
        }
        return false;
    }
}

