/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.APIAccessor;
import org.netbeans.modules.refactoring.ProgressSupport;
import org.netbeans.modules.refactoring.SPIAccessor;
import org.netbeans.modules.refactoring.api.AccessorImpl;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandlerFactory;
import org.netbeans.modules.refactoring.spi.ProgressProvider;
import org.netbeans.modules.refactoring.spi.ReadOnlyFilesHandler;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public abstract class AbstractRefactoring {
    public static final int INIT = 0;
    public static final int PRE_CHECK = 1;
    public static final int PARAMETERS_CHECK = 2;
    public static final int PREPARE = 3;
    private int currentState = 0;
    private static final int PLUGIN_STEPS = 30;
    private ArrayList plugins;
    private ArrayList pluginsWithProgress;
    private ArrayList gbHandlers;
    private ProgressListener progressListener = new ProgressL();
    private ProgressSupport progressSupport;
    AbstractRefactoring caller;

    private Collection getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(RefactoringPluginFactory.class));
            Iterator iterator = result.allInstances().iterator();
            while (iterator.hasNext()) {
                RefactoringPluginFactory refactoringPluginFactory = (RefactoringPluginFactory)iterator.next();
                RefactoringPlugin refactoringPlugin = refactoringPluginFactory.createInstance(this);
                if (refactoringPlugin == null || this.caller != null && !refactoringPluginFactory.getClass().getClassLoader().equals(this.getClass().getClassLoader()) && refactoringPluginFactory.createInstance(this.caller) != null) continue;
                this.plugins.add(refactoringPlugin);
            }
        }
        return this.plugins;
    }

    Collection getGBHandlers() {
        if (this.gbHandlers == null) {
            this.gbHandlers = new ArrayList();
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(GuardedBlockHandlerFactory.class));
            Iterator iterator = result.allInstances().iterator();
            while (iterator.hasNext()) {
                GuardedBlockHandler guardedBlockHandler = ((GuardedBlockHandlerFactory)iterator.next()).createInstance(this);
                if (guardedBlockHandler == null) continue;
                this.gbHandlers.add(guardedBlockHandler);
            }
        }
        return this.gbHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Problem preCheck() {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            if (!(this instanceof WhereUsedQuery)) {
                if (this.progressSupport != null) {
                    this.progressSupport.fireProgressListenerStart(this, 1, -1);
                }
                this.setCP();
                if (this.progressSupport != null) {
                    this.progressSupport.fireProgressListenerStop(this);
                }
            }
            this.currentState = 1;
            Problem problem = this.pluginsPreCheck(null);
            return problem;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Problem prepare(RefactoringSession refactoringSession) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            this.setCP();
            Problem problem = null;
            if (this.currentState < 2) {
                problem = this.checkParameters();
            }
            if (problem != null && problem.isFatal()) {
                Problem problem2 = problem;
                return problem2;
            }
            Problem problem3 = problem = this.pluginsPrepare(problem, refactoringSession);
            return problem3;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Problem checkParameters() {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            Problem problem;
            if (this instanceof WhereUsedQuery) {
                if (this.progressSupport != null) {
                    this.progressSupport.fireProgressListenerStart(this, 1, -1);
                }
                this.setCP();
                if (this.progressSupport != null) {
                    this.progressSupport.fireProgressListenerStop(this);
                }
            } else {
                this.setCP();
            }
            if ((problem = this.fastCheckParameters()) != null && problem.isFatal()) {
                Problem problem2 = problem;
                return problem2;
            }
            this.currentState = 2;
            Problem problem3 = this.pluginsCheckParams(problem);
            return problem3;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Problem fastCheckParameters() {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            Problem problem = null;
            if (this.currentState < 1) {
                problem = this.preCheck();
            }
            if (problem != null && problem.isFatal()) {
                Problem problem2 = problem;
                return problem2;
            }
            Problem problem3 = this.pluginsFastCheckParams(problem);
            return problem3;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    private void setCP() {
        if (JMManager.getTransactionMutex().getClassPath() == null) {
            this.setClassPath();
        }
    }

    public final synchronized void addProgressListener(ProgressListener progressListener) {
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport();
        }
        this.progressSupport.addProgressListener(progressListener);
        if (this.pluginsWithProgress == null) {
            this.pluginsWithProgress = new ArrayList();
            Iterator iterator = this.getPlugins().iterator();
            while (iterator.hasNext()) {
                RefactoringPlugin refactoringPlugin = (RefactoringPlugin)iterator.next();
                if (!(refactoringPlugin instanceof ProgressProvider)) continue;
                ((ProgressProvider)((Object)refactoringPlugin)).addProgressListener(this.progressListener);
                this.pluginsWithProgress.add(refactoringPlugin);
            }
        }
    }

    public final synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressSupport != null) {
            this.progressSupport.removeProgressListener(progressListener);
        }
        if (this.pluginsWithProgress != null) {
            Iterator iterator = this.pluginsWithProgress.iterator();
            while (iterator.hasNext()) {
                ProgressProvider progressProvider = (ProgressProvider)iterator.next();
                progressProvider.removeProgressListener(this.progressListener);
            }
            this.pluginsWithProgress.clear();
            this.pluginsWithProgress = null;
        }
    }

    protected abstract void setClassPath();

    public final void cancelRequest() {
        Iterator iterator = this.getPlugins().iterator();
        while (iterator.hasNext()) {
            RefactoringPlugin refactoringPlugin = (RefactoringPlugin)iterator.next();
            refactoringPlugin.cancelRequest();
        }
    }

    private Problem pluginsPreCheck(Problem problem) {
        Iterator iterator = this.getPlugins().iterator();
        while (iterator.hasNext()) {
            RefactoringPlugin refactoringPlugin = (RefactoringPlugin)iterator.next();
            problem = AbstractRefactoring.chainProblems(refactoringPlugin.preCheck(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    private Problem pluginsPrepare(Problem problem, RefactoringSession refactoringSession) {
        Object object;
        RefactoringElementsBag refactoringElementsBag = refactoringSession.getElementsBag();
        Iterator iterator = this.getPlugins().iterator();
        while (iterator.hasNext()) {
            object = (RefactoringPlugin)iterator.next();
            problem = AbstractRefactoring.chainProblems(object.prepare(refactoringElementsBag), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        if (!(this instanceof WhereUsedQuery) && (object = this.getROHandler()) != null) {
            Collection collection = SPIAccessor.DEFAULT.getReadOnlyFiles(refactoringElementsBag);
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                FileObject fileObject = (FileObject)iterator2.next();
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    Iterator iterator3 = dataObject.files().iterator();
                    while (iterator3.hasNext()) {
                        FileObject fileObject2 = (FileObject)iterator3.next();
                        if (SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)fileObject2)) != 1) continue;
                        hashSet.add(fileObject2);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    hashSet.add(fileObject);
                }
            }
            problem = AbstractRefactoring.chainProblems(object.createProblem(refactoringSession, hashSet), problem);
        }
        return problem;
    }

    private ReadOnlyFilesHandler getROHandler() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ReadOnlyFilesHandler.class));
        List list = (List)result.allInstances();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of ReadOnlyFilesHandler found in Lookup; only using first one: " + list);
        }
        return (ReadOnlyFilesHandler)list.get(0);
    }

    private Problem pluginsCheckParams(Problem problem) {
        Iterator iterator = this.getPlugins().iterator();
        while (iterator.hasNext()) {
            RefactoringPlugin refactoringPlugin = (RefactoringPlugin)iterator.next();
            problem = AbstractRefactoring.chainProblems(refactoringPlugin.checkParameters(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    private Problem pluginsFastCheckParams(Problem problem) {
        Iterator iterator = this.getPlugins().iterator();
        while (iterator.hasNext()) {
            RefactoringPlugin refactoringPlugin = (RefactoringPlugin)iterator.next();
            problem = AbstractRefactoring.chainProblems(refactoringPlugin.fastCheckParameters(), problem);
            if (problem == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    static Problem chainProblems(Problem problem, Problem problem2) {
        if (problem == null) {
            return problem2;
        }
        if (problem2 == null) {
            return problem;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    static {
        APIAccessor.DEFAULT = new AccessorImpl();
    }

    private class ProgressL
    implements ProgressListener {
        private float progressStep;
        private float current;

        private ProgressL() {
        }

        public void start(ProgressEvent progressEvent) {
            this.progressStep = 30.0f / (float)progressEvent.getCount();
            if (AbstractRefactoring.this.pluginsWithProgress.indexOf(progressEvent.getSource()) == 0) {
                this.current = 0.0f;
                if (progressEvent.getCount() == -1) {
                    this.fireProgressListenerStart(progressEvent.getOperationType(), -1);
                } else {
                    this.fireProgressListenerStart(progressEvent.getOperationType(), 30 * AbstractRefactoring.this.pluginsWithProgress.size());
                }
            } else {
                this.current = AbstractRefactoring.this.pluginsWithProgress.indexOf(progressEvent.getSource()) * 30;
                this.fireProgressListenerStep((int)this.current);
            }
        }

        public void step(ProgressEvent progressEvent) {
            this.current += this.progressStep;
            this.fireProgressListenerStep((int)this.current);
        }

        public void stop(ProgressEvent progressEvent) {
            if (AbstractRefactoring.this.pluginsWithProgress.indexOf(progressEvent.getSource()) == AbstractRefactoring.this.pluginsWithProgress.size() - 1) {
                this.fireProgressListenerStop();
            }
        }

        private void fireProgressListenerStart(int n, int n2) {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStart(this, n, n2);
            }
        }

        private void fireProgressListenerStep() {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStep(this);
            }
        }

        private void fireProgressListenerStep(int n) {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStep(this, n);
            }
        }

        private void fireProgressListenerStop() {
            if (AbstractRefactoring.this.progressSupport != null) {
                AbstractRefactoring.this.progressSupport.fireProgressListenerStop(this);
            }
        }
    }
}

