/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public final class MoveClassRefactoring
extends AbstractRefactoring {
    private Collection resources;
    private Collection otherDataObjects = Collections.EMPTY_LIST;
    private FileObject folder = null;
    private Map packagePostfix;
    private Collection dataObjects = Collections.EMPTY_LIST;
    private Map checkedSourcesMap;
    private boolean packageRename;
    private boolean isPackageRename = false;
    private String newPackageName;
    private FileObject target;

    public MoveClassRefactoring(FileObject fileObject, boolean bl) {
        this.isPackageRename = true;
        this.packageRename = bl;
        if (this.packageRename) {
            this.folder = fileObject;
            DataObject[] dataObjectArray = DataFolder.findFolder((FileObject)this.folder).getChildren();
            this.resources = new HashSet();
            this.otherDataObjects = new HashSet();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (dataObjectArray[i] instanceof JavaDataObject) {
                    this.resources.add(JavaModel.getResource((FileObject)dataObjectArray[i].getPrimaryFile()));
                    continue;
                }
                if (dataObjectArray[i] instanceof DataFolder) continue;
                this.otherDataObjects.add(dataObjectArray[i]);
            }
        } else {
            this.folder = fileObject;
            LinkedList<DataObject> linkedList = new LinkedList<DataObject>(Arrays.asList(DataFolder.findFolder((FileObject)this.folder).getChildren()));
            this.resources = new HashSet();
            this.otherDataObjects = new HashSet();
            while (!linkedList.isEmpty()) {
                DataObject dataObject = linkedList.removeFirst();
                if (dataObject instanceof JavaDataObject) {
                    this.resources.add(JavaModel.getResource((FileObject)dataObject.getPrimaryFile()));
                    continue;
                }
                if (dataObject instanceof DataFolder) {
                    if (!VisibilityQuery.getDefault().isVisible(dataObject.getPrimaryFile())) continue;
                    linkedList.addAll(Arrays.asList(((DataFolder)dataObject).getChildren()));
                    continue;
                }
                this.otherDataObjects.add(dataObject);
            }
        }
    }

    public MoveClassRefactoring(JavaClass javaClass) {
        this.resources = new ArrayList(1);
        this.resources.add(javaClass.getResource());
    }

    public MoveClassRefactoring(Collection collection) {
        this.resources = collection;
    }

    public MoveClassRefactoring(Collection collection, FileObject fileObject) {
        this.target = fileObject;
        this.resources = new ArrayList(1);
        this.packagePostfix = new HashMap(collection.size());
        this.otherDataObjects = new HashSet();
        this.dataObjects = collection;
        this.setup(collection, "");
    }

    public FileObject getSourceFolder() {
        return this.folder;
    }

    protected void setClassPath() {
        Util.setClassPath(this.resources);
    }

    public Collection getResources() {
        return this.resources;
    }

    public String getTargetPackageName() {
        return this.newPackageName;
    }

    public String getTargetPackageName(Resource resource) {
        return this.getTargetPackageName(JavaModel.getFileObject((Resource)resource));
    }

    public String getTargetPackageName(FileObject fileObject) {
        if (this.isPackageRename) {
            if (this.packageRename) {
                return this.newPackageName;
            }
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.folder, (String)"classpath/source");
            FileObject fileObject2 = classPath.findOwnerRoot(this.folder);
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)this.folder.getParent()).replace('/', '.');
            String string2 = FileUtil.getRelativePath((FileObject)this.folder, (FileObject)fileObject.getParent()).replace('/', '.');
            String string3 = this.concat(string, this.newPackageName, string2);
            return string3;
        }
        if (this.packagePostfix != null) {
            String string = (String)this.packagePostfix.get(fileObject);
            String string4 = this.concat(null, this.newPackageName, string);
            return string4;
        }
        return this.newPackageName;
    }

    public Collection getOtherDataObjects() {
        return this.otherDataObjects;
    }

    public FileObject getTargetClassPathRoot() {
        FileObject fileObject = this.isPackageRename ? this.folder : this.target;
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
    }

    public void setTargetClassPathRoot(FileObject fileObject) {
        this.target = fileObject;
    }

    public void setTargetPackageName(String string) {
        this.newPackageName = string;
    }

    public Collection getSelectedDataObjects() {
        if (this.isPackageRename) {
            try {
                if (!this.packageRename) {
                    return Collections.singletonList(DataObject.find((FileObject)this.folder));
                }
                FileObject fileObject = this.folder;
                FileObject fileObject2 = this.getTargetClassPathRoot();
                if (fileObject != fileObject2) {
                    while (fileObject.getParent() != fileObject2) {
                        fileObject = fileObject.getParent();
                    }
                }
                return Collections.singletonList(DataObject.find((FileObject)fileObject));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return this.dataObjects;
    }

    private void setup(Collection collection, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            FileObject fileObject = dataObject.getPrimaryFile();
            if (dataObject instanceof JavaDataObject) {
                Resource resource = JavaModel.getResource((FileObject)fileObject);
                this.resources.add(resource);
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                continue;
            }
            if (!(dataObject instanceof DataFolder)) {
                this.otherDataObjects.add(dataObject);
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(((DataFolder)dataObject).getPrimaryFile())) continue;
            boolean bl = !"".equals(string);
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = ((DataFolder)dataObject).children();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            this.setup(arrayList, string + (bl ? "." : "") + dataObject.getName());
        }
    }

    private String concat(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && !"".equals(string)) {
            string4 = string4 + string + ".";
        }
        string4 = string4 + string2;
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + ("".equals(string4) ? "" : ".") + string3;
        }
        return string4;
    }
}

