/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;

public final class PullUpRefactoring
extends AbstractRefactoring {
    private static final MemberInfo[] EMPTY_MEMBERS = new MemberInfo[0];
    private final JavaClass sourceType;
    private JavaClass targetType;
    private MemberInfo[] members;
    private JavaClass[] supertypes;

    public PullUpRefactoring(JavaClass javaClass) {
        this.sourceType = javaClass instanceof ParameterizedType ? ((ParameterizedType)javaClass).getDefinition() : javaClass;
    }

    protected void setClassPath() {
        Util.setDefaultClassPath();
    }

    public JavaClass getSourceType() {
        return this.sourceType;
    }

    public JavaClass getTargetType() {
        return this.targetType;
    }

    public void setTargetType(JavaClass javaClass) {
        this.targetType = javaClass;
    }

    public MemberInfo[] getMembers() {
        return this.members == null ? EMPTY_MEMBERS : this.members;
    }

    public void setMembers(MemberInfo[] memberInfoArray) {
        this.members = memberInfoArray;
    }

    public JavaClass[] collectSupertypes() {
        if (this.supertypes == null) {
            if (this.sourceType != null) {
                ArrayList arrayList = new ArrayList();
                PullUpRefactoring.collectSupertypes(this.sourceType, arrayList, new HashSet());
                this.supertypes = arrayList.toArray(new JavaClass[arrayList.size()]);
            } else {
                this.supertypes = new JavaClass[0];
            }
        }
        return this.supertypes;
    }

    private static void collectSupertypes(JavaClass javaClass, List list, Set set) {
        JavaClass javaClass2 = Utilities.getRealClass(javaClass.getSuperClass());
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        if (javaClass2 != null && set.add(javaClass2)) {
            arrayList.add(javaClass2);
            if (Utilities.isFromSource(javaClass2) && !CheckUtils.isFromLibrary(javaClass2.getResource())) {
                list.add(javaClass2);
            }
        }
        Iterator iterator = javaClass.getInterfaces().iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass3 = Utilities.getRealClass((JavaClass)iterator.next());
            if (!set.add(javaClass3)) continue;
            arrayList.add(javaClass3);
            if (!Utilities.isFromSource(javaClass3)) continue;
            list.add(javaClass3);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PullUpRefactoring.collectSupertypes((JavaClass)iterator.next(), list, set);
        }
    }

    public static final class MemberInfo {
        public final NamedElement member;
        public final boolean makeAbstract;

        private MemberInfo(NamedElement namedElement, boolean bl) {
            this.member = namedElement;
            this.makeAbstract = bl;
        }

        public MemberInfo(Method method, boolean bl) {
            this((NamedElement)method, bl);
        }

        public MemberInfo(JavaClass javaClass) {
            this((NamedElement)javaClass, false);
        }

        public MemberInfo(Field field) {
            this((NamedElement)field, false);
        }

        public MemberInfo(MultipartId multipartId) {
            this((NamedElement)multipartId, false);
        }
    }
}

