/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.classpath.Util;

public final class UseSuperTypeRefactoring
extends AbstractRefactoring {
    private final Element subType;
    private JavaClass superType;
    private boolean searchInComments;
    private JavaClass[] candidateSuperTypes;

    public UseSuperTypeRefactoring(Element element) {
        this.subType = element;
        this.candidateSuperTypes = this.deriveSuperTypes(this.subType);
    }

    protected void setClassPath() {
        Util.setDefaultClassPath();
    }

    public Element getTypeElement() {
        return this.subType;
    }

    public void setTargetSuperType(JavaClass javaClass) {
        this.superType = javaClass;
    }

    public JavaClass getTargetSuperType() {
        return this.superType;
    }

    public JavaClass[] getCandidateSuperTypes() {
        return this.candidateSuperTypes;
    }

    private JavaClass[] deriveSuperTypes(Element element) {
        Object object;
        if (!(element instanceof JavaClass)) {
            return new JavaClass[0];
        }
        JavaClass javaClass = (JavaClass)element;
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
        List list = javaClass.getInterfaces();
        this.addChangedTypes(hashSet, list);
        JavaClass javaClass2 = javaClass;
        while ((javaClass2 = javaClass2.getSuperClass()) != null) {
            if (javaClass2 instanceof ParameterizedType) {
                javaClass2 = ((ParameterizedType)javaClass2).getDefinition();
            }
            hashSet.add(javaClass2);
            object = javaClass2.getInterfaces();
            if (object == null || object.size() <= 0) continue;
            this.addChangedTypes(hashSet, (Collection)object);
        }
        object = hashSet.toArray(new JavaClass[0]);
        return object;
    }

    private void addChangedTypes(Collection collection, Collection collection2) {
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (javaClass instanceof ParameterizedType) {
                javaClass = ((ParameterizedType)javaClass).getDefinition();
            }
            collection.add(javaClass);
        }
    }
}

