/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.classpath.Util;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.WeakListeners;

public class RefactoringClassPathImplementation
implements ClassPathImplementation,
GlobalPathRegistryListener,
PropertyChangeListener {
    private List resourceCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Collection fileSet;
    private Set sources;
    private Set compile;
    private Set boot;
    private static ClassPath defaultInstance;
    private static ClassPath customInstance;
    private static RefactoringClassPathImplementation customInstanceSPI;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RefactoringClassPathImplementation(Collection collection) {
        this.fileSet = collection;
    }

    public synchronized List getResources() {
        if (this.resourceCache == null) {
            this.resourceCache = Collections.unmodifiableList(this.createResources());
        }
        return this.resourceCache;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
        RefactoringClassPathImplementation.resetCache();
    }

    public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
        RefactoringClassPathImplementation.resetCache();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        RefactoringClassPathImplementation.resetCache();
    }

    private List createResources() {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        HashSet<URL> hashSet = new HashSet<URL>();
        GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();
        globalPathRegistry.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create((Class)GlobalPathRegistryListener.class, (EventListener)this, (Object)globalPathRegistry));
        if (!$assertionsDisabled && globalPathRegistry == null) {
            throw new AssertionError((Object)"GlobalPathRegistry.getDefault() returned null");
        }
        this.computeDependencies();
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            ClassPath classPath = (ClassPath)iterator.next();
            Iterator iterator2 = classPath.entries().iterator();
            while (iterator2.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator2.next();
                URL uRL = entry.getURL();
                if (!$assertionsDisabled && uRL == null) {
                    throw new AssertionError((Object)"ClassPath.Entry.getURL() returned null");
                }
                if (!hashSet.add(uRL)) continue;
                arrayList.add(ClassPathSupport.createResource((URL)uRL));
            }
            classPath.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)(class$java$beans$PropertyChangeListener == null ? RefactoringClassPathImplementation.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener), (EventListener)this, (Object)classPath));
        }
        this.addResources(this.boot, hashSet, arrayList);
        this.addResources(this.compile, hashSet, arrayList);
        return arrayList;
    }

    private void computeDependencies() {
        if (this.fileSet.isEmpty()) {
            GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();
            this.sources = globalPathRegistry.getPaths("classpath/source");
            if (!$assertionsDisabled && this.sources == null) {
                throw new AssertionError((Object)"GlobalPathRegistry.getPath() for SOURCES returned null");
            }
            this.compile = globalPathRegistry.getPaths("classpath/compile");
            if (!$assertionsDisabled && this.compile == null) {
                throw new AssertionError((Object)"GlobalPathRegistry.getPath() for COMPILE returned null");
            }
            this.boot = globalPathRegistry.getPaths("classpath/boot");
            if (!$assertionsDisabled && this.boot == null) {
                throw new AssertionError((Object)"GlobalPathRegistry.getPath() for BOOT returned null");
            }
        } else {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)PropertyChangeListener.class, (EventListener)this, (Object)OpenProjects.getDefault()));
            this.sources = new HashSet();
            this.compile = new HashSet();
            this.boot = new HashSet();
            Iterator iterator = this.getRelevantProjects().iterator();
            while (iterator.hasNext()) {
                Project project = (Project)iterator.next();
                Sources sources = ProjectUtils.getSources((Project)project);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[i].getRootFolder(), (String)"classpath/source");
                    this.sources.add(classPath);
                    classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[i].getRootFolder(), (String)"classpath/compile");
                    this.compile.add(classPath);
                    classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[i].getRootFolder(), (String)"classpath/boot");
                    this.boot.add(classPath);
                }
            }
        }
    }

    private Collection getRelevantProjects() {
        HashSet<Project> hashSet = new HashSet<Project>();
        Iterator iterator = this.fileSet.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            }
            hashSet.addAll(Util.getSuperprojects(project));
            hashSet.add(project);
        }
        return hashSet;
    }

    private void addResources(Set set, Set set2, List list) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ClassPath classPath = (ClassPath)iterator.next();
            Iterator iterator2 = classPath.entries().iterator();
            while (iterator2.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)iterator2.next();
                URL uRL = entry.getURL();
                if (!$assertionsDisabled && uRL == null) {
                    throw new AssertionError((Object)"ClassPath.Entry.getURL() returned null");
                }
                if (RefactoringClassPathImplementation.isCovered(set2, uRL)) continue;
                list.add(ClassPathSupport.createResource((URL)uRL));
                set2.add(uRL);
            }
            classPath.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)(class$java$beans$PropertyChangeListener == null ? RefactoringClassPathImplementation.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener), (EventListener)this, (Object)classPath));
        }
    }

    private static boolean isCovered(Set set, URL uRL) {
        if (set.contains(uRL)) {
            return true;
        }
        FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
        if (!$assertionsDisabled && fileObjectArray == null) {
            throw new AssertionError((Object)"SourceForBinaryQuery.findSourceRoot() returned null.");
        }
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                if (!set.contains(fileObjectArray[i].getURL())) continue;
                return true;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return false;
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("resources", null, null);
    }

    public static synchronized ClassPath getDefault() {
        if (defaultInstance == null) {
            defaultInstance = ClassPathFactory.createClassPath((ClassPathImplementation)new RefactoringClassPathImplementation(Collections.EMPTY_SET));
        }
        return defaultInstance;
    }

    public static synchronized ClassPath getCustom(Collection collection) {
        if (!$assertionsDisabled && collection == null) {
            throw new AssertionError();
        }
        if (customInstance == null || !RefactoringClassPathImplementation.theSameProjects(collection, RefactoringClassPathImplementation.customInstanceSPI.fileSet)) {
            customInstanceSPI = new RefactoringClassPathImplementation(collection);
            customInstance = ClassPathFactory.createClassPath((ClassPathImplementation)customInstanceSPI);
        }
        return customInstance;
    }

    private static boolean theSameProjects(Collection collection, Collection collection2) {
        if (((Object)collection).equals(collection2)) {
            return true;
        }
        HashSet hashSet = RefactoringClassPathImplementation.getProjects(collection);
        HashSet hashSet2 = RefactoringClassPathImplementation.getProjects(collection2);
        return hashSet.equals(hashSet2);
    }

    private static HashSet getProjects(Collection collection) {
        HashSet<Project> hashSet = new HashSet<Project>(2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if (fileObject == null) continue;
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            hashSet.add(project);
        }
        return hashSet;
    }

    private static synchronized void resetCache() {
        defaultInstance = null;
        customInstance = null;
        Util.resetCache();
    }

    static {
        $assertionsDisabled = !RefactoringClassPathImplementation.class.desiredAssertionStatus();
    }
}

