/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.classpath;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Util {
    private static WeakHashMap superProjectsCache = null;

    private static WeakHashMap getSuperProjectsCache() {
        if (superProjectsCache == null) {
            superProjectsCache = new WeakHashMap();
        }
        return superProjectsCache;
    }

    public static Set getSuperprojects(Project project) {
        ClassPath classPath;
        int n;
        HashSet<ClassPath> hashSet = (HashSet<ClassPath>)Util.getSuperProjectsCache().get(project);
        if (hashSet != null) {
            return hashSet;
        }
        hashSet = new HashSet<ClassPath>();
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (n = 0; n < sourceGroupArray.length; ++n) {
            classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[n].getRootFolder(), (String)"classpath/source");
            hashSet2.addAll(Arrays.asList(classPath.getRoots()));
        }
        for (n = 0; n < projectArray.length; ++n) {
            classPath = projectArray[n];
            Sources sources2 = ProjectUtils.getSources((Project)classPath);
            SourceGroup[] sourceGroupArray2 = sources2.getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray2.length; ++i) {
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)sourceGroupArray2[i].getRootFolder(), (String)"classpath/compile");
                List list = classPath2.entries();
                Iterator iterator = classPath2.entries().iterator();
                while (iterator.hasNext()) {
                    URL uRL = ((ClassPath.Entry)iterator.next()).getURL();
                    FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
                    for (int j = 0; j < fileObjectArray.length; ++j) {
                        if (!hashSet2.contains(fileObjectArray[j])) continue;
                        hashSet.add(classPath);
                    }
                }
            }
        }
        Util.getSuperProjectsCache().put(project, hashSet);
        return hashSet;
    }

    static void resetCache() {
        superProjectsCache = null;
    }

    public static void setDefaultClassPath() {
        Util.setClassPath(RefactoringClassPathImplementation.getDefault());
    }

    public static void setClassPath(Element element) {
        if (element == null) {
            ErrorManager.getDefault().log(1, "Refactoring: setClassPath(null) should not be called. Setting default classpath");
            Util.setDefaultClassPath();
            return;
        }
        if (element != null && element.isValid()) {
            if (element instanceof JavaPackage) {
                Util.setDefaultClassPath();
            } else {
                Resource resource = element.getResource();
                if (resource == null) {
                    ErrorManager.getDefault().log(1, "Refactoring: el.getResource() returned null. el = " + element);
                    Util.setDefaultClassPath();
                    return;
                }
                if (Util.isLocal(element)) {
                    JavaModel.setClassPath((Resource)resource);
                    return;
                }
                FileObject fileObject = JavaModel.getFileObject((Resource)resource);
                if (fileObject == null) {
                    ErrorManager.getDefault().log(1, "Refactoring: JavaModel.getFileObject(res) returned null. res = " + resource.getName());
                    Util.setDefaultClassPath();
                    return;
                }
                Util.setClassPath(RefactoringClassPathImplementation.getCustom(Collections.singleton(fileObject)));
            }
        }
    }

    public static void setClassPath(Collection collection) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Resource resource = element.getResource();
            if (resource == null) {
                ErrorManager.getDefault().log(1, "Refactoring: el.getResource() returned null. el = " + element);
                Util.setDefaultClassPath();
                return;
            }
            FileObject fileObject = JavaModel.getFileObject((Resource)resource);
            if (fileObject == null) {
                ErrorManager.getDefault().log(1, "Refactoring: JavaModel.getFileObject(res) returned null. res = " + resource.getName());
                Util.setDefaultClassPath();
                return;
            }
            hashSet.add(fileObject);
        }
        Util.setClassPath(RefactoringClassPathImplementation.getCustom(hashSet));
    }

    private static void setClassPath(ClassPath classPath) {
        JavaModel.setClassPath((ClassPath)classPath);
        JMManager.getTransactionMutex().setSearchScope(Collections.singletonList(classPath));
    }

    public static boolean isUnderSourceRootOfOpenProjects(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClassPathRoot(FileObject fileObject) {
        return fileObject.equals(((JMManager)JMManager.getManager()).getMergedClassPath().findOwnerRoot(fileObject));
    }

    private static boolean isLocal(Element element) {
        if (element instanceof ClassMember) {
            return Modifier.isPrivate(((ClassMember)element).getModifiers());
        }
        return element instanceof Variable;
    }
}

