/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.jmiimpl.javamodel.CallableFeatureImpl;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ChangeParametersPlugin
extends JavaRefactoringPlugin
implements ProgressListener {
    RefObject selectedObject;
    CallableFeature method;
    ChangeParametersRefactoring.ParameterInfo[] paramTable;
    int modifier;
    private ChangeParametersRefactoring refactoring;

    public ChangeParametersPlugin(ChangeParametersRefactoring changeParametersRefactoring) {
        this.refactoring = changeParametersRefactoring;
        this.selectedObject = (RefObject)changeParametersRefactoring.getRefactoredObject();
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getParameterInfo(), this.refactoring.getModifiers());
    }

    public Problem fastCheckParameters() {
        return this.checkParameters(this.refactoring.getParameterInfo(), this.refactoring.getModifiers());
    }

    public Problem preCheck() {
        Object object;
        Problem problem = ChangeParametersPlugin.isElementAvail((Element)this.selectedObject);
        if (problem != null) {
            return problem;
        }
        if (!(this.selectedObject instanceof CallableFeature)) {
            return ChangeParametersPlugin.createProblem(problem, true, NbBundle.getMessage((Class)ChangeParametersRefactoring.class, (String)"ERR_ChangeParamsWrongType"));
        }
        if (CheckUtils.isFromLibrary(((CallableFeature)this.selectedObject).getResource())) {
            return ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.getCannotRefactor(((Element)this.selectedObject).getResource()));
        }
        if (!CheckUtils.isElementInOpenProject((Element)this.selectedObject)) {
            return new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
        }
        Collection collection = null;
        Collection collection2 = null;
        this.method = (CallableFeature)this.selectedObject;
        List list = this.method.getParameters();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Parameter)iterator.next();
            arrayList.add(object.getType());
        }
        if (this.method instanceof Method) {
            collection = CheckUtils.overrides((Method)this.method, this.method.getName(), arrayList, true);
            collection2 = CheckUtils.isOverridden((Method)this.method, this.method.getName(), arrayList);
        }
        if (CheckUtils.hasVarArgs(this.method)) {
            iterator = ChangeParametersPlugin.getString("ERR_HasVarArg");
            problem = ChangeParametersPlugin.createProblem(problem, true, iterator);
        }
        if (collection != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = new MessageFormat(ChangeParametersPlugin.getString("ERR_MethodOverrides")).format(new Object[]{this.getDefClassName(((Method)iterator.next()).getDeclaringClass())});
                problem = ChangeParametersPlugin.createProblem(problem, false, (String)object);
            }
        }
        if (collection2 != null) {
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                object = new MessageFormat(ChangeParametersPlugin.getString("ERR_MethodIsOverridden")).format(new Object[]{this.getDefClassName(((Method)iterator.next()).getDeclaringClass())});
                problem = ChangeParametersPlugin.createProblem(problem, false, (String)object);
            }
        }
        return problem;
    }

    private static final String getCannotRefactor(Resource resource) {
        return new MessageFormat(NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_CannotRefactorFile")).format(new Object[]{resource.getName()});
    }

    private Problem checkParameters(ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray, int n) {
        Object object;
        ClassDefinition classDefinition;
        if ((this.method.getModifiers() & n) == 0 && (classDefinition = this.method.getDeclaringClass()) instanceof JavaClass && ((JavaClass)classDefinition).isInterface()) {
            return new Problem(true, ChangeParametersPlugin.getString("ERR_CannotChangeModifiers"));
        }
        classDefinition = this.paramTable;
        int n2 = this.modifier;
        this.paramTable = parameterInfoArray;
        this.modifier = n;
        Problem problem = this.checkParameterAttributes();
        Object object2 = null;
        HashSet<String> hashSet = new HashSet<String>(3);
        for (int i = 0; i < this.paramTable.length; ++i) {
            Type type = this.paramTable[i].getType();
            if (type != null && type.getName() != null && type.getName().endsWith("...")) {
                object2 = ChangeParametersPlugin.createProblem(object2, true, ChangeParametersPlugin.getString("ERR_HasVarArg"));
            }
            String string = null;
            int n3 = this.paramTable[i].getOriginalIndex();
            string = n3 > -1 ? ((Parameter)this.method.getParameters().get(n3)).getName() : this.paramTable[i].getName();
            if (string != null && !Utilities.isJavaIdentifier((String)string)) {
                String string2 = new MessageFormat(ChangeParametersPlugin.getString("ERR_InvalidIdentifier")).format(new Object[]{string});
                object2 = ChangeParametersPlugin.createProblem((Problem)object2, true, string2);
            }
            if (string != null && !hashSet.add(string)) {
                object2 = ChangeParametersPlugin.createProblem((Problem)object2, true, new MessageFormat(ChangeParametersPlugin.getString("ERR_DuplicateName")).format(new Object[]{string}));
            }
            if (n3 != -1 || string == null || !CheckUtils.getAllVariableNames((Feature)this.method).contains(string)) continue;
            object2 = ChangeParametersPlugin.createProblem((Problem)object2, true, new MessageFormat(ChangeParametersPlugin.getString("ERR_NameAlreadyUsed")).format(new Object[]{string}));
        }
        if (this.method instanceof Method) {
            object = this.methodClashes(this.paramTable);
            if (object != null && !this.method.equals(object)) {
                object2 = ChangeParametersPlugin.createProblem((Problem)object2, true, new MessageFormat(ChangeParametersPlugin.getString("ERR_existingMethod")).format(new Object[]{object.getName(), this.getDefClassName(object.getDeclaringClass())}));
            }
        } else {
            object = this.constructorClashes(this.paramTable);
            if (object != null && !this.method.equals(object)) {
                object2 = ChangeParametersPlugin.createProblem((Problem)object2, true, new MessageFormat(ChangeParametersPlugin.getString("ERR_existingConstr")).format(new Object[]{this.getDefClassName(object.getDeclaringClass())}));
            }
        }
        if (problem != null) {
            object = problem;
            while (((Problem)object).getNext() != null) {
                object = ((Problem)object).getNext();
            }
            ((Problem)object).setNext((Problem)object2);
            object2 = object;
        }
        this.paramTable = classDefinition;
        this.modifier = n2;
        return object2;
    }

    private Problem setParameters(ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray, int n) {
        this.paramTable = parameterInfoArray;
        this.modifier = n;
        return this.checkParameters(parameterInfoArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem;
        block14: {
            block13: {
                JavaMetamodel.getManager().getProgressSupport().addProgressListener((ProgressListener)this);
                Problem problem2 = null;
                try {
                    int n = this.method.getModifiers() & 7;
                    boolean bl = ChangeParametersPlugin.compareModifiers(n, this.modifier) == -1;
                    this.referencesIterator = ((CallableFeatureImpl)this.method).findDependencies(true, true, true).iterator();
                    refactoringElementsBag.add(this.refactoring, new SignatureElement(this.method, this.paramTable, this.modifier));
                    int n2 = ((CallableFeature)this.refactoring.getRefactoredObject()).getParameters().size();
                    while (this.referencesIterator.hasNext()) {
                        if (this.cancelRequest) {
                            problem = null;
                            Object var10_9 = null;
                            this.referencesIterator = null;
                            break block13;
                        }
                        problem = (Problem)this.referencesIterator.next();
                        if (problem instanceof Invocation) {
                            if (((Invocation)problem).getParameters().size() != n2) continue;
                            if (problem2 == null && bl) {
                                String string;
                                Feature feature = JavaModelUtil.getDeclaringFeature((Element)((Invocation)problem));
                                if (Modifier.isPrivate(this.modifier)) {
                                    if (!Utilities.compareObjects((Object)ChangeParametersPlugin.getOutermostClass(feature), (Object)ChangeParametersPlugin.getOutermostClass((Feature)this.method))) {
                                        string = ChangeParametersPlugin.getString("ERR_StrongAccMod");
                                        problem2 = new Problem(false, new MessageFormat(string).format(new Object[]{"private"}));
                                    }
                                } else if (Modifier.isProtected(this.modifier)) {
                                    if (!this.method.getResource().getPackageName().equals(feature.getResource().getPackageName())) {
                                        string = ChangeParametersPlugin.getString("ERR_StrongAccMod");
                                        problem2 = new Problem(false, new MessageFormat(string).format(new Object[]{"protected"}));
                                    }
                                } else if (this.modifier == 0 && !feature.getResource().getPackageName().equals(this.method.getResource().getPackageName())) {
                                    string = ChangeParametersPlugin.getString("ERR_StrongAccMod");
                                    problem2 = new Problem(false, new MessageFormat(string).format(new Object[]{"default"}));
                                }
                            }
                            refactoringElementsBag.add(this.refactoring, new CallerElement((Invocation)problem, this.paramTable));
                            continue;
                        }
                        refactoringElementsBag.add(this.refactoring, new SignatureElement((CallableFeature)problem, this.paramTable, this.modifier));
                    }
                    problem = problem2;
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    this.referencesIterator = null;
                    JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
                    throw throwable;
                }
            }
            JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
            return problem;
        }
        Object var10_10 = null;
        this.referencesIterator = null;
        JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
        return problem;
    }

    private Problem checkParameterAttributes() {
        Problem problem = null;
        for (int i = 0; i < this.paramTable.length; ++i) {
            int n = this.paramTable[i].getOriginalIndex();
            String string = this.paramTable[i].getName();
            if (n == -1 && (string == null || string.length() < 1)) {
                problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_parname"));
            }
            Type type = this.paramTable[i].getType();
            if (n == -1 && type == null) {
                problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_partype"));
            }
            string = this.paramTable[i].getDefaultValue();
            if (n != -1 || string != null && string.length() >= 1) continue;
            problem = ChangeParametersPlugin.createProblem(problem, true, ChangeParametersPlugin.newParMessage("ERR_pardefv"));
        }
        return problem;
    }

    private Method methodClashes(ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray) {
        if (!(this.method instanceof Method)) {
            return null;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>(parameterInfoArray.length);
        List list = this.method.getParameters();
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            Type type = parameterInfoArray[i].getType();
            if (type == null) {
                type = ((Parameter)list.get(parameterInfoArray[i].getOriginalIndex())).getType();
            }
            arrayList.add(type);
        }
        return this.method.getDeclaringClass().getMethod(this.method.getName(), arrayList, false);
    }

    private Constructor constructorClashes(ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray) {
        if (!(this.method instanceof Constructor)) {
            return null;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>(parameterInfoArray.length);
        List list = this.method.getParameters();
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            Type type = parameterInfoArray[i].getType();
            if (type == null) {
                type = ((Parameter)list.get(parameterInfoArray[i].getOriginalIndex())).getType();
            }
            arrayList.add(type);
        }
        return this.method.getDeclaringClass().getConstructor(arrayList, false);
    }

    private static String newParMessage(String string) {
        return new MessageFormat(ChangeParametersPlugin.getString("ERR_newpar")).format(new Object[]{ChangeParametersPlugin.getString(string)});
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)ChangeParametersRefactoring.class, (String)string);
    }

    private String getDefClassName(ClassDefinition classDefinition) {
        if (classDefinition instanceof JavaClass) {
            return ((JavaClass)classDefinition).getName();
        }
        return "";
    }

    private static int compareModifiers(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        int[] nArray = new int[]{n, n2};
        for (int i = 0; i < 2; ++i) {
            nArray[i] = Modifier.isPublic(nArray[i]) ? 0 : (Modifier.isProtected(nArray[i]) ? 1 : (Modifier.isPrivate(nArray[i]) ? 3 : 2));
        }
        return nArray[0] > nArray[1] ? 1 : -1;
    }

    private static JavaClass getOutermostClass(Feature feature) {
        RefFeatured refFeatured = feature.refImmediateComposite();
        RefFeatured refFeatured2 = null;
        while (refFeatured != null && !(refFeatured instanceof Resource)) {
            refFeatured2 = refFeatured;
            refFeatured = ((RefObject)refFeatured).refImmediateComposite();
        }
        if (refFeatured2 instanceof JavaClass) {
            return (JavaClass)refFeatured2;
        }
        return null;
    }

    public void start(ProgressEvent progressEvent) {
        this.fireProgressListenerStart(progressEvent.getOperationType(), progressEvent.getCount());
    }

    public void step(ProgressEvent progressEvent) {
        this.fireProgressListenerStep();
    }

    public void stop(ProgressEvent progressEvent) {
        this.fireProgressListenerStop();
    }

    static class SignatureElement
    extends SimpleRefactoringElementImpl {
        private PositionBounds bounds;
        private final CallableFeature element;
        private ChangeParametersRefactoring.ParameterInfo[] paramTable;
        private int modifier;
        private final String displayText;
        private final String text;

        public SignatureElement(CallableFeature callableFeature, ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray, int n) {
            this.element = callableFeature;
            this.paramTable = parameterInfoArray;
            this.bounds = null;
            this.modifier = n;
            String string = ChangeParametersPlugin.getString("LBL_chngsigdecl");
            Object[] objectArray = new Object[2];
            String string2 = callableFeature instanceof Method ? "LBL_Method" : "LBL_Constructor";
            objectArray[0] = ChangeParametersPlugin.getString(string2);
            int n2 = callableFeature.getPartStartOffset((ElementPartKind)ElementPartKindEnum.HEADER);
            int n3 = callableFeature.getPartEndOffset((ElementPartKind)ElementPartKindEnum.HEADER);
            objectArray[1] = callableFeature.getResource().getSourceText().substring(n2, n3);
            this.text = MessageFormat.format(string, objectArray);
            objectArray[1] = "<b>" + objectArray[1] + "</b>";
            this.displayText = MessageFormat.format(string, objectArray);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void performChange() {
            List list = this.element.getParameters();
            Parameter[] parameterArray = list.toArray(new Parameter[0]);
            int n = this.element.getModifiers();
            if ((n & this.modifier) == 0) {
                int n2 = n & 0xFFFFFFF8 | this.modifier;
                this.element.setModifiers(n2);
            }
            list.clear();
            JavaModelPackage javaModelPackage = (JavaModelPackage)this.getJavaElement().refImmediatePackage();
            for (int i = 0; i < this.paramTable.length; ++i) {
                ChangeParametersRefactoring.ParameterInfo parameterInfo = this.paramTable[i];
                int n3 = parameterInfo.getOriginalIndex();
                Parameter parameter = null;
                if (n3 == -1) {
                    parameter = javaModelPackage.getParameter().createParameter();
                    parameter.setName(parameterInfo.getName());
                    parameter.setType(parameterInfo.getType());
                } else {
                    parameter = parameterArray[n3];
                    String string = parameterInfo.getName();
                    if (string != null) {
                        parameter.setName(string);
                    }
                    if ((string = parameterInfo.getType()) != null) {
                        parameter.setType((Type)string);
                    }
                }
                list.add(parameter);
            }
        }

        public void undoChange() {
            throw new UnsupportedOperationException();
        }

        public Element getJavaElement() {
            return this.element;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.element);
            }
            return this.bounds;
        }

        public FileObject getParentFile() {
            return null;
        }
    }

    static class CallerElement
    extends SimpleRefactoringElementImpl {
        private PositionBounds bounds;
        private final Invocation element;
        private ChangeParametersRefactoring.ParameterInfo[] paramTable;
        private final String text;
        private final String displayText;
        private List paramList = Collections.EMPTY_LIST;
        private RefObject comp = null;

        public CallerElement(Invocation invocation, ChangeParametersRefactoring.ParameterInfo[] parameterInfoArray) {
            this.element = invocation;
            this.paramTable = parameterInfoArray;
            this.bounds = null;
            Element element = CallerElement.getDisplayElement((Element)invocation);
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            int n3 = invocation.getPartStartOffset((ElementPartKind)ElementPartKindEnum.NAME);
            int n4 = invocation.getEndOffset();
            String string = invocation.getResource().getSourceText();
            this.text = string.substring(n, n2);
            this.displayText = string.substring(n, n3) + "<b>" + string.substring(n3, n4) + "</b>" + string.substring(n4, n2);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void performChange() {
            List list = this.element.getParameters();
            Element[] elementArray = list.toArray(new Element[0]);
            list.clear();
            for (int i = 0; i < this.paramTable.length; ++i) {
                Element element;
                ChangeParametersRefactoring.ParameterInfo parameterInfo = this.paramTable[i];
                int n = parameterInfo.getOriginalIndex();
                if (n == -1) {
                    JavaModelPackage javaModelPackage = (JavaModelPackage)this.getJavaElement().refImmediatePackage();
                    element = javaModelPackage.getMultipartId().createMultipartId(parameterInfo.getDefaultValue(), null, null);
                } else {
                    element = elementArray[n];
                }
                list.add(element);
            }
        }

        public Element getJavaElement() {
            if (this.comp == null) {
                this.comp = this.element;
                while (!(this.comp instanceof Feature) && !(this.comp instanceof Resource)) {
                    this.comp = (RefObject)this.comp.refImmediateComposite();
                }
            }
            return (Element)this.comp;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.element);
            }
            return this.bounds;
        }

        private static Element getDisplayElement(Element element) {
            Element element2 = element;
            while (!(element2 instanceof Feature) && !(element2.refImmediateComposite() instanceof StatementBlock)) {
                element2 = (Element)element2.refImmediateComposite();
            }
            return element2;
        }

        public FileObject getParentFile() {
            return null;
        }
    }
}

