/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.ArrayReferenceClass;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.ChangeModElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.CreateMethodElement;
import org.netbeans.modules.refactoring.EncapsulateFieldElement;
import org.netbeans.modules.refactoring.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class EncapsulateFieldRefactoringPlugin
extends JavaRefactoringPlugin {
    private final RefObject jmiObject;
    private Field encapsulatedField;
    private String getterName;
    private String setterName;
    private int methodModifiers;
    private int fieldModifiers;
    private Method currentGetter;
    private Method currentSetter;
    private static int accessModifiers = 7;
    private boolean alwaysUseAccessors;
    private EncapsulateFieldRefactoring refactoring;
    public static final String CLASS_FIELD_PREFIX = "_";

    public EncapsulateFieldRefactoringPlugin(EncapsulateFieldRefactoring encapsulateFieldRefactoring) {
        this.refactoring = encapsulateFieldRefactoring;
        this.jmiObject = (RefObject)encapsulateFieldRefactoring.getRefactoredObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 2);
        try {
            Problem problem = EncapsulateFieldRefactoringPlugin.isElementAvail((Element)this.jmiObject);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            this.fireProgressListenerStep();
            if (!(this.jmiObject instanceof Field) || this.jmiObject instanceof EnumConstant) {
                Problem problem3 = EncapsulateFieldRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage((Class)EncapsulateFieldRefactoring.class, (String)"ERR_EncapsulateWrongType"));
                return problem3;
            }
            this.encapsulatedField = (Field)this.jmiObject;
            if (!CheckUtils.isElementInOpenProject((Element)this.jmiObject)) {
                Problem problem4 = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem4;
            }
            Problem problem5 = problem;
            return problem5;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        return this.checkParameters(this.refactoring.getGetterName(), this.refactoring.getSetterName(), this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors());
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getGetterName(), this.refactoring.getSetterName(), this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors());
    }

    private Problem checkParameters(String string, String string2, int n, int n2, boolean bl) {
        if (string != null && !Utilities.isJavaIdentifier((String)string) || string2 != null && !Utilities.isJavaIdentifier((String)string2) || string == null && string2 == null) {
            return new Problem(true, NbBundle.getMessage((Class)EncapsulateFieldRefactoring.class, (String)"ERR_EncapsulateMethods"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem setParameters(String string, String string2, int n, int n2, boolean bl) {
        Object var6_6 = null;
        this.fireProgressListenerStart(2, 8);
        try {
            this.setterName = string2;
            this.getterName = string;
            this.methodModifiers = n;
            this.fieldModifiers = n2;
            this.alwaysUseAccessors = bl;
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    private TypeReference getTypeReference() {
        TypeReference typeReference = this.encapsulatedField.getTypeName();
        int n = this.encapsulatedField.getDimCount();
        typeReference = (TypeReference)typeReference.duplicate();
        if (n > 0) {
            if (typeReference instanceof ArrayReference) {
                ArrayReference arrayReference = (ArrayReference)typeReference;
                arrayReference.setDimCount(arrayReference.getDimCount() + n);
            } else {
                ArrayReferenceClass arrayReferenceClass = ((JavaModelPackage)this.encapsulatedField.refImmediatePackage()).getArrayReference();
                typeReference = arrayReferenceClass.createArrayReference(null, (MultipartId)typeReference, n);
            }
        }
        return typeReference;
    }

    private void createGetterAndSetter(RefactoringElementsBag refactoringElementsBag) {
        Object object;
        String string = this.encapsulatedField.getName();
        int n = this.encapsulatedField.getModifiers() & 8;
        String string2 = n != 0 ? "a" + EncapsulateFieldRefactoringPlugin.getCapitalizedName(this.encapsulatedField) : EncapsulateFieldRefactoringPlugin.stripPrefix(string);
        String string3 = "return ".concat(string).concat(";");
        String string4 = (n == 0 ? "this." : "").concat(string).concat(" = ").concat(string2).concat(";");
        Type type = this.encapsulatedField.getType();
        ClassDefinition classDefinition = this.encapsulatedField.getDeclaringClass();
        JavaModelPackage javaModelPackage = (JavaModelPackage)classDefinition.refImmediatePackage();
        TypeReference typeReference = this.getTypeReference();
        Parameter parameter = javaModelPackage.getParameter().createParameter(string2, null, false, null, 0, false);
        int n2 = this.methodModifiers | n;
        List list = classDefinition.getContents();
        ListIterator listIterator = list.listIterator(list.size());
        ClassMember classMember = null;
        JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
        while (listIterator.hasPrevious() && javaMetamodel.isElementGuarded((Element)(object = (ClassMember)listIterator.previous()))) {
            classMember = object;
        }
        parameter.setTypeName(typeReference);
        Method method = this.currentGetter = this.getterName != null ? classDefinition.getMethod(this.getterName, Collections.EMPTY_LIST, false) : null;
        if (this.currentGetter == null && this.getterName != null) {
            object = new CreateMethodElement(n2, this.getterName, typeReference, Collections.EMPTY_LIST, string3, classMember, classDefinition, true);
            refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)object);
        }
        Method method2 = this.currentSetter = this.setterName != null ? classDefinition.getMethod(this.setterName, Collections.singletonList(type), false) : null;
        if (this.currentSetter == null && this.setterName != null) {
            boolean bl = !Modifier.isFinal(this.encapsulatedField.getModifiers());
            CreateMethodElement createMethodElement = new CreateMethodElement(n2, this.setterName, null, Collections.singletonList(parameter), string4, classMember, classDefinition, bl);
            refactoringElementsBag.add(this.refactoring, createMethodElement);
        }
    }

    private static String stripPrefix(String string) {
        String string2 = string.startsWith(CLASS_FIELD_PREFIX) ? string.substring(CLASS_FIELD_PREFIX.length()) : string;
        return string2;
    }

    private static StringBuffer getCapitalizedName(Field field) {
        StringBuffer stringBuffer = new StringBuffer(EncapsulateFieldRefactoringPlugin.stripPrefix(field.getName()));
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return stringBuffer;
    }

    public static String computeSetterName(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return null;
        }
        StringBuffer stringBuffer = EncapsulateFieldRefactoringPlugin.getCapitalizedName(field);
        stringBuffer.insert(0, "set");
        return stringBuffer.toString();
    }

    public static String computeGetterName(Field field) {
        StringBuffer stringBuffer = EncapsulateFieldRefactoringPlugin.getCapitalizedName(field);
        Type type = field.getType();
        if (type instanceof PrimitiveType && ((PrimitiveType)type).getKind().equals(PrimitiveTypeKindEnum.BOOLEAN)) {
            stringBuffer.insert(0, "is");
        } else {
            stringBuffer.insert(0, "get");
        }
        return stringBuffer.toString();
    }

    private boolean isOutsideGetterSetter(Element element) {
        Feature feature = JavaModelUtil.getDeclaringFeature((Element)element);
        return !feature.equals(this.currentGetter) && !feature.equals(this.currentSetter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        this.fireProgressListenerStart(3, 9);
        try {
            int n;
            this.fireProgressListenerStep();
            this.referencesIterator = this.encapsulatedField.getReferences().iterator();
            int n2 = n = this.encapsulatedField.getModifiers();
            if ((n & accessModifiers) != this.fieldModifiers) {
                int n3;
                n2 = n3 = n & ~accessModifiers | this.fieldModifiers;
                refactoringElementsBag.add(this.refactoring, new ChangeModElement((Feature)this.encapsulatedField, n3));
            }
            this.createGetterAndSetter(refactoringElementsBag);
            while (this.referencesIterator.hasNext()) {
                if (this.cancelRequest) {
                    Problem problem = null;
                    return problem;
                }
                Element element = (Element)this.referencesIterator.next();
                if (!this.isOutsideGetterSetter(element)) continue;
                boolean bl = true;
                VariableAccess variableAccess = (VariableAccess)element;
                boolean bl2 = variableAccess.isWrite();
                if (!this.alwaysUseAccessors) {
                    boolean bl3 = bl = !EncapsulateFieldRefactoringPlugin.isAccessible(variableAccess, n2);
                }
                if ((!bl2 || this.setterName == null) && (bl2 || this.getterName == null)) continue;
                refactoringElementsBag.add(this.refactoring, new EncapsulateFieldElement(this.encapsulatedField, (VariableAccess)element, this.getterName, this.setterName, bl, bl2));
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.referencesIterator = null;
            this.fireProgressListenerStop();
        }
    }

    private static final boolean isAccessible(VariableAccess variableAccess, int n) {
        if (Modifier.isPublic(n)) {
            return true;
        }
        ClassDefinition classDefinition = ((Field)variableAccess.getElement()).getDeclaringClass();
        if (Modifier.isPrivate(n)) {
            ClassDefinition classDefinition2 = EncapsulateFieldRefactoringPlugin.getClassDefinition((Element)variableAccess);
            return classDefinition2.equals(classDefinition);
        }
        if (Modifier.isProtected(n)) {
            if (EncapsulateFieldRefactoringPlugin.isTheSamePackage(variableAccess)) {
                return true;
            }
            ClassDefinition classDefinition3 = EncapsulateFieldRefactoringPlugin.getClassDefinition((Element)variableAccess);
            do {
                if (!classDefinition3.isSubTypeOf(classDefinition)) continue;
                return true;
            } while ((classDefinition3 = EncapsulateFieldRefactoringPlugin.getClassDefinition((Element)classDefinition3)) != null);
            return false;
        }
        return EncapsulateFieldRefactoringPlugin.isTheSamePackage(variableAccess);
    }

    private static final boolean isTheSamePackage(VariableAccess variableAccess) {
        return variableAccess.getResource().getPackageName().equals(variableAccess.getElement().getResource().getPackageName());
    }

    private static final ClassDefinition getClassDefinition(Element element) {
        Element element2 = (Element)element.refImmediateComposite();
        if (element2 instanceof Resource || element2 instanceof JavaPackage) {
            return null;
        }
        while (!(element2 instanceof ClassDefinition)) {
            element2 = (Element)element2.refImmediateComposite();
        }
        return (ClassDefinition)element2;
    }

    public Field getEncapsulatedField() {
        return this.encapsulatedField;
    }
}

