/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.ArrayReference;
import org.netbeans.jmi.javamodel.Assignment;
import org.netbeans.jmi.javamodel.BreakStatement;
import org.netbeans.jmi.javamodel.Case;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.ContinueStatement;
import org.netbeans.jmi.javamodel.DoStatement;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.ForEachStatement;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.IfStatement;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVarDeclarationClass;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.LocalVariableClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Operator;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ReturnStatement;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.SwitchStatement;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.jmi.javamodel.VariableAccessClass;
import org.netbeans.jmi.javamodel.WhileStatement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.ExtractMethodRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExtractMethodRefactoringPlugin
extends JavaRefactoringPlugin {
    private ExtractMethodRefactoring refactoring;
    private Statement firstStatement;
    private Statement lastStatement;
    private List selectedStatements;
    private Set writeVars;
    private Set readVars;
    private Set unusedDeclVars;
    private Set declVars;
    private Set newLocalVars;
    private Set exceptions;
    private Variable returnedVariable;
    private Feature feature;
    private TypeReference returnType;
    private boolean retValDefinedInSelectedStmts;
    private boolean hasReturn;

    public ExtractMethodRefactoringPlugin(ExtractMethodRefactoring extractMethodRefactoring) {
        this.refactoring = extractMethodRefactoring;
        this.writeVars = new HashSet();
        this.readVars = new HashSet();
        this.unusedDeclVars = new HashSet();
        this.declVars = new HashSet();
        this.newLocalVars = new HashSet();
    }

    public Problem checkParameters() {
        String string;
        Problem problem = this.fastCheckParameters();
        if (problem != null) {
            return problem;
        }
        List list = this.getParamTypes();
        ClassDefinition classDefinition = this.getFeature().getDeclaringClass();
        if (classDefinition.getMethod(string = this.refactoring.getName(), list, false) != null) {
            String string2 = new MessageFormat(ExtractMethodRefactoringPlugin.getString("ERR_MethodClash")).format(new Object[]{string, this.getDefClassName(classDefinition)});
            return ExtractMethodRefactoringPlugin.createProblem(null, true, string2);
        }
        return null;
    }

    public Problem fastCheckParameters() {
        Problem problem = this.checkName(this.refactoring.getName());
        if (problem != null) {
            return problem;
        }
        ExtractMethodRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParamTable();
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            problem = this.checkName(parameterInfoArray[i].getName());
            if (problem == null) continue;
            return problem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 8);
        try {
            if (this.refactoring.getStartOffset() < 0 || this.refactoring.getEndOffset() < 0) {
                Problem problem = ExtractMethodRefactoringPlugin.createProblem(null, true, ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodWrongElement"));
                return problem;
            }
            this.fireProgressListenerStep();
            Problem problem = this.checkStatements();
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            this.fireProgressListenerStep();
            problem = this.checkJump();
            if (problem != null) {
                Problem problem3 = problem;
                return problem3;
            }
            this.fireProgressListenerStep();
            this.computeAllVaribleAccess(this.selectedStatements);
            this.fireProgressListenerStep();
            problem = this.checkReturnValue();
            if (problem != null) {
                Problem problem4 = problem;
                return problem4;
            }
            this.fireProgressListenerStep();
            problem = this.computeExceptions();
            if (problem != null) {
                Problem problem5 = problem;
                return problem5;
            }
            this.fireProgressListenerStep();
            this.computeDuplicatedVars();
            this.fireProgressListenerStep();
            this.refactoring.setParamTable(this.getInputParameters());
            this.refactoring.setReturnType(this.getReturnType());
            this.refactoring.setStaticMod(Modifier.isStatic(this.getFeature().getModifiers()));
            this.fireProgressListenerStep();
            Problem problem6 = null;
            return problem6;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        refactoringElementsBag.add(this.refactoring, new ExtractMethodElement());
        return null;
    }

    private Problem checkStatements() {
        Resource resource = this.refactoring.getResource();
        int n = this.refactoring.getStartOffset();
        int n2 = this.refactoring.getEndOffset();
        this.selectedStatements = JavaModelUtil.getSelectedStatements((Resource)resource, (int)n, (int)n2);
        if (this.selectedStatements == null) {
            return ExtractMethodRefactoringPlugin.createProblem(null, true, ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodWrongSelection"));
        }
        return null;
    }

    private Problem checkJump() {
        Iterator iterator = this.selectedStatements.iterator();
        Object object = null;
        while (iterator.hasNext()) {
            Statement statement = this.findJump((Statement)iterator.next(), false);
            if (statement == null) continue;
            if (object == null) {
                object = statement;
                continue;
            }
            if (!object.refClass().equals(statement.refClass())) {
                return ExtractMethodRefactoringPlugin.createProblem(null, true, ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodContainsFixBreakReturn"));
            }
            object = statement;
        }
        if (object == null) {
            return null;
        }
        if (!object.equals(this.getLastStatement())) {
            return ExtractMethodRefactoringPlugin.createProblem(null, true, ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodContainsBreakOrReturn"));
        }
        if (object instanceof ReturnStatement && ((ReturnStatement)object).getExpression() != null) {
            this.hasReturn = true;
            return null;
        }
        this.selectedStatements.remove(this.selectedStatements.size() - 1);
        return null;
    }

    private Boolean readsVariableAfterSelection(Variable variable) {
        Element element = (Element)variable.refImmediateComposite();
        if (element instanceof LocalVarDeclaration) {
            element = (Element)element.refImmediateComposite();
        }
        Statement statement = this.getLastStatement();
        int n = statement.getEndOffset();
        List list = element.getChildren();
        VariableAnalyzer variableAnalyzer = new VariableAnalyzer(variable, n + 1, element.getEndOffset());
        return variableAnalyzer.readsVariableInElement(list);
    }

    private Statement findJump(Statement statement, boolean bl) {
        if (statement instanceof ReturnStatement) {
            return statement;
        }
        if (!bl && (statement instanceof BreakStatement || statement instanceof ContinueStatement)) {
            return statement;
        }
        if (statement instanceof SwitchStatement || statement instanceof WhileStatement || statement instanceof DoStatement || statement instanceof ForStatement || statement instanceof ForEachStatement) {
            bl = true;
        }
        Iterator iterator = statement.getChildren().iterator();
        while (iterator.hasNext()) {
            Statement statement2;
            Element element = (Element)iterator.next();
            if (!(element instanceof Statement) || element instanceof JavaClass || (statement2 = this.findJump((Statement)element, bl)) == null) continue;
            return statement2;
        }
        return null;
    }

    ExtractMethodRefactoring.ParameterInfo[] getInputParameters() {
        VariableAnalyzer variableAnalyzer;
        Variable variable;
        ArrayList<ExtractMethodRefactoring.ParameterInfo> arrayList = new ArrayList<ExtractMethodRefactoring.ParameterInfo>();
        Iterator iterator = this.readVars.iterator();
        while (iterator.hasNext()) {
            variable = (Variable)iterator.next();
            variableAnalyzer = new VariableAnalyzer(variable);
            if (Boolean.FALSE.equals(variableAnalyzer.readsVariableInElement(this.selectedStatements))) {
                this.newLocalVars.add(variable);
                continue;
            }
            arrayList.add(new ExtractMethodRefactoring.ParameterInfo(variable));
        }
        iterator = this.writeVars.iterator();
        while (iterator.hasNext()) {
            variable = (Variable)iterator.next();
            variableAnalyzer = new VariableAnalyzer(variable);
            if (this.readVars.contains(variable) || this.isInsideSelectedStatements((Element)variable)) continue;
            if (Boolean.FALSE.equals(variableAnalyzer.readsVariableInElement(this.selectedStatements))) {
                this.newLocalVars.add(variable);
                continue;
            }
            arrayList.add(new ExtractMethodRefactoring.ParameterInfo(variable));
        }
        return arrayList.toArray(new ExtractMethodRefactoring.ParameterInfo[arrayList.size()]);
    }

    private Problem checkReturnValue() {
        Object object;
        int n = this.getLastStatement().getEndOffset();
        HashSet<Object> hashSet = new HashSet<Object>();
        this.checkLoop(hashSet);
        Iterator iterator = this.writeVars.iterator();
        while (iterator.hasNext()) {
            object = (Variable)iterator.next();
            if (!Boolean.TRUE.equals(this.readsVariableAfterSelection((Variable)object))) continue;
            hashSet.add(object);
        }
        if (hashSet.size() > 1) {
            Object object2;
            object = new StringBuffer();
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object2 = (Variable)iterator.next();
                ((StringBuffer)object).append(object2.getName()).append(' ');
            }
            object2 = new MessageFormat(ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodTooMuchRetValues")).format(new Object[]{object});
            return ExtractMethodRefactoringPlugin.createProblem(null, true, (String)object2);
        }
        if (this.hasReturn && !hashSet.isEmpty()) {
            object = (Variable)hashSet.iterator().next();
            String string = object.getName();
            String string2 = new MessageFormat(ExtractMethodRefactoringPlugin.getString("ERR_ExtractMethodRetValueAndReturn")).format(new Object[]{string});
            return ExtractMethodRefactoringPlugin.createProblem(null, true, string2);
        }
        if (!hashSet.isEmpty()) {
            this.returnedVariable = (Variable)hashSet.iterator().next();
            this.retValDefinedInSelectedStmts = this.isInsideSelectedStatements((Element)this.returnedVariable);
        }
        return null;
    }

    private void checkLoop(Set set) {
        boolean bl = false;
        Statement statement = this.getFirstStatement();
        while (!(statement instanceof ClassMember)) {
            if (!((statement = (Element)statement.refImmediateComposite()) instanceof WhileStatement) && !(statement instanceof ForStatement) && !(statement instanceof DoStatement)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        Iterator iterator = this.writeVars.iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            if (!this.readVars.contains(variable)) continue;
            set.add(variable);
        }
    }

    private Problem computeExceptions() {
        this.exceptions = JavaModelUtil.getExceptionsFromStatements((List)this.selectedStatements);
        return null;
    }

    private void computeAllVaribleAccess(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e;
            block7: {
                Object object;
                VariableAccess variableAccess;
                block6: {
                    e = iterator.next();
                    if (!(e instanceof VariableAccess)) break block6;
                    variableAccess = (VariableAccess)e;
                    object = (Variable)variableAccess.getElement();
                    if (object instanceof Field) break block7;
                    if (this.isInsideSelectedStatements((Element)object) && !this.selectedStatements.contains(object)) continue;
                    this.unusedDeclVars.remove(variableAccess);
                    if (variableAccess.isWrite()) {
                        this.writeVars.add(object);
                    }
                    if (!variableAccess.isRead()) break block7;
                    this.readVars.add(object);
                    break block7;
                }
                if (e instanceof MultipartId) continue;
                if (e instanceof LocalVarDeclaration && this.selectedStatements.contains(e)) {
                    variableAccess = (LocalVarDeclaration)e;
                    object = variableAccess.getVariables().iterator();
                    while (object.hasNext()) {
                        LocalVariable localVariable = (LocalVariable)object.next();
                        if (localVariable.getInitialValue() != null) {
                            this.writeVars.add(localVariable);
                        } else {
                            this.unusedDeclVars.add(localVariable);
                        }
                        this.declVars.add(localVariable);
                    }
                }
            }
            this.computeAllVaribleAccess(((Element)e).getChildren());
        }
    }

    private boolean isInsideSelectedStatements(Element element) {
        int n = element.getStartOffset();
        return n >= this.getFirstStatement().getStartOffset() && n <= this.getLastStatement().getEndOffset();
    }

    private Problem checkName(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string2 = new MessageFormat(ExtractMethodRefactoringPlugin.getString("ERR_InvalidIdentifier")).format(new Object[]{string});
            return ExtractMethodRefactoringPlugin.createProblem(null, true, string2);
        }
        return null;
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)ExtractMethodRefactoring.class, (String)string);
    }

    String getDefClassName(ClassDefinition classDefinition) {
        if (classDefinition instanceof JavaClass) {
            return ((JavaClass)classDefinition).getName();
        }
        return "";
    }

    private Statement getFirstStatement() {
        return (Statement)this.selectedStatements.get(0);
    }

    private Statement getLastStatement() {
        return (Statement)this.selectedStatements.get(this.selectedStatements.size() - 1);
    }

    private Feature getFeature() {
        if (this.feature == null) {
            this.feature = JavaModelUtil.getDeclaringFeature((Element)this.getFirstStatement());
        }
        return this.feature;
    }

    private List getParamTypes() {
        ExtractMethodRefactoring.ParameterInfo[] parameterInfoArray = this.refactoring.getParamTable();
        ArrayList<Type> arrayList = new ArrayList<Type>(parameterInfoArray.length);
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            arrayList.add(parameterInfoArray[i].getVariable().getType());
        }
        return arrayList;
    }

    private TypeReference getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.createReturnType();
        }
        return this.returnType;
    }

    private TypeReference createReturnType() {
        int n;
        TypeReference typeReference;
        Method method;
        Feature feature = this.getFeature();
        JavaModelPackage javaModelPackage = (JavaModelPackage)feature.refImmediatePackage();
        if (this.hasReturn) {
            method = (Method)feature;
            typeReference = method.getTypeName();
            n = method.getDimCount();
        } else if (this.returnedVariable != null) {
            typeReference = this.returnedVariable.getTypeName();
            n = this.returnedVariable.getDimCount();
        } else {
            return javaModelPackage.getMultipartId().createMultipartId("void", null, null);
        }
        typeReference = (TypeReference)typeReference.duplicate();
        if (n == 0) {
            return typeReference;
        }
        if (typeReference instanceof ArrayReference) {
            method = (ArrayReference)typeReference;
            method.setDimCount(method.getDimCount() + n);
            return method;
        }
        return javaModelPackage.getArrayReference().createArrayReference(null, (MultipartId)typeReference, n);
    }

    private void computeDuplicatedVars() {
        Iterator iterator = this.declVars.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (localVariable.equals(this.returnedVariable)) {
                iterator.remove();
                continue;
            }
            if (this.unusedDeclVars.contains(localVariable)) {
                iterator.remove();
                continue;
            }
            if (this.isAccessedAfterSelection(localVariable)) continue;
            iterator.remove();
        }
    }

    private boolean isAccessedAfterSelection(LocalVariable localVariable) {
        Iterator iterator = localVariable.getReferences().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (this.isInsideSelectedStatements(element)) continue;
            return true;
        }
        return false;
    }

    private class ExtractMethodElement
    extends SimpleRefactoringElementImpl {
        private Resource rsc;
        private JavaModelPackage pck;

        private ExtractMethodElement() {
            this.rsc = ExtractMethodRefactoringPlugin.this.getFirstStatement().getResource();
            this.pck = (JavaModelPackage)this.rsc.refImmediatePackage();
        }

        public String getDisplayText() {
            return this.getText();
        }

        public Element getJavaElement() {
            return ExtractMethodRefactoringPlugin.this.getFeature();
        }

        public FileObject getParentFile() {
            return JavaModel.getFileObject((Resource)this.getResource());
        }

        public PositionBounds getPosition() {
            PositionBounds positionBounds = JavaMetamodel.getManager().getElementPosition((Element)ExtractMethodRefactoringPlugin.this.getFirstStatement());
            PositionBounds positionBounds2 = JavaMetamodel.getManager().getElementPosition((Element)ExtractMethodRefactoringPlugin.this.getLastStatement());
            return new PositionBounds(positionBounds.getBegin(), positionBounds2.getEnd());
        }

        public String getText() {
            String string = this.getResource().getSourceText();
            return CheckUtils.htmlize(string.substring(ExtractMethodRefactoringPlugin.this.getFirstStatement().getStartOffset(), ExtractMethodRefactoringPlugin.this.getLastStatement().getEndOffset()));
        }

        public void performChange() {
            Feature feature = ExtractMethodRefactoringPlugin.this.getFeature();
            String string = ExtractMethodRefactoringPlugin.this.refactoring.getName();
            int n = ExtractMethodRefactoringPlugin.this.refactoring.getModifier() | (ExtractMethodRefactoringPlugin.this.refactoring.isStaticMod() ? 8 : 0);
            List list = this.createDuplicatedVars();
            Statement statement = this.createReplacementStatement();
            List list2 = this.createStatements(statement);
            this.insertDuplicatedVars(list, statement);
            StatementBlock statementBlock = this.pck.getStatementBlock().createStatementBlock(list2);
            List list3 = this.createFormalParameters();
            TypeReference typeReference = ExtractMethodRefactoringPlugin.this.getReturnType();
            List list4 = this.createExceptionNames(feature);
            Method method = this.pck.getMethod().createMethod(string, null, n, null, null, statementBlock, null, null, list3, list4, typeReference, 0);
            List list5 = feature.getDeclaringClass().getFeatures();
            int n2 = list5.indexOf(feature);
            list5.add(n2 + 1, method);
        }

        private List createExceptionNames(Feature feature) {
            ArrayList<MultipartId> arrayList = new ArrayList<MultipartId>();
            Iterator iterator = ExtractMethodRefactoringPlugin.this.exceptions.iterator();
            while (iterator.hasNext()) {
                arrayList.add(JavaModelUtil.resolveImportsForClass((Element)feature, (JavaClass)((JavaClass)iterator.next())));
            }
            return arrayList;
        }

        private List createFormalParameters() {
            ExtractMethodRefactoring.ParameterInfo[] parameterInfoArray = ExtractMethodRefactoringPlugin.this.refactoring.getParamTable();
            ParameterClass parameterClass = this.pck.getParameter();
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            for (int i = 0; i < parameterInfoArray.length; ++i) {
                ExtractMethodRefactoring.ParameterInfo parameterInfo = parameterInfoArray[i];
                Variable variable = parameterInfo.getVariable();
                int n = variable.getDimCount();
                if (variable instanceof Parameter && ((Parameter)variable).isVarArg()) {
                    ++n;
                }
                TypeReference typeReference = (TypeReference)variable.getTypeName().duplicate();
                Parameter parameter = parameterClass.createParameter(parameterInfo.getName(), null, !ExtractMethodRefactoringPlugin.this.writeVars.contains(variable), typeReference, n, false);
                arrayList.add(parameter);
            }
            return arrayList;
        }

        private Statement createReplacementStatement() {
            List list = this.createParameters();
            String string = ExtractMethodRefactoringPlugin.this.refactoring.getName();
            MethodInvocation methodInvocation = this.pck.getMethodInvocation().createMethodInvocation(string, list, null, false);
            if (ExtractMethodRefactoringPlugin.this.hasReturn) {
                return this.pck.getReturnStatement().createReturnStatement((Expression)methodInvocation);
            }
            if (ExtractMethodRefactoringPlugin.this.returnedVariable != null) {
                if (ExtractMethodRefactoringPlugin.this.retValDefinedInSelectedStmts) {
                    return this.createVarDecl(ExtractMethodRefactoringPlugin.this.returnedVariable, (InitialValue)methodInvocation);
                }
                Assignment assignment = this.pck.getAssignment().createAssignment((PrimaryExpression)this.createVarAccess(ExtractMethodRefactoringPlugin.this.returnedVariable), (Operator)OperatorEnum.ASSIGN, (Expression)methodInvocation);
                return this.pck.getExpressionStatement().createExpressionStatement((Expression)assignment);
            }
            return this.pck.getExpressionStatement().createExpressionStatement((Expression)methodInvocation);
        }

        private List createParameters() {
            ExtractMethodRefactoring.ParameterInfo[] parameterInfoArray = ExtractMethodRefactoringPlugin.this.refactoring.getParamTable();
            VariableAccessClass variableAccessClass = this.pck.getVariableAccess();
            ArrayList<VariableAccess> arrayList = new ArrayList<VariableAccess>();
            for (int i = 0; i < parameterInfoArray.length; ++i) {
                arrayList.add(variableAccessClass.createVariableAccess(parameterInfoArray[i].getName(), null, false));
            }
            return arrayList;
        }

        private VariableAccess createVarAccess(Variable variable) {
            return this.pck.getVariableAccess().createVariableAccess(ExtractMethodRefactoringPlugin.this.returnedVariable.getName(), null, false);
        }

        private LocalVarDeclaration createVarDecl(Variable variable, InitialValue initialValue) {
            LocalVariable localVariable = this.pck.getLocalVariable().createLocalVariable(variable.getName(), null, false, null, variable.getDimCount(), initialValue, null);
            TypeReference typeReference = (TypeReference)variable.getTypeName().duplicate();
            return this.pck.getLocalVarDeclaration().createLocalVarDeclaration(false, typeReference, Collections.singletonList(localVariable));
        }

        private List createStatements(Statement statement) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Element element = (Element)ExtractMethodRefactoringPlugin.this.getFirstStatement().refImmediateComposite();
            Iterator iterator = ExtractMethodRefactoringPlugin.this.newLocalVars.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.createVarDecl((Variable)iterator.next(), null));
            }
            iterator = ExtractMethodRefactoringPlugin.this.selectedStatements.iterator();
            while (iterator.hasNext()) {
                Statement statement2 = (Statement)iterator.next();
                if (ExtractMethodRefactoringPlugin.this.unusedDeclVars.contains(statement2)) continue;
                element.replaceChild((Element)statement2, (Element)statement);
                arrayList.add(statement2);
                statement = null;
            }
            if (ExtractMethodRefactoringPlugin.this.returnedVariable != null) {
                arrayList.add(this.pck.getReturnStatement().createReturnStatement((Expression)this.createVarAccess(ExtractMethodRefactoringPlugin.this.returnedVariable)));
            }
            return arrayList;
        }

        private Resource getResource() {
            return this.rsc;
        }

        private List createDuplicatedVars() {
            LocalVarDeclarationClass localVarDeclarationClass = this.pck.getLocalVarDeclaration();
            LocalVariableClass localVariableClass = this.pck.getLocalVariable();
            ArrayList<LocalVarDeclaration> arrayList = new ArrayList<LocalVarDeclaration>();
            Iterator iterator = ExtractMethodRefactoringPlugin.this.declVars.iterator();
            while (iterator.hasNext()) {
                LocalVariable localVariable = (LocalVariable)iterator.next();
                LocalVariable localVariable2 = localVariableClass.createLocalVariable(localVariable.getName(), null, false, null, localVariable.getDimCount(), null, null);
                TypeReference typeReference = (TypeReference)localVariable.getTypeName().duplicate();
                arrayList.add(localVarDeclarationClass.createLocalVarDeclaration(false, typeReference, Collections.singletonList(localVariable2)));
            }
            return arrayList;
        }

        private void insertDuplicatedVars(List list, Statement statement) {
            RefFeatured refFeatured;
            if (!list.isEmpty() && (refFeatured = statement.refImmediateComposite()) instanceof StatementBlock) {
                StatementBlock statementBlock = (StatementBlock)refFeatured;
                List list2 = statementBlock.getStatements();
                int n = list2.indexOf(statement);
                list2.addAll(n, list);
            }
        }
    }

    private class VariableAnalyzer {
        private Variable var;
        private int startOffset;
        private int endOffset;

        private VariableAnalyzer(Variable variable) {
            this(variable, 0, Integer.MAX_VALUE);
        }

        private VariableAnalyzer(Variable variable, int n, int n2) {
            this.var = variable;
            this.startOffset = n;
            this.endOffset = n2;
        }

        private Boolean readsVariableInElement(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Boolean bl = this.readsVariableInElement((Element)iterator.next());
                if (bl == null) continue;
                return bl;
            }
            return null;
        }

        private boolean isInRange(int n) {
            return n >= this.startOffset && n <= this.endOffset;
        }

        private Boolean readsVariableInElement(Element element) {
            if (element == null || !this.isInRange(element.getStartOffset()) && !this.isInRange(element.getEndOffset())) {
                return null;
            }
            if (element instanceof VariableAccess) {
                VariableAccess variableAccess = (VariableAccess)element;
                Variable variable = (Variable)variableAccess.getElement();
                if (this.var.equals(variable)) {
                    return variableAccess.isRead();
                }
                return null;
            }
            if (element instanceof MultipartId) {
                return null;
            }
            if (element instanceof Assignment) {
                Assignment assignment = (Assignment)element;
                Boolean bl = this.readsVariableInElement((Element)assignment.getRightSide());
                if (bl == null) {
                    bl = this.readsVariableInElement((Element)assignment.getLeftSide());
                }
                return bl;
            }
            if (element instanceof IfStatement) {
                IfStatement ifStatement = (IfStatement)element;
                Boolean bl = this.readsVariableInElement((Element)ifStatement.getExpression());
                if (bl != null) {
                    return bl;
                }
                Boolean bl2 = this.readsVariableInElement((Element)ifStatement.getThenPart());
                Boolean bl3 = this.readsVariableInElement((Element)ifStatement.getElsePart());
                if (Boolean.TRUE.equals(bl2) || Boolean.TRUE.equals(bl3)) {
                    return Boolean.TRUE;
                }
                if (Boolean.FALSE.equals(bl2) && Boolean.FALSE.equals(bl3)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            if (element instanceof WhileStatement) {
                WhileStatement whileStatement = (WhileStatement)element;
                Boolean bl = this.readsVariableInElement((Element)whileStatement.getExpression());
                if (bl != null) {
                    return bl;
                }
                Boolean bl4 = this.readsVariableInElement((Element)whileStatement.getBody());
                if (Boolean.TRUE.equals(bl4)) {
                    return bl4;
                }
                return null;
            }
            if (element instanceof ForStatement) {
                ForStatement forStatement = (ForStatement)element;
                Boolean bl = this.readsVariableInElement(forStatement.getInit());
                if (bl != null) {
                    return bl;
                }
                bl = this.readsVariableInElement((Element)forStatement.getExpression());
                if (bl != null) {
                    return bl;
                }
                ArrayList<Statement> arrayList = new ArrayList<Statement>(2);
                Statement statement = forStatement.getBody();
                if (statement != null) {
                    arrayList.add(statement);
                }
                arrayList.addAll(forStatement.getSteps());
                bl = this.readsVariableInElement(arrayList);
                if (Boolean.TRUE.equals(bl)) {
                    return bl;
                }
                return null;
            }
            if (element instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)element;
                Boolean bl = this.readsVariableInElement((Element)tryStatement.getBody());
                if (bl != null) {
                    return bl;
                }
                Iterator iterator = tryStatement.getCatches().iterator();
                while (iterator.hasNext()) {
                    if (!Boolean.TRUE.equals(this.readsVariableInElement((Element)((Catch)iterator.next())))) continue;
                    return Boolean.TRUE;
                }
                return this.readsVariableInElement((Element)tryStatement.getFinalizer());
            }
            if (element instanceof SwitchStatement) {
                SwitchStatement switchStatement = (SwitchStatement)element;
                Boolean bl = this.readsVariableInElement((Element)switchStatement.getExpression());
                if (bl != null) {
                    return bl;
                }
                Iterator iterator = switchStatement.getCases().iterator();
                while (iterator.hasNext()) {
                    if (!Boolean.TRUE.equals(this.readsVariableInElement((Element)((Case)iterator.next())))) continue;
                    return Boolean.TRUE;
                }
                return null;
            }
            return this.readsVariableInElement(element.getChildren());
        }
    }
}

