/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.File;
import java.io.IOException;
import java.io.SyncFailedException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.RenameFullNameElement;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MoveClassRefactoringPlugin
extends JavaRefactoringPlugin {
    private Map sourceObjectsMap;
    private Collection resources;
    private Collection otherDataObjects = Collections.EMPTY_LIST;
    private Map sourceClassesMap;
    private Collection allClasses;
    private boolean particularClassSelected;
    private Map accessesOriginalPackageMap;
    private Map accessedByOriginalPackageMap;
    private Map movingToDefaultPackageMap;
    private Map movingFromDefaultPackageMap;
    private FileObject folder = null;
    private MoveClassRefactoring refactoring;
    private ClassPath classPath;
    private Map checkedSourcesMap;
    private int size;
    private FileObject target;
    private boolean isPackageRename = false;
    private String newPackageName;
    private ArrayList createdFolderNames = new ArrayList();
    private ArrayList createdFolderNamesDuringUndo = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public MoveClassRefactoringPlugin(MoveClassRefactoring moveClassRefactoring) {
        this.refactoring = moveClassRefactoring;
        this.resources = moveClassRefactoring.getResources();
        this.otherDataObjects = moveClassRefactoring.getOtherDataObjects();
        this.classPath = RefactoringClassPathImplementation.getDefault();
        this.folder = moveClassRefactoring.getSourceFolder();
    }

    private Problem init() {
        Object object;
        Resource resource;
        this.sourceObjectsMap = new HashMap(this.resources.size());
        Problem problem = null;
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            resource = (Resource)iterator.next();
            if (resource.isValid()) {
                object = JavaMetamodel.getManager().getDataObject(resource);
                this.sourceObjectsMap.put(resource, object);
                if (!CheckUtils.isFromLibrary(resource)) continue;
                problem = MoveClassRefactoringPlugin.createProblem(problem, true, MoveClassRefactoringPlugin.getCannotMove(object.getPrimaryFile()));
                continue;
            }
            iterator.remove();
        }
        this.size = this.resources.size();
        this.accessesOriginalPackageMap = new HashMap(this.size);
        this.accessedByOriginalPackageMap = new HashMap(this.size);
        this.movingToDefaultPackageMap = new HashMap(this.size);
        this.movingFromDefaultPackageMap = new HashMap(this.size);
        this.sourceClassesMap = new HashMap(this.size * 2);
        this.checkedSourcesMap = new HashMap(this.size);
        this.allClasses = new ArrayList(10);
        iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            resource = (Resource)iterator.next();
            object = new LinkedList();
            object.addAll(resource.getClassifiers());
            this.sourceClassesMap.put(resource, object.toArray(new JavaClass[object.size()]));
            this.checkedSourcesMap.put(resource, new HashSet());
        }
        iterator = this.refactoring.getSelectedDataObjects().iterator();
        while (iterator.hasNext()) {
            resource = (DataObject)iterator.next();
            if (!(resource instanceof DataFolder)) continue;
            this.putSubfolders(resource.getPrimaryFile());
        }
        return problem;
    }

    private static final String getCannotMove(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        }
        String string = classPath.getResourceName(fileObject);
        return new MessageFormat(NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_CannotMoveFile")).format(new Object[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        Object object;
        Resource resource;
        Problem problem = this.init();
        if (problem != null) {
            return problem;
        }
        Object object2 = this.resources.iterator();
        while (object2.hasNext()) {
            resource = (Resource)object2.next();
            if (!CheckUtils.isElementInOpenProject((Element)resource)) {
                return new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
            }
            object = (JavaClass[])this.sourceClassesMap.get(resource);
            for (int i = 0; i < ((JavaClass[])object).length; ++i) {
                this.collectAllClasses(this.allClasses, object[i]);
            }
        }
        this.fireProgressListenerStart(1, 3 * this.size + 3);
        object2 = this.resources.iterator();
        while (object2.hasNext()) {
            if (this.cancelRequest) {
                return null;
            }
            resource = (Resource)object2.next();
            this.accessedByOriginalPackageMap.put(resource, this.isAccessedByOriginalPackage(resource));
            object = (JavaPackage)resource.refImmediateComposite();
            this.movingFromDefaultPackageMap.put(resource, "".equals(object.getName()));
            this.accessesOriginalPackageMap.put(resource, Boolean.FALSE);
        }
        try {
            object2 = this.resources.iterator();
            while (object2.hasNext()) {
                resource = (Resource)object2.next();
                object = (JavaClass[])this.sourceClassesMap.get(resource);
                this.fireProgressListenerStep();
                if (((JavaPackage)object).length > 1 && this.particularClassSelected) {
                    Problem problem2 = new Problem(true, MoveClassRefactoringPlugin.getString("ERR_SourceWithMoreClasses"));
                    return problem2;
                }
                this.fireProgressListenerStep();
            }
            object2 = this.checkUsedElements(null);
            boolean bl = false;
            object = this.resources.iterator();
            while (object.hasNext()) {
                Resource resource2 = (Resource)object.next();
                this.fireProgressListenerStep();
                Boolean bl2 = (Boolean)this.accessesOriginalPackageMap.get(resource2);
                boolean bl3 = bl2 != null ? bl2 : false;
                boolean bl4 = (Boolean)this.movingFromDefaultPackageMap.get(resource2);
                if (!bl3 || !bl4 || bl) continue;
                Problem problem3 = new Problem(false, MoveClassRefactoringPlugin.getString("ERR_ClassToMoveInDefaultPackage"));
                problem3.setNext((Problem)object2);
                object2 = problem3;
                bl = true;
            }
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            object2 = this.checkAccessesMyFeature((Problem)object2);
            this.fireProgressListenerStep();
            object = object2;
            return object;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        return this.checkParameters(this.refactoring.getTargetClassPathRoot(), this.refactoring.getTargetPackageName());
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getTargetClassPathRoot(), this.refactoring.getTargetPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Object var2_2 = null;
        this.fireProgressListenerStart(3, 2 + 2 * this.resources.size());
        try {
            Resource resource;
            this.fireProgressListenerStep();
            Object var4_3 = null;
            Object var5_4 = null;
            this.checkWhereUsed(refactoringElementsBag);
            this.fireProgressListenerStep();
            Iterator iterator = this.resources.iterator();
            while (iterator.hasNext()) {
                if (this.cancelRequest) {
                    resource = null;
                    return resource;
                }
                resource = (Resource)iterator.next();
                JavaPackage javaPackage = (JavaPackage)resource.refImmediateComposite();
                Boolean bl = (Boolean)this.accessesOriginalPackageMap.get(resource);
                boolean bl2 = bl != null ? bl : false;
                boolean bl3 = (Boolean)this.movingFromDefaultPackageMap.get(resource);
                if (bl2 && !bl3 && !this.containsImport(resource, javaPackage.getName())) {
                    refactoringElementsBag.add(this.refactoring, new InsertImport(resource, javaPackage.getName(), false));
                }
                this.fireProgressListenerStep();
                DataObject dataObject = (DataObject)this.sourceObjectsMap.get(resource);
                refactoringElementsBag.add(this.refactoring, new MoveClass(dataObject, this.refactoring.getTargetClassPathRoot(), this.refactoring.getTargetPackageName(resource), (JavaClass[])this.sourceClassesMap.get(resource)));
                this.fireProgressListenerStep();
            }
            this.removeUnusedImports(refactoringElementsBag);
            iterator = this.otherDataObjects.iterator();
            while (iterator.hasNext()) {
                resource = (DataObject)iterator.next();
                refactoringElementsBag.add(this.refactoring, new MoveClass((DataObject)resource, this.refactoring.getTargetClassPathRoot(), this.refactoring.getTargetPackageName(resource.getPrimaryFile()), null));
            }
            iterator = null;
            return iterator;
        }
        finally {
            this.referencesIterator = null;
            this.fireProgressListenerStop();
        }
    }

    private Collection getOldPackages() {
        HashSet<RefFeatured> hashSet = new HashSet<RefFeatured>(3);
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            hashSet.add(resource.refImmediateComposite());
        }
        return hashSet;
    }

    private Collection getEmptyPackages() {
        HashSet<JavaPackage> hashSet = new HashSet<JavaPackage>(3);
        Iterator iterator = this.getOldPackages().iterator();
        while (iterator.hasNext()) {
            JavaPackage javaPackage = (JavaPackage)iterator.next();
            HashSet hashSet2 = new HashSet(javaPackage.getResources());
            hashSet2.removeAll(this.resources);
            hashSet2.remove(null);
            if (!hashSet2.isEmpty()) continue;
            hashSet.add(javaPackage);
        }
        return hashSet;
    }

    private void removeUnusedImports(RefactoringElementsBag refactoringElementsBag) {
        NamedElement namedElement;
        List list;
        Object object;
        JavaPackage javaPackage;
        Iterator iterator = this.getEmptyPackages().iterator();
        while (iterator.hasNext()) {
            javaPackage = (JavaPackage)iterator.next();
            object = MoveClassRefactoringPlugin.findReferencedResources(javaPackage.getName());
            for (int i = 0; i < ((Resource[])object).length; ++i) {
                list = object[i].getImports();
                namedElement = list.iterator();
                while (namedElement.hasNext()) {
                    Import import_ = (Import)namedElement.next();
                    NamedElement namedElement2 = import_.getImportedNamespace();
                    if (!javaPackage.equals(namedElement2)) continue;
                    refactoringElementsBag.add(this.refactoring, new RemoveImport(import_));
                }
            }
        }
        iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            javaPackage = (Resource)iterator.next();
            object = this.refactoring.getTargetPackageName((Resource)javaPackage);
            Iterator iterator2 = javaPackage.getImports().iterator();
            while (iterator2.hasNext()) {
                list = (Import)iterator2.next();
                namedElement = list.getImportedNamespace();
                if (namedElement instanceof UnresolvedClass) continue;
                if (namedElement instanceof JavaClass) {
                    namedElement = (NamedElement)namedElement.getResource().refImmediateComposite();
                }
                if (!(namedElement instanceof JavaPackage) || !namedElement.getName().equals(object)) continue;
                refactoringElementsBag.add(this.refactoring, new RemoveImport((Import)list));
            }
        }
    }

    private static Resource[] findReferencedResources(String string) {
        if ("".equals(string)) {
            return new Resource[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList((Object[])ClassIndex.findResourcesForIdentifier((String)string2)));
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            arrayList.retainAll(Arrays.asList((Object[])ClassIndex.findResourcesForIdentifier((String)string2)));
        }
        return arrayList.toArray(new Resource[arrayList.size()]);
    }

    private static String getPackageName(ClassPath classPath, FileObject fileObject) {
        return classPath.getResourceName(fileObject, '.', false);
    }

    private boolean isFullName(MultipartId multipartId) {
        while (multipartId != null) {
            if (multipartId.getElement() instanceof JavaPackage) {
                return true;
            }
            multipartId = multipartId.getParent();
        }
        return false;
    }

    private Problem checkUsedElements(Problem problem) {
        Iterator iterator = this.allClasses.iterator();
        while (iterator.hasNext()) {
            if (this.cancelRequest) {
                return null;
            }
            JavaClass javaClass = (JavaClass)iterator.next();
            problem = this.checkUsedElements((Element)javaClass, new HashSet(), problem);
        }
        return problem;
    }

    private Problem checkUsedElements(Element element, Set set, Problem object) {
        List list = element.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.cancelRequest) {
                return null;
            }
            Object e = iterator.next();
            if (e instanceof JavaClass || e instanceof Feature && !(element instanceof Feature)) continue;
            if (e instanceof ElementReference) {
                Feature feature;
                Resource resource;
                NamedElement namedElement = ((ElementReference)e).getElement();
                while (namedElement instanceof Array) {
                    namedElement = ((Array)namedElement).getType();
                }
                if (namedElement instanceof Feature && (resource = (feature = (Feature)namedElement).getResource()) != null && !this.resources.contains(resource) && !set.contains(resource)) {
                    Object object2;
                    Object object3;
                    JavaPackage javaPackage = (JavaPackage)resource.refImmediateComposite();
                    boolean bl = false;
                    Iterator iterator2 = this.resources.iterator();
                    while (iterator2.hasNext()) {
                        object3 = (Resource)iterator2.next();
                        object2 = (JavaPackage)object3.refImmediateComposite();
                        if (object2 != javaPackage) continue;
                        this.accessesOriginalPackageMap.put(object3, Boolean.TRUE);
                        bl = true;
                    }
                    int n = feature.getModifiers();
                    if (!(feature instanceof Initializer || (n & 1) != 0 || (n & 2) != 0 || Modifier.isProtected(n) && (this.getEnclosingClass((Element)e).isSubTypeOf((ClassDefinition)((JavaClass)feature.getDeclaringClass())) || !Modifier.isProtected(n) || this.allClasses.contains(this.getEnclosingClass((Element)feature))))) {
                        set.add(resource);
                        String string = object3 = (n & 4) != 0 ? MoveClassRefactoringPlugin.getString("LBL_Protected") : MoveClassRefactoringPlugin.getString("LBL_PackagePrivate");
                        object2 = feature instanceof JavaClass ? new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateClass2")).format(new Object[]{this.getEnclosingClass((Element)e).getSimpleName(), object3, ((JavaClass)feature).getSimpleName()})) : (feature instanceof Constructor ? new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateConstructor2")).format(new Object[]{this.getEnclosingClass((Element)e).getSimpleName(), object3, ((JavaClass)feature.getDeclaringClass()).getSimpleName()})) : new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateFeature2")).format(new Object[]{this.getEnclosingClass((Element)e).getSimpleName(), object3, this.getFeatureKindName(feature), feature.getName(), ((JavaClass)feature.getDeclaringClass()).getSimpleName()})));
                        ((Problem)object2).setNext((Problem)object);
                        object = object2;
                    }
                }
            }
            if (e instanceof TypeReference) continue;
            object = this.checkUsedElements((Element)e, set, (Problem)object);
        }
        return object;
    }

    private void checkWhereUsed(RefactoringElementsBag refactoringElementsBag) {
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (this.refactoring.getTargetPackageName(resource).equals(((JavaPackage)resource.refImmediateComposite()).getName())) continue;
            JavaClass[] javaClassArray = (JavaClass[])this.sourceClassesMap.get(resource);
            for (int i = 0; i < javaClassArray.length; ++i) {
                this.checkWhereUsed(refactoringElementsBag, javaClassArray[i], resource);
            }
        }
    }

    private Element getImport(Element element) {
        Element element2 = element;
        while (element instanceof MultipartId) {
            element = (Element)element.refImmediateComposite();
        }
        if (element instanceof Import) {
            return element;
        }
        return element2;
    }

    private void checkWhereUsed(RefactoringElementsBag refactoringElementsBag, JavaClass javaClass, Resource resource) {
        String string = this.refactoring.getTargetPackageName(resource);
        JavaPackage javaPackage = ((JavaModelPackage)javaClass.refImmediatePackage()).getJavaPackage().resolvePackage(string);
        Collection collection = javaClass.getReferences();
        boolean bl = (Boolean)this.movingToDefaultPackageMap.get(resource);
        this.referencesIterator = collection.iterator();
        while (this.referencesIterator.hasNext()) {
            Resource resource2;
            if (this.cancelRequest) {
                return;
            }
            Element element = this.getImport((Element)this.referencesIterator.next());
            if (element instanceof MultipartId) {
                if (this.isFullName((MultipartId)element)) {
                    refactoringElementsBag.add(this.refactoring, new RenameFullNameElement(javaClass, (MultipartId)element, string));
                    continue;
                }
                resource2 = element.getResource();
                JavaPackage javaPackage2 = (JavaPackage)resource2.refImmediateComposite();
                Set set = (Set)this.checkedSourcesMap.get(resource);
                if (bl || this.resources.contains(resource2) || set.contains(resource2)) continue;
                set.add(resource2);
                if (javaPackage2 == javaPackage || this.containsImport(resource2, javaClass.getName())) continue;
                refactoringElementsBag.add(this.refactoring, new InsertImport(resource2, string + '.' + javaClass.getSimpleName(), true));
                continue;
            }
            if (!(element instanceof Import)) continue;
            if (bl) {
                refactoringElementsBag.add(this.refactoring, new RemoveImport((Import)element));
                continue;
            }
            for (resource2 = ((Import)element).getIdentifier(); resource2 != null && !javaClass.equals(resource2.getElement()); resource2 = resource2.getParent()) {
            }
            if (!$assertionsDisabled && resource2 == null) {
                throw new AssertionError((Object)("id is null, resource = " + element.getResource().getName() + " jc = " + javaClass));
            }
            refactoringElementsBag.add(this.refactoring, new RenameFullNameElement(javaClass, (MultipartId)resource2, string));
        }
    }

    private JavaClass getEnclosingClass(Element element) {
        while (element != null && !(element instanceof JavaClass)) {
            element = (Element)element.refImmediateComposite();
        }
        return (JavaClass)element;
    }

    private boolean containsImport(Resource resource, JavaClass javaClass) {
        JavaPackage javaPackage = (JavaPackage)javaClass.getResource().refImmediateComposite();
        Iterator iterator = resource.getImports().iterator();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            NamedElement namedElement = import_.getImportedNamespace();
            if (namedElement != javaClass && namedElement != javaPackage) continue;
            return true;
        }
        return false;
    }

    private boolean containsImport(Resource resource, String string) {
        Iterator iterator = resource.getImports().iterator();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            if (!string.equals(import_.getName())) continue;
            return true;
        }
        return false;
    }

    private Problem checkAccessesMyFeature(Problem problem) {
        Iterator iterator = this.allClasses.iterator();
        while (iterator.hasNext()) {
            if (this.cancelRequest) {
                return null;
            }
            JavaClass javaClass = (JavaClass)iterator.next();
            problem = this.checkAccessesMyFeature(problem, javaClass);
        }
        return problem;
    }

    private Problem checkAccessesMyFeature(Problem object, JavaClass javaClass) {
        boolean bl = false;
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext() || !bl) {
            JavaClass javaClass2;
            if (!bl) {
                javaClass2 = javaClass;
                bl = true;
            } else {
                javaClass2 = (Feature)iterator.next();
                if (javaClass2 instanceof JavaClass) continue;
            }
            int n = javaClass2.getModifiers();
            if (javaClass2 instanceof Initializer || (n & 1) != 0 || (n & 2) != 0) continue;
            boolean bl2 = (n & 4) != 0;
            Collection collection = javaClass2.getReferences();
            this.referencesIterator = collection.iterator();
            while (this.referencesIterator.hasNext()) {
                String string;
                if (this.cancelRequest) {
                    return null;
                }
                Element element = (Element)this.referencesIterator.next();
                Resource resource = element.getResource();
                String string2 = string = (n & 4) != 0 ? MoveClassRefactoringPlugin.getString("LBL_Protected") : MoveClassRefactoringPlugin.getString("LBL_PackagePrivate");
                if (this.resources.contains(resource) || !hashSet.add(resource)) continue;
                JavaPackage javaPackage = (JavaPackage)resource.refImmediateComposite();
                boolean bl3 = false;
                Object object2 = this.resources.iterator();
                while (object2.hasNext()) {
                    JavaPackage javaPackage2 = (JavaPackage)((Resource)object2.next()).refImmediateComposite();
                    if (javaPackage == javaPackage2) continue;
                    bl3 = true;
                }
                if (bl3 || this.getEnclosingClass(element).isSubTypeOf((ClassDefinition)javaClass)) continue;
                object2 = javaClass2 instanceof JavaClass ? new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateClass")).format(new Object[]{this.getEnclosingClass(element).getSimpleName(), string, javaClass2.getSimpleName()})) : (javaClass2 instanceof Constructor ? new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateConstructor")).format(new Object[]{this.getEnclosingClass(element).getSimpleName(), string, ((JavaClass)javaClass2.getDeclaringClass()).getSimpleName()})) : new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateFeature")).format(new Object[]{this.getEnclosingClass(element).getSimpleName(), string, this.getFeatureKindName((Feature)javaClass2), javaClass2.getName(), ((JavaClass)javaClass2.getDeclaringClass()).getSimpleName()})));
                ((Problem)object2).setNext((Problem)object);
                object = object2;
            }
        }
        return object;
    }

    private boolean isAccessedByOriginalPackage(Resource resource) {
        JavaClass[] javaClassArray = (JavaClass[])this.sourceClassesMap.get(resource);
        JavaPackage javaPackage = (JavaPackage)resource.refImmediateComposite();
        for (int i = 0; i < javaClassArray.length; ++i) {
            this.referencesIterator = javaClassArray[i].getReferences().iterator();
            while (this.referencesIterator.hasNext()) {
                if (this.cancelRequest) {
                    return false;
                }
                Element element = (Element)this.referencesIterator.next();
                Resource resource2 = element.getResource();
                JavaPackage javaPackage2 = (JavaPackage)resource2.refImmediateComposite();
                if (this.resources.contains(resource2)) continue;
                return true;
            }
        }
        return false;
    }

    private String getFeatureKindName(Feature feature) {
        String string = feature instanceof Method ? MoveClassRefactoringPlugin.getString("LBL_Method") : (feature instanceof Field ? MoveClassRefactoringPlugin.getString("LBL_Field") : (feature instanceof Constructor ? MoveClassRefactoringPlugin.getString("LBL_Constructor") : (feature instanceof JavaClass ? MoveClassRefactoringPlugin.getString("LBL_Class") : "???")));
        return string;
    }

    private void collectAllClasses(Collection collection, JavaClass javaClass) {
        collection.add(javaClass);
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JavaClass)) continue;
            this.collectAllClasses(collection, (JavaClass)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem setParameters(FileObject fileObject, String string) {
        this.newPackageName = string;
        Problem problem = null;
        this.target = fileObject;
        this.fireProgressListenerStart(2, 1 + this.resources.size());
        try {
            Iterator iterator = this.resources.iterator();
            while (iterator.hasNext()) {
                int n;
                JavaClass[] javaClassArray;
                Resource resource = (Resource)iterator.next();
                FileObject fileObject2 = this.refactoring.getTargetClassPathRoot();
                String string2 = this.refactoring.getTargetPackageName(resource);
                FileObject fileObject3 = fileObject2.getFileObject(string2.replace('.', '/'));
                String string3 = null;
                if (fileObject3 != null && !fileObject3.canWrite()) {
                    javaClassArray = new Problem(true, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_PackageIsReadOnly")).format(new Object[]{string2}));
                    return javaClassArray;
                }
                this.movingToDefaultPackageMap.put(resource, fileObject3 != null && fileObject3.equals(this.classPath.findOwnerRoot(fileObject3)));
                string3 = string2;
                if (string3 == null) {
                    string3 = "";
                } else if (string3.length() > 0) {
                    string3 = string3 + '.';
                }
                this.fireProgressListenerStep();
                javaClassArray = (JavaClass[])this.sourceClassesMap.get(resource);
                String[] stringArray = new String[javaClassArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = javaClassArray[i].getName();
                }
                FileObject fileObject4 = JavaMetamodel.getManager().getDataObject(resource).getPrimaryFile();
                String string4 = fileObject4.getName();
                if (fileObject3 != null) {
                    FileObject[] fileObjectArray = fileObject3.getChildren();
                    for (n = 0; n < fileObjectArray.length; ++n) {
                        if (!fileObjectArray[n].getName().equals(string4) || !"java".equals(fileObjectArray[n].getExt()) || fileObjectArray[n].equals(fileObject4) || fileObjectArray[n].isVirtual()) continue;
                        Problem problem2 = new Problem(true, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_ClassToMoveClashes")).format(new Object[]{string4}));
                        return problem2;
                    }
                }
                boolean bl = (Boolean)this.accessedByOriginalPackageMap.get(resource);
                n = ((Boolean)this.movingToDefaultPackageMap.get(resource)).booleanValue() ? 1 : 0;
                if (problem == null && bl && n != 0) {
                    problem = new Problem(false, MoveClassRefactoringPlugin.getString("ERR_MovingClassToDefaultPackage"));
                }
                if (!((DataObject)this.sourceObjectsMap.get(resource)).getFolder().getPrimaryFile().equals(fileObject3) || !this.isPackageCorrect(resource)) continue;
                Problem problem3 = new Problem(true, MoveClassRefactoringPlugin.getString("ERR_CannotMoveIntoSamePackage"));
                return problem3;
            }
            this.fireProgressListenerStep();
        }
        finally {
            this.fireProgressListenerStop();
        }
        return problem;
    }

    private boolean isPackageCorrect(Resource resource) {
        String string = resource.getName();
        int n = string.lastIndexOf(47);
        String string2 = n == -1 ? "" : string.substring(0, n);
        return string2.replace('/', '.').equals(resource.getPackageName());
    }

    private Problem checkParameters(FileObject fileObject, String string) {
        if (!MoveClassRefactoringPlugin.isValidPackageName(string)) {
            String string2 = MoveClassRefactoringPlugin.getString("ERR_InvalidPackage");
            String string3 = new MessageFormat(string2).format(new Object[]{string});
            return new Problem(true, string3);
        }
        return null;
    }

    private static boolean isValidPackageName(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith(".") || string.endsWith(".")) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    static final JavaPackage findJavaPackage(ClassPath classPath, FileObject fileObject) {
        FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
        JavaModelPackage javaModelPackage = JavaModel.getJavaExtent((FileObject)fileObject2);
        JavaPackageClass javaPackageClass = javaModelPackage.getJavaPackage();
        return javaPackageClass.resolvePackage(MoveClassRefactoringPlugin.getPackageName(classPath, fileObject));
    }

    static final String getString(String string) {
        return NbBundle.getMessage((Class)MoveClassRefactoring.class, (String)string);
    }

    private FileObject createFolder(FileObject fileObject, String string, boolean bl) throws IOException {
        String string2 = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreElements()) {
            FileObject fileObject2;
            block6: {
                string = stringTokenizer.nextToken();
                if (string.length() <= 0) continue;
                fileObject2 = fileObject.getFileObject(string);
                if (fileObject2 == null) {
                    try {
                        fileObject2 = fileObject.createFolder(string);
                        if (bl) {
                            this.createdFolderNames.add(fileObject2.getURL());
                        } else {
                            this.createdFolderNamesDuringUndo.add(fileObject2.getURL());
                        }
                    }
                    catch (SyncFailedException syncFailedException) {
                        fileObject.refresh();
                        fileObject2 = fileObject.getFileObject(string);
                        if (fileObject2 != null) break block6;
                        throw syncFailedException;
                    }
                }
            }
            fileObject = fileObject2;
        }
        return fileObject;
    }

    private void putSubfolders(FileObject fileObject) {
        try {
            this.createdFolderNames.add(fileObject.getURL());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!fileObjectArray[i].isFolder()) continue;
            this.putSubfolders(fileObjectArray[i]);
        }
    }

    static /* synthetic */ FileObject access$600(MoveClassRefactoringPlugin moveClassRefactoringPlugin, FileObject fileObject, String string, boolean bl) throws IOException {
        return moveClassRefactoringPlugin.createFolder(fileObject, string, bl);
    }

    static /* synthetic */ ArrayList access$900(MoveClassRefactoringPlugin moveClassRefactoringPlugin) {
        return moveClassRefactoringPlugin.createdFolderNamesDuringUndo;
    }

    static /* synthetic */ ArrayList access$1000(MoveClassRefactoringPlugin moveClassRefactoringPlugin) {
        return moveClassRefactoringPlugin.createdFolderNames;
    }

    static {
        $assertionsDisabled = !MoveClassRefactoringPlugin.class.desiredAssertionStatus();
    }

    static class RemoveImport
    extends SimpleRefactoringElementImpl {
        private Import imp;
        private Resource res;
        private PositionBounds bounds = null;

        public RemoveImport(Import import_) {
            this.imp = import_;
            this.res = (Resource)import_.refImmediateComposite();
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return new MessageFormat(MoveClassRefactoringPlugin.getString("LBL_RemoveImport")).format(new Object[]{this.imp.getName()});
        }

        public void performChange() {
            this.res.getImports().remove(this.imp);
        }

        public Element getJavaElement() {
            return this.res;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.res);
            }
            return this.bounds;
        }

        public FileObject getParentFile() {
            return null;
        }
    }

    static class InsertImport
    extends SimpleRefactoringElementImpl {
        protected ImportClass proxy;
        protected Resource source;
        protected String newName;
        protected boolean isNamed;
        private PositionBounds bounds = null;
        protected Import addedImport = null;

        public InsertImport(Resource resource, String string, boolean bl) {
            this.source = resource;
            this.newName = string;
            this.isNamed = bl;
            this.proxy = ((JavaModelPackage)resource.refOutermostPackage()).getImport();
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return new MessageFormat(MoveClassRefactoringPlugin.getString("LBL_InsertImport")).format(new Object[]{this.newName});
        }

        public void performChange() {
            this.addedImport = this.proxy.createImport(this.newName, null, false, !this.isNamed);
            this.source.addImport(this.addedImport);
        }

        public Element getJavaElement() {
            return this.source;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.source);
            }
            return this.bounds;
        }

        public FileObject getParentFile() {
            return null;
        }
    }

    class MoveClass
    extends SimpleRefactoringElementImpl
    implements RefactoringElementImplementation,
    ExternalChange {
        private DataObject source;
        private FileObject target;
        private FileObject oldTarget = null;
        private JavaClass[] sourceClasses;
        private PositionBounds bounds = null;
        private DataObject copiedObject = null;
        private FileObject targetRoot = null;
        private String packageName = null;

        public MoveClass(DataObject dataObject, FileObject fileObject, JavaClass[] javaClassArray) {
            this.source = dataObject;
            this.target = fileObject;
            this.sourceClasses = javaClassArray;
        }

        public MoveClass(DataObject dataObject, FileObject fileObject, String string, JavaClass[] javaClassArray) {
            this.source = dataObject;
            this.targetRoot = fileObject;
            this.sourceClasses = javaClassArray;
            this.packageName = string;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            String string = this.target == null ? this.packageName : MoveClassRefactoringPlugin.getPackageName(MoveClassRefactoringPlugin.this.classPath, this.target);
            if ("".equals(string)) {
                string = MoveClassRefactoringPlugin.getString("LBL_DefaultPackage");
            }
            if (this.sourceClasses == null) {
                return new MessageFormat(MoveClassRefactoringPlugin.getString("LBL_MoveObject")).format(new Object[]{this.source.getNodeDelegate().getDisplayName(), string});
            }
            return new MessageFormat(MoveClassRefactoringPlugin.getString("LBL_MoveClass")).format(new Object[]{string});
        }

        public Element getJavaElement() {
            if (this.sourceClasses == null || this.sourceClasses.length == 0) {
                return null;
            }
            return (Element)this.sourceClasses[0].refImmediateComposite();
        }

        public PositionBounds getPosition() {
            Resource resource;
            if (this.sourceClasses == null || this.sourceClasses.length == 0) {
                return null;
            }
            if (this.bounds == null && this.sourceClasses[0].isValid() && (resource = this.sourceClasses[0].getResource()) != null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)resource.getPackageIdentifier());
            }
            return this.bounds;
        }

        public void performChange() {
            String string;
            String string2 = string = this.target == null ? this.packageName : MoveClassRefactoringPlugin.getPackageName(MoveClassRefactoringPlugin.this.classPath, this.target);
            if (this.sourceClasses != null) {
                JavaModel.getResource((FileObject)this.source.getPrimaryFile()).setPackageName(string);
            }
            if (this.target == null || !this.target.equals(this.source.getPrimaryFile().getParent())) {
                JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
            }
        }

        private void doMove(boolean bl) {
            try {
                this.source.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, bl){
                    private final /* synthetic */ boolean val$isUndo;
                    private final /* synthetic */ MoveClass this$1;
                    {
                        this.this$1 = moveClass;
                        this.val$isUndo = bl;
                    }

                    public void run() throws IOException {
                        if (MoveClass.access$200(this.this$1) == null) {
                            MoveClass.access$202(this.this$1, MoveClassRefactoringPlugin.access$600(MoveClass.access$500(this.this$1), MoveClass.access$300(this.this$1), MoveClass.access$400(this.this$1).replace('.', '/'), this.val$isUndo));
                        } else if (!MoveClass.access$200(this.this$1).isValid()) {
                            MoveClass.access$202(this.this$1, MoveClassRefactoringPlugin.access$600(MoveClass.access$500(this.this$1), MoveClass.access$200(this.this$1).getFileSystem().getRoot(), MoveClass.access$200(this.this$1).getPath(), this.val$isUndo));
                        }
                        DataFolder dataFolder = DataFolder.findFolder((FileObject)MoveClass.access$200(this.this$1));
                        DataFolder dataFolder2 = DataFolder.findFolder((FileObject)MoveClass.access$700(this.this$1).getPrimaryFile().getParent());
                        MoveClass.access$802(this.this$1, MoveClass.access$700(this.this$1).getPrimaryFile().getParent());
                        MoveClass.access$700(this.this$1).move(dataFolder);
                        ArrayList arrayList = this.val$isUndo ? MoveClassRefactoringPlugin.access$900(MoveClass.access$500(this.this$1)) : MoveClassRefactoringPlugin.access$1000(MoveClass.access$500(this.this$1));
                        for (int i = arrayList.size() - 1; i >= 0; --i) {
                            URL uRL = (URL)arrayList.get(i);
                            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                            if (fileObject == null || !fileObject.isValid() || fileObject.getChildren().length != 0) continue;
                            fileObject.delete();
                            arrayList.remove(i);
                        }
                    }
                });
                JavaMetamodel.getManager().addModified(this.source.getPrimaryFile());
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                iOException.printStackTrace();
            }
        }

        private boolean canDelete(DataFolder dataFolder) {
            FileObject fileObject = dataFolder.getPrimaryFile();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null) {
                return false;
            }
            return !fileObject.equals(classPath.findOwnerRoot(fileObject));
        }

        public void performExternalChange() {
            this.doMove(false);
        }

        public void undoExternalChange() {
            if (this.oldTarget == null) {
                return;
            }
            FileObject fileObject = this.target;
            this.target = this.oldTarget;
            this.oldTarget = fileObject;
            this.doMove(true);
            this.target = fileObject;
        }

        public FileObject getParentFile() {
            return this.source.getPrimaryFile();
        }

        static /* synthetic */ FileObject access$200(MoveClass moveClass) {
            return moveClass.target;
        }

        static /* synthetic */ FileObject access$202(MoveClass moveClass, FileObject fileObject) {
            moveClass.target = fileObject;
            return moveClass.target;
        }

        static /* synthetic */ FileObject access$300(MoveClass moveClass) {
            return moveClass.targetRoot;
        }

        static /* synthetic */ String access$400(MoveClass moveClass) {
            return moveClass.packageName;
        }

        static /* synthetic */ MoveClassRefactoringPlugin access$500(MoveClass moveClass) {
            return moveClass.MoveClassRefactoringPlugin.this;
        }

        static /* synthetic */ DataObject access$700(MoveClass moveClass) {
            return moveClass.source;
        }

        static /* synthetic */ FileObject access$802(MoveClass moveClass, FileObject fileObject) {
            moveClass.oldTarget = fileObject;
            return moveClass.oldTarget;
        }
    }
}

