/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.ChangeModElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class PullUpRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PullUpRefactoring refactoring;

    PullUpRefactoringPlugin(PullUpRefactoring pullUpRefactoring) {
        this.refactoring = pullUpRefactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 4);
        try {
            JavaClass javaClass = this.refactoring.getSourceType();
            Problem problem = PullUpRefactoringPlugin.isElementAvail((Element)javaClass);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            if (!CheckUtils.isElementInOpenProject((Element)javaClass)) {
                Problem problem3 = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem3;
            }
            if (javaClass instanceof UnresolvedClass) {
                Problem problem4 = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem4;
            }
            this.fireProgressListenerStep();
            JavaClass[] javaClassArray = this.refactoring.collectSupertypes();
            if (javaClassArray.length == 0) {
                Problem problem5 = new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoSuperTypes"));
                return problem5;
            }
            this.fireProgressListenerStep();
            if (!PullUpRefactoringPlugin.hasMembers(javaClass, javaClassArray)) {
                Problem problem6 = new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembers"));
                return problem6;
            }
            this.fireProgressListenerStep();
            Problem problem7 = null;
            return problem7;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        PullUpRefactoring.MemberInfo[] memberInfoArray = this.refactoring.getMembers();
        if (memberInfoArray.length == 0) {
            return new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembersSelected"));
        }
        if (memberInfoArray.length > 1) {
            for (int i = 0; i < memberInfoArray.length - 1; ++i) {
                for (int j = i + 1; j < memberInfoArray.length; ++j) {
                    if (!CheckUtils.membersEqual(memberInfoArray[i].member, memberInfoArray[j].member)) continue;
                    return new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_CannotPullupDuplicateMembers"));
                }
            }
        }
        if (this.refactoring.getTargetType() == null) {
            return new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoTargetType"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem checkParameters() {
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>(Arrays.asList(this.refactoring.collectSupertypes()));
        JavaClass javaClass = this.refactoring.getTargetType();
        PullUpRefactoring.MemberInfo[] memberInfoArray = this.refactoring.getMembers();
        this.fireProgressListenerStart(2, memberInfoArray.length + 1);
        try {
            if (!hashSet.contains(javaClass)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_IllegalTargetType"));
                return problem;
            }
            this.fireProgressListenerStep();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            Problem problem = null;
            hashSet2.add(this.refactoring.getSourceType());
            for (int i = 0; i < memberInfoArray.length; ++i) {
                Object object;
                Object object2;
                NamedElement namedElement = memberInfoArray[i].member;
                Object object3 = namedElement instanceof Feature ? ((Feature)namedElement).getDeclaringClass() : (!((object2 = (object = (MultipartId)namedElement).refImmediateComposite()) instanceof JavaClass) ? null : (!((JavaClass)object2).getInterfaceNames().contains(object) ? null : (ClassDefinition)object2));
                if (!(!hashSet2.add(object3) || object3 instanceof JavaClass && hashSet.contains(object3) && !object3.equals(javaClass) && object3.isSubTypeOf((ClassDefinition)javaClass))) {
                    object = PullUpRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_IllegalMember", (Object)namedElement.getName()));
                    return object;
                }
                boolean bl = namedElement instanceof Field ? javaClass.getField(namedElement.getName(), false) != null : (namedElement instanceof Method ? javaClass.getMethod(namedElement.getName(), Utilities.getFeatureParamTypes((CallableFeature)namedElement), false) != null : (namedElement instanceof JavaClass ? javaClass.getInnerClass(namedElement.getName(), false) != null : javaClass.getInterfaces().contains(((MultipartId)namedElement).getElement())));
                if (bl) {
                    object2 = PullUpRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_MemberAlreadyExists", (Object)namedElement.getName()));
                    return object2;
                }
                this.fireProgressListenerStep();
            }
            Problem problem2 = null;
            return problem2;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        PullUpRefactoring.MemberInfo[] memberInfoArray = this.refactoring.getMembers();
        boolean bl = false;
        for (int i = 0; i < memberInfoArray.length; ++i) {
            int n = memberInfoArray[i].member instanceof MultipartId ? 0 : ((Feature)memberInfoArray[i].member).getModifiers();
            int n2 = 0;
            if (this.refactoring.getTargetType().isInterface()) {
                n2 = (n | 1) & 0xFFFFFFFD & 0xFFFFFFFB;
            } else if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) {
                n2 = (n | 4) & 0xFFFFFFFD;
            }
            if (memberInfoArray[i].makeAbstract) {
                refactoringElementsBag.add(this.refactoring, new AddAbstractMethodElement((Method)memberInfoArray[i].member, this.refactoring.getTargetType(), n2));
                bl = true;
                if (n2 == 0) continue;
                refactoringElementsBag.add(this.refactoring, new ChangeModElement((Feature)memberInfoArray[i].member, n2));
                continue;
            }
            refactoringElementsBag.add(this.refactoring, new MoveMemberElement(memberInfoArray[i].member, this.refactoring.getTargetType(), n2));
            if (!Modifier.isAbstract(n)) continue;
            bl = true;
        }
        if (bl && !Modifier.isAbstract(this.refactoring.getTargetType().getModifiers()) && !this.refactoring.getTargetType().isInterface()) {
            refactoringElementsBag.add(this.refactoring, new ChangeModElement((Feature)this.refactoring.getTargetType(), this.refactoring.getTargetType().getModifiers() | 0x400));
        }
        UndoWatcher.watch(((JMManager)JMManager.getManager()).getDataObject(this.refactoring.getTargetType().getResource()));
        return null;
    }

    private static boolean hasMembers(JavaClass javaClass, JavaClass[] javaClassArray) {
        boolean bl = Utilities.hasMembers(javaClass);
        for (int i = 0; i < javaClassArray.length - 1 && !bl; ++i) {
            bl = Utilities.hasMembers(javaClassArray[i]);
        }
        return bl;
    }

    private Problem checkUsedByElement(Element element, Set set, Problem problem, boolean bl, boolean bl2) {
        NamedElement namedElement;
        if (!(element instanceof MultipartId) && (element instanceof MethodInvocation || element instanceof NewClassExpression || element instanceof VariableAccess) && (namedElement = ((ElementReference)element).getElement()) instanceof Feature) {
            boolean bl3;
            Feature feature = (Feature)namedElement;
            int n = feature.getModifiers();
            ClassDefinition classDefinition = feature.getDeclaringClass();
            Object object = element instanceof VariableAccess ? ((VariableAccess)element).getParentClass() : (element instanceof MethodInvocation ? ((MethodInvocation)element).getParentClass() : (classDefinition instanceof JavaClass && !Modifier.isStatic(((JavaClass)classDefinition).getModifiers()) ? ((NewClassExpression)element).getEnclosingClass() : null));
            boolean bl4 = bl3 = object == null || object instanceof ThisExpression;
            if (Modifier.isPrivate(n)) {
                if (bl || bl3) {
                    problem = PullUpRefactoringPlugin.createProblem(problem, false, "will not be accessible");
                }
            } else if (bl2 && !Modifier.isPublic(n)) {
                if (!Modifier.isProtected(n) || namedElement instanceof Method) {
                    // empty if block
                }
                problem = PullUpRefactoringPlugin.createProblem(problem, false, "will not be accessible - is protected/package private");
            }
        }
        namedElement = element.getChildren().iterator();
        while (namedElement.hasNext()) {
            problem = this.checkUsedByElement((Element)namedElement.next(), set, problem, bl, bl2);
        }
        return problem;
    }

    private static class MoveMemberElement
    extends SimpleRefactoringElementImpl {
        private final NamedElement elementToMove;
        private final JavaClass target;
        private final int newModifiers;
        private final String text;

        MoveMemberElement(NamedElement namedElement, JavaClass javaClass, int n) {
            this.elementToMove = namedElement;
            this.target = javaClass;
            this.newModifiers = n;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin = PullUpRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PullUpRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin), (String)"TXT_PullUp_Member", (Object)UIUtilities.getDisplayText(namedElement));
        }

        public void performChange() {
            Element element;
            JavaModelPackage javaModelPackage = (JavaModelPackage)this.target.refImmediatePackage();
            boolean bl = false;
            if (this.elementToMove instanceof Feature) {
                JavaClass javaClass = (JavaClass)((Feature)this.elementToMove).getDeclaringClass();
                if (javaModelPackage.equals(javaClass.refImmediatePackage())) {
                    javaClass.getFeatures().remove(this.elementToMove);
                    element = this.elementToMove;
                } else {
                    element = ((MetadataElement)this.elementToMove).duplicate(javaModelPackage);
                    bl = true;
                }
                this.target.getContents().add(element);
                if (this.newModifiers != 0) {
                    ((Feature)element).setModifiers(this.newModifiers);
                }
            } else {
                JavaClass javaClass = (JavaClass)this.elementToMove.refImmediateComposite();
                if (javaModelPackage.equals(javaClass.refImmediatePackage())) {
                    javaClass.getInterfaceNames().remove(this.elementToMove);
                    element = this.elementToMove;
                } else {
                    element = ((MetadataElement)this.elementToMove).duplicate(javaModelPackage);
                    bl = true;
                }
                this.target.getInterfaceNames().add(element);
            }
            ((MetadataElement)element).fixImports((Element)this.target, (Element)this.elementToMove);
            if (bl) {
                this.elementToMove.refDelete();
            }
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.elementToMove.getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)this.elementToMove);
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.elementToMove);
        }
    }

    private static class AddAbstractMethodElement
    extends SimpleRefactoringElementImpl {
        private final Method methodToAdd;
        private final JavaClass target;
        private final int newModifiers;
        private final String text;

        AddAbstractMethodElement(Method method, JavaClass javaClass, int n) {
            this.methodToAdd = method;
            this.target = javaClass;
            this.newModifiers = n;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin = PullUpRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PullUpRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin), (String)"TXT_PullUp_AddMethod", (Object)UIUtilities.getDisplayText((NamedElement)method));
        }

        public void performChange() {
            JavaModelPackage javaModelPackage = (JavaModelPackage)this.target.refImmediatePackage();
            Method method = javaModelPackage.getMethod().createMethod(this.methodToAdd.getName(), Utilities.duplicateList(this.methodToAdd.getAnnotations(), javaModelPackage), (this.newModifiers == 0 ? this.methodToAdd.getModifiers() : this.newModifiers) | 0x400, this.methodToAdd.getJavadocText(), null, null, null, Utilities.duplicateList(this.methodToAdd.getTypeParameters(), javaModelPackage), Utilities.duplicateList(this.methodToAdd.getParameters(), javaModelPackage), Utilities.duplicateList(this.methodToAdd.getExceptionNames(), javaModelPackage), (TypeReference)((MetadataElement)this.methodToAdd.getTypeName()).duplicate(javaModelPackage), this.methodToAdd.getDimCount());
            if (this.target.isInterface()) {
                method.setModifiers(method.getModifiers() & 0xFFFFFBFF & 0xFFFFFFFE & 0xFFFFFFFB & 0xFFFFFFFD);
            }
            this.target.getContents().add(method);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.target.getResource());
        }

        public Element getJavaElement() {
            return this.target;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

