/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class PushDownRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PushDownRefactoring refactoring;

    public PushDownRefactoringPlugin(PushDownRefactoring pushDownRefactoring) {
        this.refactoring = pushDownRefactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 4);
        try {
            JavaClass javaClass = this.refactoring.getSourceType();
            Problem problem = PushDownRefactoringPlugin.isElementAvail((Element)javaClass);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            if (!CheckUtils.isElementInOpenProject((Element)javaClass)) {
                Problem problem3 = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem3;
            }
            if (javaClass instanceof UnresolvedClass) {
                Problem problem4 = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem4;
            }
            this.fireProgressListenerStep();
            if (this.refactoring.collectSubtypes().length == 0) {
                Problem problem5 = new Problem(true, NbBundle.getMessage((Class)PushDownRefactoringPlugin.class, (String)"ERR_PushDOwn_NoSubtype"));
                return problem5;
            }
            this.fireProgressListenerStep();
            if (!PushDownRefactoringPlugin.hasMembers(javaClass)) {
                Problem problem6 = new Problem(true, NbBundle.getMessage((Class)PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembers"));
                return problem6;
            }
            this.fireProgressListenerStep();
            Problem problem7 = null;
            return problem7;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        if (this.refactoring.getMembers().length == 0) {
            return new Problem(true, NbBundle.getMessage((Class)PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembersSelected"));
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        PushDownRefactoring.MemberInfo[] memberInfoArray = this.refactoring.getMembers();
        ArrayList<NamedElement> arrayList = new ArrayList<NamedElement>();
        JavaClass[] javaClassArray = this.refactoring.collectSubtypes();
        for (int i = 0; i < memberInfoArray.length; ++i) {
            if (memberInfoArray[i].member instanceof Feature) {
                arrayList.add(memberInfoArray[i].member);
            }
            for (int j = 0; j < javaClassArray.length; ++j) {
                boolean bl = true;
                Iterator iterator = javaClassArray[j].getFeatures().iterator();
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    if (!CheckUtils.membersEqual((NamedElement)feature, memberInfoArray[i].member)) continue;
                    bl = false;
                    break;
                }
                refactoringElementsBag.add(this.refactoring, new CopyMemberElement(memberInfoArray[i].member, javaClassArray[j], 0, bl));
                UndoWatcher.watch(((JMManager)JMManager.getManager()).getDataObject(javaClassArray[j].getResource()));
            }
            refactoringElementsBag.add(this.refactoring, new RemoveOriginalElement(memberInfoArray[i].member, memberInfoArray[i].makeAbstract));
        }
        PushDownRefactoringPlugin.collectRelaxModifierElements(this.refactoring, refactoringElementsBag, this.refactoring.getSourceType(), arrayList);
        return null;
    }

    private static boolean hasMembers(JavaClass javaClass, JavaClass[] javaClassArray) {
        boolean bl = PushDownRefactoringPlugin.hasMembers(javaClass);
        for (int i = 0; i < javaClassArray.length - 1 && !bl; ++i) {
            bl = PushDownRefactoringPlugin.hasMembers(javaClassArray[i]);
        }
        return bl;
    }

    private static boolean hasMembers(JavaClass javaClass) {
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (!(feature instanceof Field) && !(feature instanceof Method) && !(feature instanceof JavaClass)) continue;
            return true;
        }
        return false;
    }

    static void collectRelaxModifierElements(AbstractRefactoring abstractRefactoring, RefactoringElementsBag refactoringElementsBag, JavaClass javaClass, List list) {
        Feature feature;
        HashSet hashSet = new HashSet();
        HashSet<Feature> hashSet2 = new HashSet<Feature>();
        HashSet hashSet3 = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            hashSet3.add(iterator.next());
        }
        iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            feature = (Feature)iterator.next();
            int n = feature.getModifiers();
            if (!Modifier.isPrivate(n) && (Modifier.isProtected(n) || Modifier.isPublic(n))) continue;
            hashSet2.add(feature);
        }
        iterator = hashSet3.iterator();
        while (iterator.hasNext()) {
            PushDownRefactoringPlugin.traverseAccessedMembers((Element)((Feature)iterator.next()), hashSet, hashSet2);
        }
        iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            feature = (Feature)iterator.next();
            if (!hashSet.contains(feature) || hashSet3.contains(feature)) continue;
            refactoringElementsBag.add(abstractRefactoring, new RelaxAccessModifier(feature));
        }
    }

    static void traverseAccessedMembers(Element element, Set set, Set set2) {
        Object object;
        if ((element instanceof MethodInvocation || element instanceof VariableAccess || element instanceof TypeReference) && set2.contains(object = ((ElementReference)element).getElement())) {
            set.add(object);
        }
        object = element.getChildren().iterator();
        while (object.hasNext()) {
            PushDownRefactoringPlugin.traverseAccessedMembers((Element)object.next(), set, set2);
        }
    }

    private static class RelaxAccessModifier
    extends SimpleRefactoringElementImpl {
        private final String text;
        private final Feature feature;

        RelaxAccessModifier(Feature feature) {
            this.feature = feature;
            boolean bl = Modifier.isPrivate(feature.getModifiers());
            this.text = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"TXT_PushDown_RelaxAccessModifier")).format(new Object[]{bl ? NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"LBL_PushDown_private") : NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"LBL_PushDown_package_private"), NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"LBL_PushDown_protected")});
        }

        public void performChange() {
            this.feature.setModifiers(this.feature.getModifiers() & 0xFFFFFFFD | 4);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.feature.getResource());
        }

        public Element getJavaElement() {
            return this.feature;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.feature);
        }
    }

    private static class CopyMemberElement
    extends SimpleRefactoringElementImpl {
        private final NamedElement elementToCopy;
        private final JavaClass target;
        private final int newModifiers;
        private final String text;

        CopyMemberElement(NamedElement namedElement, JavaClass javaClass, int n, boolean bl) {
            this.elementToCopy = namedElement;
            this.target = javaClass;
            this.newModifiers = n;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"TXT_PushDown_Member", (Object)UIUtilities.getDisplayText(namedElement), (Object)UIUtilities.getDisplayText((NamedElement)javaClass));
            this.setEnabled(bl);
        }

        public void performChange() {
            Element element;
            JavaModelPackage javaModelPackage = (JavaModelPackage)this.target.refImmediatePackage();
            if (this.elementToCopy instanceof Feature) {
                JavaClass javaClass = (JavaClass)((Feature)this.elementToCopy).getDeclaringClass();
                element = ((MetadataElement)this.elementToCopy).duplicate(javaModelPackage);
                this.target.getContents().add(element);
                if (this.newModifiers != 0) {
                    ((Feature)element).setModifiers(this.newModifiers);
                }
            } else {
                JavaClass javaClass = (JavaClass)this.elementToCopy.refImmediateComposite();
                element = ((MetadataElement)this.elementToCopy).duplicate(javaModelPackage);
                this.target.getInterfaceNames().add(element);
            }
            ((MetadataElement)element).fixImports((Element)this.target, (Element)this.elementToCopy);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.elementToCopy.getResource());
        }

        public Element getJavaElement() {
            return this.target;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.elementToCopy);
        }
    }

    private static class RemoveOriginalElement
    extends SimpleRefactoringElementImpl {
        private final NamedElement elementToRemove;
        private final String text;
        private final boolean makeItAbstract;

        RemoveOriginalElement(NamedElement namedElement, boolean bl) {
            this.elementToRemove = namedElement;
            this.makeItAbstract = bl;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)(bl ? "TXT_PushDown_Abstract" : "TXT_PushDown_Remove"), (Object)UIUtilities.getDisplayText(namedElement));
        }

        public void performChange() {
            if (this.makeItAbstract) {
                Method method = (Method)this.elementToRemove;
                method.setModifiers(method.getModifiers() | 0x400);
                method.setBodyText(null);
            } else {
                this.elementToRemove.refDelete();
            }
        }

        public String getText() {
            return this.text;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.elementToRemove);
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.elementToRemove.getResource());
        }

        public Element getJavaElement() {
            return (Element)this.elementToRemove.refImmediateComposite();
        }

        public String getDisplayText() {
            return this.text;
        }
    }
}

