/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.CommentRenameFinder;
import org.netbeans.modules.refactoring.RenameUsageElement;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RenameRefactoringPlugin
extends JavaRefactoringPlugin
implements ProgressListener {
    private RefObject jmiObject = null;
    private String newName = null;
    private Collection overriddenByMethods = null;
    private Collection overridesMethods = null;
    private boolean doCheckName = true;
    private FileObject originalFolder = null;
    private Set varNames;
    private RenameRefactoring refactoring;
    static /* synthetic */ Class class$org$netbeans$modules$refactoring$plugins$RenameRefactoringPlugin;

    public RenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        this.jmiObject = (RefObject)renameRefactoring.getRefactoredObject();
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getNewName());
    }

    public Problem fastCheckParameters() {
        return this.checkParameters(this.refactoring.getNewName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 4);
        try {
            Object object;
            Problem problem = RenameRefactoringPlugin.isElementAvail((Element)this.jmiObject);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            Resource resource = ((Element)this.jmiObject).getResource();
            if (resource != null && CheckUtils.isFromLibrary(resource)) {
                Problem problem3 = RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getCannotRename(resource));
                return problem3;
            }
            if (resource != null && !CheckUtils.isElementInOpenProject((Element)this.jmiObject)) {
                Problem problem4 = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem4;
            }
            if (this.jmiObject instanceof UnresolvedClass) {
                Problem problem5 = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
                return problem5;
            }
            if (this.jmiObject instanceof Method) {
                Object object2;
                this.fireProgressListenerStep();
                object = (Method)this.jmiObject;
                List list = this.getParamTypes((Method)object);
                this.fireProgressListenerStep();
                this.overriddenByMethods = this.overriddenBy((Method)object, object.getName(), list);
                this.fireProgressListenerStep();
                if (!this.overriddenByMethods.isEmpty()) {
                    object2 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_IsOverridden")).format(new Object[]{this.getDefClassName(object.getDeclaringClass())});
                    problem = RenameRefactoringPlugin.createProblem(problem, false, (String)object2);
                }
                object2 = new ClassDefinition[]{null, null};
                this.overridesMethods = this.overrides((Method)object, object.getName(), list, (ClassDefinition[])object2);
                this.fireProgressListenerStep();
                if (!this.overridesMethods.isEmpty()) {
                    if (object2[0] == null) {
                        boolean bl = false;
                        Object object3 = this.overridesMethods.iterator();
                        while (object3.hasNext()) {
                            Method method = (Method)object3.next();
                            if (!CheckUtils.isFromLibrary(method.getResource())) continue;
                            bl = true;
                            break;
                        }
                        object3 = bl ? RenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : RenameRefactoringPlugin.getString("ERR_Overrides");
                        problem = RenameRefactoringPlugin.createProblem(problem, bl, (String)object3);
                    } else {
                        String string = this.getDefClassName(object2[0]);
                        String string2 = CheckUtils.isFromLibrary(object2[0].getResource()) ? RenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : new MessageFormat(RenameRefactoringPlugin.getString("ERR_Overrides_tree")).format(new Object[]{string, this.getDefClassName(object2[1]), string});
                        problem = RenameRefactoringPlugin.createProblem(problem, true, string2);
                    }
                }
            } else if (this.jmiObject instanceof Field) {
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                object = (Field)this.jmiObject;
                Field field = this.hides((Field)object, object.getName());
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                if (field != null) {
                    String string = new MessageFormat(RenameRefactoringPlugin.getString("ERR_Hides")).format(new Object[]{this.getDefClassName(field.getDeclaringClass())});
                    problem = RenameRefactoringPlugin.createProblem(problem, false, string);
                }
            } else if (!(this.jmiObject instanceof JavaPackage || this.jmiObject instanceof Variable || this.jmiObject instanceof Attribute || this.jmiObject instanceof JavaClass)) {
                this.fireProgressListenerStep();
                if (!(this.jmiObject instanceof Resource) || !((Resource)this.jmiObject).getClassifiers().isEmpty()) {
                    problem = RenameRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_RenameWrongType"));
                }
            }
            object = problem;
            return object;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    private static final String getCannotRename(Resource resource) {
        return new MessageFormat(NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_CannotRenameFile")).format(new Object[]{resource.getName()});
    }

    private Problem checkParameters(String string) {
        String string2;
        String string3;
        String string4;
        Object object;
        Problem problem = null;
        if (this.getElementName((NamedElement)this.jmiObject).equals(string)) {
            boolean bl = true;
            if (this.jmiObject instanceof JavaClass && (object = this.jmiObject.refImmediateComposite()) instanceof Resource && RenameRefactoringPlugin.isResourceClass((Resource)object, this.jmiObject)) {
                string4 = JavaMetamodel.getManager().getDataObject((Resource)object).getName();
                bl = string4.equals(string);
            }
            if (bl) {
                return RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            }
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string5 = this.jmiObject instanceof JavaPackage ? RenameRefactoringPlugin.getString("ERR_InvalidPackage") : RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            object = new MessageFormat(string5).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, (String)object);
            return problem;
        }
        if (this.jmiObject instanceof JavaPackage) {
            if (this.doCheckName) {
                ClassPath classPath;
                JavaPackage javaPackage = (JavaPackage)this.jmiObject;
                object = javaPackage.getName();
                int n = ((String)object).lastIndexOf(46);
                string4 = n > 0 ? ((String)object).substring(0, n + 1) + string : string;
                if (this.originalFolder != null && (classPath = ClassPath.getClassPath((FileObject)this.originalFolder, (String)"classpath/source")).findResource(string4.replace('.', '/')) != null) {
                    String string6 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_PackageExists")).format(new Object[]{string});
                    problem = RenameRefactoringPlugin.createProblem(problem, true, string6);
                }
            }
            this.newName = string;
            return problem;
        }
        if ((this.jmiObject instanceof JavaClass || this.jmiObject instanceof Resource) && this.doCheckName) {
            Object object2;
            FileObject fileObject;
            String string7;
            RefObject refObject;
            if (this.jmiObject instanceof Resource) {
                refObject = this.jmiObject;
            } else {
                ClassPath classPath;
                refObject = this.jmiObject.refImmediateComposite();
                object = ((NamedElement)this.jmiObject).getName();
                int n = ((String)object).indexOf(46);
                object = n >= 0 ? ((String)object).substring(0, n) : "";
                string7 = "".equals(object) ? string : (String)object + '.' + string;
                object2 = ClassIndex.getClassByFqn((String)string7, (ClassPath)(classPath = ClassPath.getClassPath((FileObject)(fileObject = JavaModel.getFileObject((Resource)((Element)refObject).getResource())), (String)"classpath/source")));
                if (object2 != null && !this.jmiObject.equals(object2)) {
                    String string8 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{string, object});
                    return RenameRefactoringPlugin.createProblem(problem, true, string8);
                }
            }
            if (refObject instanceof Resource && !JavaMetamodel.getManager().getDataObject((Resource)refObject).getName().equals(string)) {
                object = JavaMetamodel.getManager().getDataObject((Resource)refObject);
                string4 = object.getPrimaryFile();
                string7 = string4.getParent();
                fileObject = string7.getChildren();
                for (int i = 0; i < ((FileObject)fileObject).length; ++i) {
                    if (fileObject[i] == string4 || fileObject[i].isVirtual() || !fileObject[i].getName().equals(string) || !"java".equals(fileObject[i].getExt())) continue;
                    object2 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{string, ((Resource)refObject).getPackageName()});
                    problem = RenameRefactoringPlugin.createProblem(problem, true, (String)object2);
                    break;
                }
            }
        }
        if (this.jmiObject instanceof Feature && (string3 = this.clashes((Feature)this.jmiObject, string)) != null) {
            problem = RenameRefactoringPlugin.createProblem(problem, true, string3);
            return problem;
        }
        if (this.jmiObject instanceof Variable && (string2 = this.variableClashes(string, JavaModelUtil.getDeclaringFeature((Element)((Variable)this.jmiObject)))) != null) {
            problem = RenameRefactoringPlugin.createProblem(problem, true, string2);
            return problem;
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem setParameters(String string) {
        int n = 0;
        if (this.overriddenByMethods != null) {
            n += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            n += this.overridesMethods.size();
        }
        this.fireProgressListenerStart(2, 8 + 3 * n);
        try {
            Object object;
            this.fireProgressListenerStep();
            Problem problem = this.checkParameters(string);
            if (problem != null && problem.isFatal()) {
                Problem problem2 = problem;
                return problem2;
            }
            this.fireProgressListenerStep();
            if (this.jmiObject instanceof Method) {
                String string2;
                object = (Method)this.jmiObject;
                problem = this.checkMethodForOverriding((Method)object, string, problem);
                Iterator iterator = this.overridesMethods.iterator();
                while (iterator.hasNext()) {
                    object = (Method)iterator.next();
                    string2 = this.clashes((Feature)object, string);
                    if (string2 != null) {
                        problem = RenameRefactoringPlugin.createProblem(problem, true, string2);
                    }
                    problem = this.checkMethodForOverriding((Method)object, string, problem);
                }
                iterator = this.overriddenByMethods.iterator();
                while (iterator.hasNext()) {
                    object = (Method)iterator.next();
                    string2 = this.clashes((Feature)object, string);
                    if (string2 != null) {
                        problem = RenameRefactoringPlugin.createProblem(problem, true, string2);
                    }
                    problem = this.checkMethodForOverriding((Method)object, string, problem);
                }
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
            } else if (this.jmiObject instanceof Field) {
                object = (Field)this.jmiObject;
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                Field field = this.hides((Field)object, string);
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                if (field != null) {
                    String string3 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillHide")).format(new Object[]{this.getDefClassName(field.getDeclaringClass())});
                    problem = RenameRefactoringPlugin.createProblem(problem, false, string3);
                }
            }
            if (problem == null || !problem.isFatal()) {
                this.newName = string;
            }
            object = problem;
            return object;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    private Problem checkMethodForOverriding(Method method, String string, Problem problem) {
        List list = this.getParamTypes(method);
        this.fireProgressListenerStep();
        problem = this.willBeOverridden(method, string, list, problem);
        this.fireProgressListenerStep();
        problem = this.willOverride(method, string, list, problem);
        this.fireProgressListenerStep();
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Iterator iterator;
        block23: {
            Problem problem;
            block22: {
                Method method;
                block21: {
                    Problem problem2;
                    block20: {
                        block19: {
                            this.varNames = null;
                            CommentRenameFinder commentRenameFinder = null;
                            if (this.newName == null) {
                                return new Problem(true, RenameRefactoringPlugin.getString("ERR_NameNotSet"));
                            }
                            int n = 9;
                            if (this.overriddenByMethods != null) {
                                n += this.overriddenByMethods.size();
                            }
                            if (this.overridesMethods != null) {
                                n += this.overridesMethods.size();
                            }
                            JavaMetamodel.getManager().getProgressSupport().addProgressListener((ProgressListener)this);
                            try {
                                if (this.refactoring.isSearchInComments()) {
                                    commentRenameFinder = new CommentRenameFinder((Element)this.jmiObject, this.newName);
                                    refactoringElementsBag.addAll(this.refactoring, commentRenameFinder.searchCommentsInResource(((Element)this.jmiObject).getResource()));
                                }
                                if (this.jmiObject instanceof JavaPackage) {
                                    Element element;
                                    this.referencesIterator = ((NamedElement)this.jmiObject).getReferences().iterator();
                                    while (this.referencesIterator.hasNext()) {
                                        element = (Element)this.referencesIterator.next();
                                        if (this.cancelRequest) {
                                            Problem problem3 = null;
                                            Object var8_9 = null;
                                            this.referencesIterator = null;
                                            JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
                                            return problem3;
                                        }
                                        if (this.refactoring.isSearchInComments()) {
                                            refactoringElementsBag.addAll(this.refactoring, commentRenameFinder.searchCommentsInResource(element.getResource()));
                                        }
                                        refactoringElementsBag.add(this.refactoring, new RenamePackageElement(this.jmiObject, element, this.newName));
                                    }
                                    DataFolder dataFolder = element = this.originalFolder != null ? DataFolder.findFolder((FileObject)this.originalFolder) : this.getFolder(((JavaPackage)this.jmiObject).getName());
                                    if (element != null) {
                                        refactoringElementsBag.add(this.refactoring, new RenameDataFolder((DataFolder)element, this.newName));
                                    }
                                    Problem problem4 = null;
                                    Object var8_10 = null;
                                    this.referencesIterator = null;
                                    JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
                                    return problem4;
                                }
                                this.addElementsForJmiObject(refactoringElementsBag, this.jmiObject, commentRenameFinder);
                                if (this.overridesMethods != null) {
                                    iterator = this.overridesMethods.iterator();
                                    while (iterator.hasNext()) {
                                        if (this.cancelRequest) {
                                            method = null;
                                            break block19;
                                        }
                                        method = (Method)iterator.next();
                                        if (method.getResource().getName().endsWith(".class")) {
                                            problem2 = RenameRefactoringPlugin.resourceNotAvailable(method);
                                            break block20;
                                        }
                                        refactoringElementsBag.add(this.refactoring, new RenameDOElement((RefObject)method));
                                    }
                                }
                                if (this.overriddenByMethods != null) {
                                    iterator = this.overriddenByMethods.iterator();
                                    while (iterator.hasNext()) {
                                        if (this.cancelRequest) {
                                            method = null;
                                            break block21;
                                        }
                                        method = (Method)iterator.next();
                                        if (method.getResource().getName().endsWith(".class")) {
                                            problem = RenameRefactoringPlugin.resourceNotAvailable(method);
                                            break block22;
                                        }
                                        refactoringElementsBag.add(this.refactoring, new RenameDOElement((RefObject)method));
                                    }
                                }
                                iterator = null;
                                break block23;
                            }
                            catch (Throwable throwable) {
                                Object var8_16 = null;
                                this.referencesIterator = null;
                                JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
                                throw throwable;
                            }
                        }
                        Object var8_11 = null;
                        this.referencesIterator = null;
                        JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
                        return method;
                    }
                    Object var8_12 = null;
                    this.referencesIterator = null;
                    JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
                    return problem2;
                }
                Object var8_13 = null;
                this.referencesIterator = null;
                JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
                return method;
            }
            Object var8_14 = null;
            this.referencesIterator = null;
            JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
            return problem;
        }
        Object var8_15 = null;
        this.referencesIterator = null;
        JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
        return iterator;
    }

    private static Problem resourceNotAvailable(Method method) {
        String string = Utilities.replaceString((String)method.getResource().getName(), (String)".class", (String)".java");
        return new Problem(true, new MessageFormat(RenameRefactoringPlugin.getString("ERR_ResourceUnavailable")).format(new Object[]{method.getName(), string}));
    }

    private void addElementsForJmiObject(RefactoringElementsBag refactoringElementsBag, RefObject refObject, CommentRenameFinder commentRenameFinder) {
        refactoringElementsBag.add(this.refactoring, new RenameDOElement(refObject));
        this.referencesIterator = refObject instanceof Method ? ((MethodImpl)refObject).findDependencies(true, true, false).iterator() : ((NamedElement)refObject).getReferences().iterator();
        while (this.referencesIterator.hasNext()) {
            Element element = (Element)this.referencesIterator.next();
            if (this.cancelRequest) {
                return;
            }
            if (this.refactoring.isSearchInComments()) {
                refactoringElementsBag.addAll(this.refactoring, commentRenameFinder.searchCommentsInResource(element.getResource()));
            }
            String string = this.newName;
            if (this.jmiObject instanceof Field) {
                Feature feature = JavaModelUtil.getDeclaringFeature((Element)element);
                if (((VariableAccess)element).getParentClass() == null && this.variableClashes(this.newName, feature) != null) {
                    ClassDefinition classDefinition = ((Field)this.jmiObject).getDeclaringClass();
                    if (feature.getDeclaringClass().equals(classDefinition)) {
                        string = "this." + this.newName;
                    } else if (classDefinition instanceof NamedElement) {
                        string = classDefinition.getName() + ".this." + this.newName;
                    }
                }
            }
            refactoringElementsBag.add(this.refactoring, new RenameUsageElement(refObject, element, string));
        }
    }

    private DataFolder getFolder(String string) {
        FileObject fileObject = RefactoringClassPathImplementation.getDefault().findResource(string.replace('.', '/'));
        if (fileObject == null) {
            return null;
        }
        return DataFolder.findFolder((FileObject)fileObject);
    }

    private Collection overriddenBy(Method method, String string, List list) {
        if (!CheckUtils.isVirtual((Feature)method)) {
            return Collections.EMPTY_LIST;
        }
        return ((MethodImpl)method).findDependencies(false, false, true);
    }

    private Collection overrides(Method method, String string, List list, ClassDefinition[] classDefinitionArray) {
        ClassDefinition classDefinition;
        ClassDefinition classDefinition2;
        if (!CheckUtils.isVirtual((Feature)method)) {
            return Collections.EMPTY_LIST;
        }
        ClassDefinition classDefinition3 = method.getDeclaringClass();
        LinkedList<JavaClass> linkedList = new LinkedList<JavaClass>();
        HashSet<ClassDefinition> hashSet = new HashSet<ClassDefinition>();
        ClassDefinition classDefinition4 = null;
        linkedList.addAll(classDefinition3.getInterfaces());
        JavaClass javaClass = classDefinition3.getSuperClass();
        if (javaClass != null) {
            linkedList.add(javaClass);
        }
        while (linkedList.size() > 0) {
            javaClass = (ClassDefinition)linkedList.removeFirst();
            if (javaClass instanceof UnresolvedClass) continue;
            classDefinition2 = javaClass.getMethod(string, list, false);
            if (classDefinition2 != null && CheckUtils.isVirtual((Feature)classDefinition2)) {
                hashSet.add(classDefinition2);
                classDefinition4 = classDefinition2;
            }
            linkedList.addAll(javaClass.getInterfaces());
            if ((javaClass = javaClass.getSuperClass()) == null) continue;
            linkedList.add(javaClass);
        }
        if (classDefinition4 != null && (classDefinition = this.findDifferentSubtype((JavaClass)(classDefinition2 = classDefinition4.getDeclaringClass()), string, list, classDefinition3)) != null) {
            classDefinitionArray[0] = classDefinition2;
            classDefinitionArray[1] = classDefinition;
        }
        return hashSet;
    }

    private ClassDefinition findDifferentSubtype(JavaClass javaClass, String string, List list, ClassDefinition classDefinition) {
        HashSet hashSet = new HashSet();
        LinkedList linkedList = new LinkedList();
        JavaClass javaClass2 = javaClass;
        this.collectSupertypes(hashSet, classDefinition);
        this.addSubtypes((ClassDefinition)javaClass2, linkedList);
        while (linkedList.size() > 0) {
            javaClass2 = (ClassDefinition)linkedList.removeFirst();
            if (javaClass2 instanceof UnresolvedClass || hashSet.contains(javaClass2)) continue;
            if (javaClass2.getMethod(string, list, false) != null) {
                return javaClass2;
            }
            this.addSubtypes((ClassDefinition)javaClass2, linkedList);
        }
        return null;
    }

    private void collectSupertypes(Set set, ClassDefinition classDefinition) {
        if (classDefinition == null) {
            return;
        }
        set.add(classDefinition);
        this.collectSupertypes(set, (ClassDefinition)classDefinition.getSuperClass());
        Iterator iterator = classDefinition.getInterfaces().iterator();
        while (iterator.hasNext()) {
            this.collectSupertypes(set, (ClassDefinition)iterator.next());
        }
    }

    private boolean isStatic(Feature feature) {
        return (feature.getModifiers() & 8) > 0;
    }

    private int getAccessLevel(Feature feature) {
        int n = feature.getModifiers();
        if ((n & 1) > 0) {
            return 3;
        }
        if ((n & 4) > 0) {
            return 2;
        }
        if ((n & 2) > 0) {
            return 0;
        }
        return 1;
    }

    private Method isOverridden(Method method, String string, List list) {
        if (!CheckUtils.isVirtual((Feature)method)) {
            return null;
        }
        ClassDefinition classDefinition = method.getDeclaringClass();
        LinkedList linkedList = new LinkedList();
        this.addSubtypes(classDefinition, linkedList);
        while (linkedList.size() > 0) {
            classDefinition = (ClassDefinition)linkedList.removeFirst();
            if (classDefinition instanceof UnresolvedClass) continue;
            Method method2 = classDefinition.getMethod(string, list, false);
            if (method2 != null && CheckUtils.isVirtual((Feature)method2)) {
                return method2;
            }
            this.addSubtypes(classDefinition, linkedList);
        }
        return null;
    }

    private Problem willBeOverridden(Method method, String string, List list, Problem problem) {
        Object object;
        int n = this.getAccessLevel((Feature)method);
        if (n == 0) {
            return null;
        }
        boolean bl = this.isStatic((Feature)method);
        boolean bl2 = (method.getModifiers() & 0x10) > 0;
        Method method2 = null;
        ClassDefinition classDefinition = method.getDeclaringClass();
        LinkedList linkedList = new LinkedList();
        this.addSubtypes(classDefinition, linkedList);
        while (linkedList.size() > 0) {
            classDefinition = (ClassDefinition)linkedList.removeFirst();
            if (classDefinition instanceof UnresolvedClass) continue;
            object = classDefinition.getMethod(string, list, false);
            if (object != null) {
                if (method2 == null) {
                    method2 = object;
                }
                if (bl2) {
                    String string2 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillBeOverridden_final")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), object.getName(), this.getDefClassName(object.getDeclaringClass())});
                    return RenameRefactoringPlugin.createProblem(problem, true, string2);
                }
                if (this.getAccessLevel((Feature)object) < n) {
                    String string3 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillBeOverridden_access")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), object.getName(), this.getDefClassName(object.getDeclaringClass())});
                    return RenameRefactoringPlugin.createProblem(problem, true, string3);
                }
                if (bl == this.isStatic((Feature)object)) continue;
                String string4 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillBeOverridden_static")).format(new Object[]{bl ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), method.getName(), this.getDefClassName(method.getDeclaringClass()), this.isStatic((Feature)object) ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), object.getName(), this.getDefClassName(object.getDeclaringClass())});
                return RenameRefactoringPlugin.createProblem(problem, true, string4);
            }
            this.addSubtypes(classDefinition, linkedList);
        }
        if (method2 != null) {
            object = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillBeOverridden")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), method2.getName(), this.getDefClassName(method2.getDeclaringClass())});
            return RenameRefactoringPlugin.createProblem(problem, false, (String)object);
        }
        return problem;
    }

    private Problem willOverride(Method method, String string, List list, Problem problem) {
        Object object;
        int n = this.getAccessLevel((Feature)method);
        boolean bl = this.isStatic((Feature)method);
        Method method2 = null;
        ClassDefinition classDefinition = method.getDeclaringClass();
        LinkedList<ClassDefinition> linkedList = new LinkedList<ClassDefinition>();
        linkedList.addAll(classDefinition.getInterfaces());
        classDefinition = classDefinition.getSuperClass();
        if (classDefinition != null) {
            linkedList.add(classDefinition);
        }
        while (linkedList.size() > 0) {
            classDefinition = (ClassDefinition)linkedList.removeFirst();
            if (classDefinition instanceof UnresolvedClass) continue;
            object = classDefinition.getMethod(string, list, false);
            if (object != null) {
                if (method2 == null) {
                    method2 = object;
                }
                if ((object.getModifiers() & 0x10) > 0) {
                    String string2 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_final")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), object.getName(), this.getDefClassName(object.getDeclaringClass())});
                    return RenameRefactoringPlugin.createProblem(problem, true, string2);
                }
                if (this.getAccessLevel((Feature)object) > n) {
                    String string3 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_access")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), object.getName(), this.getDefClassName(object.getDeclaringClass())});
                    return RenameRefactoringPlugin.createProblem(problem, true, string3);
                }
                if (bl == this.isStatic((Feature)object)) continue;
                String string4 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_static")).format(new Object[]{bl ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), method.getName(), this.getDefClassName(method.getDeclaringClass()), this.isStatic((Feature)object) ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), object.getName(), this.getDefClassName(object.getDeclaringClass())});
                return RenameRefactoringPlugin.createProblem(problem, true, string4);
            }
            linkedList.addAll(classDefinition.getInterfaces());
            if ((classDefinition = classDefinition.getSuperClass()) == null) continue;
            linkedList.add(classDefinition);
        }
        if (method2 != null) {
            object = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride")).format(new Object[]{method.getName(), this.getDefClassName(method.getDeclaringClass()), method2.getName(), this.getDefClassName(method2.getDeclaringClass())});
            return RenameRefactoringPlugin.createProblem(problem, false, (String)object);
        }
        return problem;
    }

    private Method overrides(Method method, String string, List list, boolean bl) {
        Method method2 = null;
        if (!CheckUtils.isVirtual((Feature)method)) {
            return null;
        }
        ClassDefinition classDefinition = method.getDeclaringClass();
        LinkedList<ClassDefinition> linkedList = new LinkedList<ClassDefinition>();
        linkedList.addAll(classDefinition.getInterfaces());
        classDefinition = classDefinition.getSuperClass();
        if (classDefinition != null) {
            linkedList.add(classDefinition);
        }
        while (linkedList.size() > 0) {
            classDefinition = (ClassDefinition)linkedList.removeFirst();
            if (classDefinition instanceof UnresolvedClass) continue;
            Method method3 = classDefinition.getMethod(string, list, false);
            if (method3 != null && CheckUtils.isVirtual((Feature)method3)) {
                if ((method3.getModifiers() & 0x10) > 0) {
                    method2 = method3;
                    break;
                }
                if (method2 == null) {
                    method2 = method3;
                    if (!bl) break;
                }
            }
            linkedList.addAll(classDefinition.getInterfaces());
            if ((classDefinition = classDefinition.getSuperClass()) == null) continue;
            linkedList.add(classDefinition);
        }
        return method2;
    }

    private Field hides(Field field, String string) {
        if (!CheckUtils.isVirtual((Feature)field)) {
            return null;
        }
        ClassDefinition classDefinition = field.getDeclaringClass();
        for (classDefinition = classDefinition.getSuperClass(); classDefinition != null; classDefinition = classDefinition.getSuperClass()) {
            Field field2 = classDefinition.getField(string, false);
            if (field2 == null || !CheckUtils.isVirtual((Feature)field2)) continue;
            return field2;
        }
        return null;
    }

    private String variableClashes(String string, Feature feature) {
        if (this.varNames == null) {
            this.varNames = CheckUtils.getAllVariableNames(feature);
        }
        if (this.varNames.contains(string)) {
            return new MessageFormat(RenameRefactoringPlugin.getString("ERR_LocVariableClash")).format(new Object[]{string});
        }
        return null;
    }

    private String clashes(Feature feature, String string) {
        ClassDefinition classDefinition = feature.getDeclaringClass();
        if (!(feature instanceof TypeParameter)) {
            if (feature instanceof JavaClass) {
                if (classDefinition != null) {
                    String string2 = this.checkInnersForClash(string, classDefinition);
                    if (string2 != null) {
                        return string2;
                    }
                } else {
                    Element element = (Element)feature.refImmediateComposite();
                    if (element instanceof Resource) {
                        Resource resource = (Resource)element;
                        DataObject dataObject = JavaMetamodel.getManager().getDataObject(resource);
                        FileObject fileObject = dataObject.getPrimaryFile();
                        FileObject fileObject2 = fileObject.getParent();
                        FileObject[] fileObjectArray = fileObject2.getChildren();
                        for (int i = 0; i < fileObjectArray.length; ++i) {
                            if (fileObjectArray[i] == fileObject || fileObjectArray[i].isVirtual() || !fileObjectArray[i].getName().equals(string) || !"java".equals(fileObjectArray[i].getExt())) continue;
                            return new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{string, resource.getPackageName()});
                        }
                    }
                }
            } else if (feature instanceof Method) {
                List list = this.getParamTypes((Method)feature);
                if (classDefinition.getMethod(string, list, false) != null) {
                    return new MessageFormat(RenameRefactoringPlugin.getString("ERR_MethodClash")).format(new Object[]{string, this.getDefClassName(classDefinition)});
                }
            } else if (feature instanceof Field && classDefinition.getField(string, false) != null) {
                return new MessageFormat(RenameRefactoringPlugin.getString("ERR_FieldClash")).format(new Object[]{string, this.getDefClassName(classDefinition)});
            }
        }
        return null;
    }

    private String checkInnersForClash(String string, ClassDefinition classDefinition) {
        Iterator iterator = classDefinition.getFeatures().iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass;
            Object e = iterator.next();
            if (!(e instanceof JavaClass) || !(javaClass = (JavaClass)e).getSimpleName().equals(string)) continue;
            return new MessageFormat(RenameRefactoringPlugin.getString("ERR_InnerClassClash")).format(new Object[]{string, this.getDefClassName(classDefinition)});
        }
        return null;
    }

    String getElementName(NamedElement namedElement) {
        if (namedElement instanceof JavaClass) {
            return ((JavaClass)namedElement).getSimpleName();
        }
        return namedElement.getName();
    }

    String getDefClassName(ClassDefinition classDefinition) {
        if (classDefinition instanceof JavaClass) {
            return ((JavaClass)classDefinition).getName();
        }
        return "";
    }

    private List getParamTypes(Method method) {
        LinkedList<Type> linkedList = new LinkedList<Type>();
        Iterator iterator = method.getParameters().iterator();
        while (iterator.hasNext()) {
            linkedList.add(RenameRefactoringPlugin.getRealType(((Parameter)iterator.next()).getType()));
        }
        return linkedList;
    }

    private static Type getRealType(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getDefinition();
        }
        return type;
    }

    static boolean isResourceClass(Resource resource, RefObject refObject) {
        int n;
        if (resource == null || !(refObject instanceof JavaClass)) {
            return false;
        }
        int n2 = 0;
        Object object = resource.getClassifiers().iterator();
        while (object.hasNext()) {
            if (!(object.next() instanceof JavaClass)) continue;
            ++n2;
        }
        if (n2 == 1) {
            return true;
        }
        object = resource.getName();
        String string = ((JavaClass)refObject).getSimpleName();
        int n3 = ((String)object).lastIndexOf(47) + 1;
        if (n3 < 0) {
            n3 = 0;
        }
        return string.equals(((String)object).substring(n3, n = ((String)object).lastIndexOf(46)));
    }

    private void addSubtypes(ClassDefinition classDefinition, List list) {
        if (!(classDefinition instanceof JavaClass)) {
            return;
        }
        JavaClass javaClass = (JavaClass)classDefinition;
        Collection collection = null;
        collection = javaClass.isInterface() ? javaClass.getImplementors() : javaClass.getSubClasses();
        list.addAll(collection);
    }

    private static final String getString(String string) {
        return NbBundle.getMessage((Class)RenameRefactoring.class, (String)string);
    }

    public void start(ProgressEvent progressEvent) {
        this.fireProgressListenerStart(progressEvent.getOperationType(), progressEvent.getCount());
    }

    public void step(ProgressEvent progressEvent) {
        this.fireProgressListenerStep();
    }

    public void stop(ProgressEvent progressEvent) {
        this.fireProgressListenerStop();
    }

    private class RenameDataFolder
    extends SimpleRefactoringElementImpl
    implements RefactoringElementImplementation,
    ExternalChange {
        private final String text;
        private PositionBounds bounds;
        private String oldName;
        private String newName;
        private DataFolder folder;

        public RenameDataFolder(DataFolder dataFolder, String string) {
            this.newName = string;
            this.folder = dataFolder;
            this.text = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$api$RenameRefactoring == null ? (class$org$netbeans$modules$refactoring$api$RenameRefactoring = RenameRefactoringPlugin.class$("org.netbeans.modules.refactoring.api.RenameRefactoring")) : class$org$netbeans$modules$refactoring$api$RenameRefactoring), (String)"LBL_RenameFolder"), dataFolder.getName(), this.newName);
        }

        public String getDisplayText() {
            return this.text;
        }

        public Element getJavaElement() {
            return (Element)RenameRefactoringPlugin.this.jmiObject;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)RenameRefactoringPlugin.this.jmiObject);
            }
            return this.bounds;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        private void doRename() {
            this.oldName = this.folder.getName();
            try {
                this.folder.rename(this.newName);
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException().initCause(iOException);
            }
        }

        public void performExternalChange() {
            this.doRename();
        }

        public void undoExternalChange() {
            if (this.oldName == null) {
                return;
            }
            String string = this.newName;
            this.newName = this.oldName;
            this.oldName = string;
            this.doRename();
            this.newName = string;
        }

        public FileObject getParentFile() {
            return null;
        }
    }

    private class RenamePackageElement
    extends RenameUsageElement {
        private String oldName;

        public RenamePackageElement(RefObject refObject, Element element, String string) {
            super(refObject, element, string);
            this.oldName = null;
        }

        public void performChange() {
            MultipartId multipartId = (MultipartId)this.feature;
            this.oldName = multipartId.getName();
            multipartId.setName(RenameRefactoringPlugin.this.newName);
        }
    }

    private class RenameDOElement
    extends SimpleRefactoringElementImpl
    implements ExternalChange {
        private final String text;
        private PositionBounds bounds = null;
        private String oldName = null;
        private Resource res = null;
        private RefObject refObject;
        static final /* synthetic */ boolean $assertionsDisabled;

        public RenameDOElement(RefObject refObject) {
            this.refObject = refObject;
            Object object = refObject instanceof Resource ? refObject : refObject.refImmediateComposite();
            if (object instanceof Resource) {
                this.res = (Resource)object;
            }
            String string = null;
            if (refObject instanceof Resource) {
                string = "LBL_RenameClassDO";
            } else if (refObject instanceof JavaEnum) {
                string = "LBL_RenameEnum";
            } else if (refObject instanceof AnnotationType) {
                string = "LBL_RenameAnnotationType";
            } else if (refObject instanceof TypeParameter) {
                string = "LBL_RenameTypeParameter";
            } else if (refObject instanceof JavaClass) {
                string = this.isResourceClass() ? "LBL_RenameClassDO" : "LBL_RenameClass";
            } else if (refObject instanceof Method) {
                string = "LBL_RenameMethod";
            } else if (refObject instanceof Field) {
                string = "LBL_RenameField";
            } else if (refObject instanceof Parameter) {
                string = "LBL_RenameParameter";
            } else if (refObject instanceof LocalVariable) {
                string = "LBL_RenameLocVariable";
            } else if (refObject instanceof Attribute) {
                string = "LBL_RenameAttribute";
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Invalid type " + refObject.getClass()));
            }
            this.text = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$api$RenameRefactoring == null ? (class$org$netbeans$modules$refactoring$api$RenameRefactoring = RenameRefactoringPlugin.class$("org.netbeans.modules.refactoring.api.RenameRefactoring")) : class$org$netbeans$modules$refactoring$api$RenameRefactoring), (String)string), RenameRefactoringPlugin.this.newName);
        }

        private boolean isResourceClass() {
            return RenameRefactoringPlugin.isResourceClass(this.res, this.refObject);
        }

        public String getDisplayText() {
            return this.text;
        }

        public Element getJavaElement() {
            return (Element)this.refObject;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null && !(this.refObject instanceof Resource)) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.refObject);
            }
            return this.bounds;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public void performChange() {
            if (this.refObject instanceof Resource) {
                JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
            } else {
                NamedElement namedElement = (NamedElement)this.refObject;
                if (namedElement instanceof JavaClass) {
                    this.oldName = ((JavaClass)namedElement).getSimpleName();
                    if (this.isResourceClass()) {
                        JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
                    }
                    ((JavaClass)namedElement).setSimpleName(RenameRefactoringPlugin.this.newName);
                } else {
                    this.oldName = namedElement.getName();
                    namedElement.setName(RenameRefactoringPlugin.this.newName);
                }
            }
        }

        private void doRename() {
            try {
                DataObject dataObject = JavaMetamodel.getManager().getDataObject(this.res);
                this.oldName = dataObject.getName();
                dataObject.rename(RenameRefactoringPlugin.this.newName);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                throw (RuntimeException)new RuntimeException().initCause(iOException);
            }
        }

        public void performExternalChange() {
            this.doRename();
        }

        public void undoExternalChange() {
            if (this.oldName == null) {
                return;
            }
            String string = RenameRefactoringPlugin.this.newName;
            RenameRefactoringPlugin.this.newName = this.oldName;
            this.oldName = string;
            this.doRename();
            RenameRefactoringPlugin.this.newName = string;
        }

        public FileObject getParentFile() {
            return null;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$refactoring$plugins$RenameRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$RenameRefactoringPlugin = RenameRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.RenameRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$RenameRefactoringPlugin).desiredAssertionStatus();
        }
    }
}

