/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.CodebaseClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.refactoring.CommentFinder;
import org.netbeans.modules.refactoring.WhereUsedElement;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.NbBundle;

public class WhereUsedQueryPlugin
extends JavaRefactoringPlugin
implements ProgressListener {
    private RefObject jmiObject;
    private boolean baseClass;
    private boolean overriders;
    private boolean subclasses;
    private boolean directOnly;
    private boolean findUsages = true;
    private WhereUsedQuery refactoring;

    public WhereUsedQueryPlugin(WhereUsedQuery whereUsedQuery) {
        this.refactoring = whereUsedQuery;
        this.jmiObject = (RefObject)whereUsedQuery.getRefactoredObject();
    }

    public Problem preCheck() {
        Problem problem = WhereUsedQueryPlugin.isElementAvail((Element)this.jmiObject);
        if (problem != null) {
            return problem;
        }
        if (this.jmiObject instanceof UnresolvedClass) {
            return new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        if (!(this.jmiObject instanceof Feature || this.jmiObject instanceof Variable || this.jmiObject instanceof JavaPackage || this.jmiObject instanceof TypeParameter)) {
            return new Problem(true, NbBundle.getMessage((Class)WhereUsedQuery.class, (String)"ERR_WhereUsedWrongType"));
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Resource resource;
        block12: {
            Problem problem;
            block11: {
                CommentFinder commentFinder = null;
                JavaMetamodel.getManager().getProgressSupport().addProgressListener((ProgressListener)this);
                try {
                    boolean bl;
                    long l = 0L;
                    if (JMManager.PERF_DEBUG) {
                        l = System.currentTimeMillis();
                    }
                    if (bl = this.refactoring.isFindUsages() && this.refactoring.isSearchInComments()) {
                        resource = this.convertResource();
                        commentFinder = new CommentFinder((Element)this.jmiObject);
                        if (resource != null) {
                            refactoringElementsBag.addAll(this.refactoring, commentFinder.searchCommentsInResource(resource));
                        }
                    }
                    this.referencesIterator = this.jmiObject instanceof Method ? ((Method)this.jmiObject).findDependencies(this.findUsages, false, this.overriders).iterator() : (this.jmiObject instanceof JavaClass && (this.subclasses || this.directOnly) ? ((JavaClass)this.jmiObject).findSubTypes(!this.directOnly).iterator() : ((NamedElement)this.jmiObject).getReferences().iterator());
                    while (this.referencesIterator.hasNext()) {
                        resource = (Element)this.referencesIterator.next();
                        Resource resource2 = resource.getResource();
                        if ((resource2.getStatus() & Integer.MIN_VALUE) != 0) continue;
                        if (this.cancelRequest) {
                            problem = null;
                            Object var12_9 = null;
                            this.referencesIterator = null;
                            break block11;
                        }
                        if (bl) {
                            refactoringElementsBag.addAll(this.refactoring, commentFinder.searchCommentsInResource(resource2));
                        }
                        refactoringElementsBag.add(this.refactoring, new WhereUsedElement(this.jmiObject, (Element)resource));
                    }
                    if (JMManager.PERF_DEBUG) {
                        long l2 = System.currentTimeMillis();
                        long l3 = l2 - l;
                        System.out.print("PERF: Collecting usages of '");
                        if (this.jmiObject instanceof NamedElement) {
                            System.out.print(((NamedElement)this.jmiObject).getName());
                        } else {
                            System.out.print("unknown");
                        }
                        System.out.println("' takes " + l3 + " ms.");
                    }
                    resource = null;
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    this.referencesIterator = null;
                    JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
                    throw throwable;
                }
            }
            JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
            return problem;
        }
        Object var12_10 = null;
        this.referencesIterator = null;
        JavaMetamodel.getManager().getProgressSupport().removeProgressListener((ProgressListener)this);
        return resource;
    }

    public Problem fastCheckParameters() {
        if (this.jmiObject instanceof Method) {
            return this.checkParametersForMethod(this.refactoring.isSearchFromBaseClass(), this.refactoring.isFindOverridingMethods(), this.refactoring.isFindUsages());
        }
        if (this.jmiObject instanceof JavaClass) {
            return this.checkParametersForClass(this.refactoring.isFindSubclasses(), this.refactoring.isFindDirectSubclassesOnly());
        }
        return null;
    }

    public Problem checkParameters() {
        if (this.jmiObject instanceof Method) {
            return this.setParametersForMethod(this.refactoring.isSearchFromBaseClass(), this.refactoring.isFindOverridingMethods(), this.refactoring.isFindUsages());
        }
        if (this.jmiObject instanceof JavaClass) {
            return this.setParametersForClass(this.refactoring.isFindSubclasses(), this.refactoring.isFindDirectSubclassesOnly());
        }
        return null;
    }

    private Problem checkParametersForMethod(boolean bl, boolean bl2, boolean bl3) {
        if (!bl3 && !bl2) {
            return new Problem(true, NbBundle.getMessage((Class)WhereUsedQuery.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    private Problem setParametersForMethod(boolean bl, boolean bl2, boolean bl3) {
        Collection collection;
        this.baseClass = bl;
        this.overriders = bl2;
        this.findUsages = bl3;
        if (bl && !(collection = JavaModelUtil.getOverriddenMethods((Method)((Method)this.jmiObject))).isEmpty()) {
            this.jmiObject = (Method)collection.iterator().next();
        }
        return null;
    }

    private Resource convertResource() {
        JavaClass javaClass;
        JavaModelPackage javaModelPackage;
        Type type;
        Iterator iterator;
        Resource resource = ((Element)this.jmiObject).getResource();
        if (resource != null && (iterator = resource.getClassifiers().iterator()).hasNext() && (type = (javaModelPackage = (JavaModelPackage)(javaClass = (JavaClass)iterator.next()).refImmediatePackage()).getType().resolve(javaClass.getName())) != null) {
            Resource resource2 = type.getResource();
            CodebaseClass codebaseClass = ((JavaModelPackage)resource2.refImmediatePackage()).getCodebase();
            Codebase codebase = (Codebase)codebaseClass.refAllOfClass().iterator().next();
            if (resource2 != null && resource2.getName().endsWith(".java") && !codebase.isLibrary()) {
                return resource2;
            }
        }
        return null;
    }

    private Problem checkParametersForClass(boolean bl, boolean bl2) {
        return null;
    }

    private Problem setParametersForClass(boolean bl, boolean bl2) {
        this.subclasses = bl;
        this.directOnly = bl2;
        return null;
    }

    public void start(ProgressEvent progressEvent) {
        this.fireProgressListenerStart(progressEvent.getOperationType(), progressEvent.getCount());
    }

    public void step(ProgressEvent progressEvent) {
        this.fireProgressListenerStep();
    }

    public void stop(ProgressEvent progressEvent) {
        this.fireProgressListenerStop();
    }
}

