/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.APIAccessor;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.SPIAccessor;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.AccessorImpl;
import org.netbeans.modules.refactoring.spi.GuardedBlockHandler;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;

public final class RefactoringElementsBag {
    private final List delegate;
    private final RefactoringSession session;
    private Collection readOnlyFiles = new HashSet();

    RefactoringElementsBag(RefactoringSession refactoringSession, List list) {
        this.session = refactoringSession;
        this.delegate = list;
    }

    public Problem add(AbstractRefactoring abstractRefactoring, RefactoringElementImplementation refactoringElementImplementation) {
        Problem problem = null;
        if (CheckUtils.isRefactoringElementReadOnly(refactoringElementImplementation)) {
            Resource resource = refactoringElementImplementation.getJavaElement().getResource();
            FileObject fileObject = resource == null ? refactoringElementImplementation.getParentFile() : JavaModel.getFileObject((Resource)resource);
            this.readOnlyFiles.add(fileObject);
            refactoringElementImplementation.setEnabled(false);
            refactoringElementImplementation.setStatus(3);
            this.delegate.add(refactoringElementImplementation);
        } else if (CheckUtils.isRefactoringElementGuarded(refactoringElementImplementation)) {
            Iterator iterator = APIAccessor.DEFAULT.getGBHandlers(abstractRefactoring).iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                GuardedBlockHandler guardedBlockHandler = (GuardedBlockHandler)iterator.next();
                problem = APIAccessor.DEFAULT.chainProblems(guardedBlockHandler.handleChange(refactoringElementImplementation, arrayList), problem);
                if (problem != null && problem.isFatal()) {
                    return problem;
                }
                if (arrayList.isEmpty()) continue;
                this.delegate.addAll(arrayList);
                return problem;
            }
            refactoringElementImplementation.setEnabled(false);
            refactoringElementImplementation.setStatus(2);
            this.delegate.add(refactoringElementImplementation);
        } else {
            this.delegate.add(refactoringElementImplementation);
        }
        return problem;
    }

    public Problem addAll(AbstractRefactoring abstractRefactoring, Collection collection) {
        Problem problem = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if ((problem = APIAccessor.DEFAULT.chainProblems(problem, this.add(abstractRefactoring, (RefactoringElementImplementation)iterator.next()))) == null || !problem.isFatal()) continue;
            return problem;
        }
        return problem;
    }

    public RefactoringSession getSession() {
        return this.session;
    }

    Collection getReadOnlyFiles() {
        return this.readOnlyFiles;
    }

    static {
        SPIAccessor.DEFAULT = new AccessorImpl();
    }
}

