/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.ui;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.spi.ui.RefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.RefactoringPanel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public abstract class AbstractRefactoringAction
extends NodeAction
implements RefactoringAction,
Runnable {
    private Node[] activatedNodes;
    private int caretPosition;
    private int startSelectionPosition;
    private int endSelectionPosition;
    private static DelegateTextAction delegate = new DelegateTextAction();
    private boolean invokedExternally = false;

    public AbstractRefactoringAction(String string, Icon icon) {
        this.setName(string);
        this.setIcon(icon);
    }

    public final String getName() {
        return (String)this.getValue("Name");
    }

    protected void setName(String string) {
        this.putValue("Name", string);
    }

    protected void setMnemonic(char c) {
        this.putValue("MnemonicKey", new Integer(c));
    }

    public final void performAction(final Node[] nodeArray) {
        Runnable runnable = new Runnable(){

            public void run() {
                AbstractRefactoringAction.this.processContext(nodeArray, delegate.getTextComponent());
                AbstractRefactoringAction.this.run();
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(runnable, AbstractRefactoringAction.trim(this.getName()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == RefactoringActionsFactory.DEFAULT_EVENT) {
            this.invokedExternally = true;
        }
        AbstractRefactoringAction.super.actionPerformed(actionEvent);
        if (actionEvent == RefactoringActionsFactory.DEFAULT_EVENT) {
            this.invokedExternally = false;
        }
    }

    private static String trim(String string) {
        string = Utilities.replaceString((String)string, (String)"&", (String)"");
        return Utilities.replaceString((String)string, (String)"...", (String)"");
    }

    protected abstract boolean enabled(Node[] var1);

    protected abstract RefactoringUI createRefactoringUI(Node[] var1, Element var2);

    protected RefactoringUI createRefactoringUI(Element element, int n, int n2) {
        return this.createRefactoringUI(this.activatedNodes, element);
    }

    public final void processContext(Node[] nodeArray, JTextComponent jTextComponent) {
        this.activatedNodes = nodeArray;
        this.setCaretPosition(jTextComponent);
        boolean bl = this.enabled(nodeArray);
        this.setEnabled(bl);
    }

    private void setCaretPosition(JTextComponent jTextComponent) {
        JEditorPane jEditorPane;
        TopComponent topComponent;
        EditorCookie editorCookie;
        this.caretPosition = -1;
        if (this.activatedNodes == null || jTextComponent == null || this.invokedExternally) {
            return;
        }
        DataObject dataObject = (DataObject)this.activatedNodes[0].getCookie(DataObject.class);
        if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null && (topComponent = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane && jTextComponent.equals(jEditorPane = ((CloneableEditorSupport.Pane)topComponent).getEditorPane())) {
            this.caretPosition = jTextComponent.getCaretPosition();
            this.startSelectionPosition = jTextComponent.getSelectionStart();
            this.endSelectionPosition = jTextComponent.getSelectionEnd();
            if (this.startSelectionPosition != this.endSelectionPosition && this.endSelectionPosition == this.caretPosition) {
                --this.caretPosition;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        TopComponent topComponent;
        Element element = null;
        MDRepository mDRepository = JavaModel.getJavaRepository();
        RefactoringUI refactoringUI = null;
        mDRepository.beginTrans(true);
        try {
            if (this.caretPosition != -1) {
                DataObject dataObject = (DataObject)this.activatedNodes[0].getCookie(DataObject.class);
                while (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                topComponent = dataObject.getPrimaryFile();
                JavaModel.setClassPath((FileObject)topComponent);
                element = JavaMetamodel.getManager().getElementByOffset((FileObject)topComponent, this.caretPosition);
                if (element != null && this.startSelectionPosition != this.endSelectionPosition) {
                    refactoringUI = this.createRefactoringUI(element, this.startSelectionPosition, this.endSelectionPosition);
                }
            }
            if (refactoringUI == null) {
                refactoringUI = this.createRefactoringUI(this.activatedNodes, element);
            }
        }
        finally {
            mDRepository.endTrans();
        }
        topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent instanceof CloneableEditorSupport.Pane) {
            new RefactoringPanel(refactoringUI, topComponent);
        } else {
            new RefactoringPanel(refactoringUI);
        }
    }

    public boolean enable(Node[] nodeArray) {
        return this.enabled(nodeArray);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("enabled".equals(string)) {
            if (object2 != null) {
                super.firePropertyChange(string, object, object2);
            }
        } else {
            super.firePropertyChange(string, object, object2);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private static final class DelegateTextAction
    extends TextAction {
        public DelegateTextAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JTextComponent getTextComponent() {
            return this.getFocusedComponent();
        }
    }
}

