/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.jmi.reflect.RefObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.javacore.jmiimpl.javamodel.CallableFeatureImpl;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.openide.util.NbBundle;

public class ChangeParametersPanel
extends CustomRefactoringPanel {
    RefObject refactoredObj;
    ParamTableModel model;
    private ParametersPanel parent;
    private static Action editAction = null;
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final String[] columnNames = new String[]{ChangeParametersPanel.getString("LBL_ChangeParsColName"), ChangeParametersPanel.getString("LBL_ChangeParsColType"), ChangeParametersPanel.getString("LBL_ChangeParsColDefVal"), ChangeParametersPanel.getString("LBL_ChangeParsColOrigIdx"), ChangeParametersPanel.getString("LBL_ChangeParsParUsed")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    private boolean initialized = false;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JPanel eastPanel;
    private JPanel fillPanel;
    private JComboBox modifiersCombo;
    private JLabel modifiersLabel;
    private JPanel modifiersPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JTable paramTable;
    private JLabel paramTitle;
    private JLabel previewChange;
    private JButton removeButton;
    private JScrollPane westPanel;

    public ChangeParametersPanel(RefObject refObject, ParametersPanel parametersPanel) {
        this.refactoredObj = refObject;
        this.parent = parametersPanel;
        this.model = new ParamTableModel(columnNames, 0);
        this.initComponents();
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        ClassDefinition classDefinition = ((CallableFeature)this.refactoredObj).getDeclaringClass();
        if (classDefinition instanceof JavaClass && ((JavaClass)classDefinition).isInterface()) {
            this.modifiersCombo.setEnabled(false);
        }
        this.initTableData();
        this.setModifier();
        this.previewChange.setText(this.genDeclarationString());
        this.initialized = true;
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    protected int getModifier() {
        switch (this.modifiersCombo.getSelectedIndex()) {
            case 3: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 1: {
                return 4;
            }
        }
        return 1;
    }

    private void initComponents() {
        this.modifiersPanel = new JPanel();
        this.modifiersLabel = new JLabel();
        this.modifiersCombo = new JComboBox();
        this.eastPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.fillPanel = new JPanel();
        this.westPanel = new JScrollPane();
        this.paramTable = new JTable();
        this.paramTitle = new JLabel();
        this.previewChange = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setName(ChangeParametersPanel.getString("LBL_TitleChangeParameters"));
        this.modifiersPanel.setLayout(new GridBagLayout());
        this.modifiersLabel.setDisplayedMnemonic(ChangeParametersPanel.getString("LBL_ChangeParsMods_MNEM").charAt(0));
        this.modifiersLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ChangeParsMods"));
        this.modifiersLabel.setLabelFor(this.modifiersCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.modifiersPanel.add((Component)this.modifiersLabel, gridBagConstraints);
        this.modifiersCombo.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.modifiersCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.modifiersComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.modifiersPanel.add((Component)this.modifiersCombo, gridBagConstraints);
        this.modifiersCombo.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_modifiersCombo"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.modifiersPanel, gridBagConstraints);
        this.eastPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(1, 11, 1, 1));
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ChangeParsAdd"));
        this.addButton.setMnemonic(ChangeParametersPanel.getString("LBL_ChangeParsAdd_MNEM").charAt(0));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_ChangeParsAdd"));
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ChangeParsRemove"));
        this.removeButton.setMnemonic(ChangeParametersPanel.getString("LBL_ChangeParsRemove_MNEM").charAt(0));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_ChangeParsRemove"));
        this.moveUpButton.setText(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ChangeParsMoveUp"));
        this.moveUpButton.setMnemonic(ChangeParametersPanel.getString("LBL_ChangeParsMoveUp_MNEM").charAt(0));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.moveUpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_ChangeParsMoveUp"));
        this.moveDownButton.setText(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ChangeParsMoveDown"));
        this.moveDownButton.setMnemonic(ChangeParametersPanel.getString("LBL_ChangeParsMoveDown_MNEM").charAt(0));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeParametersPanel.this.moveDownButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_ChangeParsMoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.eastPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.eastPanel.add((Component)this.fillPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.eastPanel, gridBagConstraints);
        this.westPanel.setPreferredSize(new Dimension(453, 100));
        this.paramTable.setModel(this.model);
        this.initRenderer();
        this.paramTable.getSelectionModel().addListSelectionListener(this.getListener1());
        this.paramTable.getSelectionModel().setSelectionMode(1);
        this.model.addTableModelListener(this.getListener2());
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getActionMap().put(ACTION_INLINE_EDITOR, ChangeParametersPanel.getEditAction());
        this.paramTable.setSurrendersFocusOnKeystroke(true);
        this.paramTable.setCellSelectionEnabled(false);
        this.paramTable.setRowSelectionAllowed(true);
        this.paramTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.paramTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.westPanel.setViewportView(this.paramTable);
        this.paramTable.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_paramTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.westPanel, gridBagConstraints);
        this.paramTitle.setDisplayedMnemonic(ChangeParametersPanel.getString("LBL_ChangeParsParameters_MNEM").charAt(0));
        this.paramTitle.setHorizontalAlignment(2);
        this.paramTitle.setLabelFor(this.paramTable);
        this.paramTitle.setText(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_ChangeParsParameters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.paramTitle, gridBagConstraints);
        this.previewChange.setBorder(BorderFactory.createTitledBorder(NbBundle.getBundle((Class)ChangeParametersPanel.class).getString("LBL_ChangeParsPreview")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.previewChange, gridBagConstraints);
    }

    private void modifiersComboActionPerformed(ActionEvent actionEvent) {
        this.previewChange.setText(this.genDeclarationString());
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptEditedValue();
        int[] nArray = this.paramTable.getSelectedRows();
        ListSelectionModel listSelectionModel = this.paramTable.getSelectionModel();
        for (int i = 0; i < nArray.length; ++i) {
            this.model.removeRow(nArray[i] - i);
        }
        listSelectionModel.clearSelection();
    }

    private void moveDownButtonActionPerformed(ActionEvent actionEvent) {
        this.doMove(1);
    }

    private void moveUpButtonActionPerformed(ActionEvent actionEvent) {
        this.doMove(-1);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptEditedValue();
        int n = this.model.getRowCount();
        this.model.addRow(new Object[]{"par" + n, "Object", "null", new Integer(-1), Boolean.TRUE});
    }

    private ListSelectionListener getListener1() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    int n2 = listSelectionModel.getMaxSelectionIndex();
                    ChangeParametersPanel.this.setButtons(n, n2);
                    boolean bl = true;
                    for (int i = n; i <= n2 && (bl = ChangeParametersPanel.this.model.isRemovable(i)); ++i) {
                    }
                    ChangeParametersPanel.this.removeButton.setEnabled(bl);
                } else {
                    ChangeParametersPanel.this.moveDownButton.setEnabled(false);
                    ChangeParametersPanel.this.moveUpButton.setEnabled(false);
                    ChangeParametersPanel.this.removeButton.setEnabled(false);
                }
            }
        };
    }

    private TableModelListener getListener2() {
        return new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int[] nArray = ChangeParametersPanel.this.paramTable.getSelectedRows();
                if (nArray.length == 0) {
                    ChangeParametersPanel.this.removeButton.setEnabled(false);
                } else {
                    int n;
                    boolean bl = true;
                    for (n = 0; n < nArray.length && (nArray[n] >= ChangeParametersPanel.this.model.getRowCount() || (bl = ChangeParametersPanel.this.model.isCellEditable(nArray[n], 0))); ++n) {
                    }
                    ChangeParametersPanel.this.removeButton.setEnabled(bl);
                    n = nArray[0];
                    int n2 = nArray[nArray.length - 1];
                    ChangeParametersPanel.this.setButtons(n, n2);
                }
                ChangeParametersPanel.this.previewChange.setText(ChangeParametersPanel.this.genDeclarationString());
                ChangeParametersPanel.this.parent.stateChanged(null);
            }
        };
    }

    private void initTableData() {
        Object object;
        CallableFeatureImpl callableFeatureImpl = (CallableFeatureImpl)this.refactoredObj;
        List list = ((CallableFeature)this.refactoredObj).getParameters();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (Parameter)object2.next();
            arrayList.add(object.getType());
        }
        object2 = new ArrayList();
        if (callableFeatureImpl instanceof Method) {
            object2.addAll(CheckUtils.overrides((Method)callableFeatureImpl, callableFeatureImpl.getName(), arrayList, true));
            object2.addAll(CheckUtils.isOverridden((Method)callableFeatureImpl, callableFeatureImpl.getName(), arrayList));
        }
        object2.add(callableFeatureImpl);
        object = object2.iterator();
        while (object.hasNext()) {
            int n = 0;
            List list2 = ((CallableFeature)object.next()).getParameters();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                Type type = parameter.getType();
                String string = ChangeParametersPanel.getTypeStringRepresentation(type);
                Boolean bl = parameter.getReferences().isEmpty();
                if (this.model.getRowCount() <= n) {
                    Object[] objectArray = new Object[]{parameter.getName(), string, "", new Integer(n), bl};
                    this.model.addRow(objectArray);
                } else {
                    bl = this.model.isRemovable(n) && bl != false;
                    this.model.getDataVector().get(n).set(4, bl);
                }
                ++n;
            }
        }
    }

    private static String getTypeStringRepresentation(Type type) {
        return type.getName();
    }

    private boolean acceptEditedValue() {
        TableCellEditor tableCellEditor = this.paramTable.getCellEditor();
        if (tableCellEditor != null) {
            return this.paramTable.getCellEditor().stopCellEditing();
        }
        return false;
    }

    private void doMove(int n) {
        this.acceptEditedValue();
        ListSelectionModel listSelectionModel = this.paramTable.getSelectionModel();
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        listSelectionModel.clearSelection();
        this.model.moveRow(n2, n3, n2 + n);
        listSelectionModel.addSelectionInterval(n2 + n, n3 + n);
    }

    private void setButtons(int n, int n2) {
        int n3 = this.model.getRowCount() - 1;
        this.moveUpButton.setEnabled(n > 0);
        this.moveDownButton.setEnabled(n2 < n3);
    }

    private void initRenderer() {
        TableColumnModel tableColumnModel = this.paramTable.getColumnModel();
        this.paramTable.removeColumn(tableColumnModel.getColumn(3));
        this.paramTable.removeColumn(tableColumnModel.getColumn(3));
        Enumeration<TableColumn> enumeration = this.paramTable.getColumnModel().getColumns();
        TableColumn tableColumn = null;
        while (enumeration.hasMoreElements()) {
            tableColumn = enumeration.nextElement();
            tableColumn.setCellRenderer(new ParamRenderer());
        }
    }

    private void setModifier() {
        int n = ((CallableFeature)this.refactoredObj).getModifiers();
        if (Modifier.isPrivate(n)) {
            this.modifiersCombo.setSelectedIndex(3);
        } else if (Modifier.isProtected(n)) {
            this.modifiersCombo.setSelectedIndex(1);
        } else if (Modifier.isPublic(n)) {
            this.modifiersCombo.setSelectedIndex(0);
        } else {
            this.modifiersCombo.setSelectedIndex(2);
        }
    }

    public String genDeclarationString() {
        String string;
        List[] listArray;
        String string2 = this.modifiersCombo.getSelectedIndex() != 2 ? (String)this.modifiersCombo.getSelectedItem() + ' ' : "";
        StringBuffer stringBuffer = new StringBuffer(string2);
        String string3 = Modifier.toString(((CallableFeature)this.refactoredObj).getModifiers() & 0xFFFFFFF8);
        if (string3.length() != 0) {
            stringBuffer.append(string3);
            stringBuffer.append(' ');
        }
        if (this.refactoredObj instanceof Method) {
            listArray = (List[])this.refactoredObj;
            stringBuffer.append(ChangeParametersPanel.getTypeStringRepresentation(listArray.getType()));
            stringBuffer.append(' ');
            string = listArray.getName();
        } else {
            string = ((JavaClass)((CallableFeature)this.refactoredObj).getDeclaringClass()).getSimpleName();
        }
        stringBuffer.append(string);
        stringBuffer.append('(');
        listArray = this.model.getDataVector().toArray(new List[0]);
        if (listArray.length > 0) {
            int n;
            for (n = 0; n < listArray.length - 1; ++n) {
                stringBuffer.append((String)listArray[n].get(1));
                stringBuffer.append(' ');
                stringBuffer.append((String)listArray[n].get(0));
                stringBuffer.append(',').append(' ');
            }
            stringBuffer.append((String)listArray[n].get(1));
            stringBuffer.append(' ');
            stringBuffer.append((String)listArray[n].get(0));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)ChangeParametersPanel.class, (String)string);
    }

    private static Action getEditAction() {
        if (editAction == null) {
            editAction = new EditAction();
        }
        return editAction;
    }

    private static void autoEdit(JTable jTable) {
        if (jTable.editCellAt(jTable.getSelectedRow(), jTable.getSelectedColumn(), null) && jTable.getEditorComponent() != null) {
            JTextField jTextField = (JTextField)jTable.getEditorComponent();
            int n = jTextField.getText().length();
            jTextField.setCaretPosition(jTextField.getText().length());
            jTextField.requestFocusInWindow();
            jTextField.selectAll();
        }
    }

    class ParamRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        Color origBackground;

        public ParamRenderer() {
            this.setOpaque(true);
            this.origBackground = this.getBackground();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = ChangeParametersPanel.this.model.isRemovable(n);
            if (!bl) {
                if (!bl3) {
                    this.setBackground(UIManager.getColor("Panel.background"));
                } else {
                    this.setBackground(this.origBackground);
                }
            }
            return this;
        }
    }

    private static class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChangeParametersPanel.autoEdit((JTable)actionEvent.getSource());
        }
    }

    static class ParamTableModel
    extends DefaultTableModel {
        public ParamTableModel(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 > 2) {
                return false;
            }
            Integer n3 = (Integer)this.getDataVector().get(n).get(3);
            return n3 == -1;
        }

        public boolean isRemovable(int n) {
            return (Boolean)this.getDataVector().get(n).get(4);
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

