/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class CheckNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private int selectionMode;
    private boolean isSelected = true;
    private String nodeLabel;
    private Icon icon;
    private boolean disabled = false;
    private boolean needsRefresh = false;
    private PositionBounds bounds = null;
    private String resourceName;
    private String tooltip;

    public CheckNode(Object object, String string, Icon icon) {
        super(object, !(object instanceof RefactoringElement));
        this.setSelectionMode(4);
        this.nodeLabel = string;
        this.icon = icon;
        if (object instanceof RefactoringElement) {
            Element element;
            RefactoringElement refactoringElement = (RefactoringElement)object;
            FileObject fileObject = refactoringElement.getParentFile();
            if (fileObject == null && (fileObject = JavaModel.getFileObject((Resource)(element = refactoringElement.getJavaElement()).getResource())) == null) {
                this.resourceName = null;
                return;
            }
            element = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            this.resourceName = element != null ? element.getResourceName(fileObject) : null;
        }
    }

    String getLabel() {
        return this.nodeLabel;
    }

    Icon getIcon() {
        return this.icon;
    }

    public void setDisabled() {
        this.disabled = true;
        this.isSelected = false;
        this.removeAllChildren();
    }

    boolean isDisabled() {
        return this.disabled;
    }

    void setNeedsRefresh() {
        this.needsRefresh = true;
        this.setDisabled();
    }

    boolean needsRefresh() {
        return this.needsRefresh;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        if (this.userObject instanceof RefactoringElement) {
            ((RefactoringElement)this.userObject).setEnabled(bl);
        }
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CheckNode checkNode = (CheckNode)enumeration.nextElement();
                checkNode.setSelected(bl);
            }
        }
    }

    public boolean isSelected() {
        if (this.userObject instanceof RefactoringElement) {
            return ((RefactoringElement)this.userObject).isEnabled() && ((RefactoringElement)this.userObject).getStatus() != 2 && ((RefactoringElement)this.userObject).getStatus() != 3;
        }
        return this.isSelected;
    }

    public PositionBounds getPosition() {
        if (this.userObject instanceof RefactoringElement) {
            return ((RefactoringElement)this.userObject).getPosition();
        }
        return null;
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            if (this.resourceName != null && this.userObject instanceof RefactoringElement) {
                RefactoringElement refactoringElement = (RefactoringElement)this.userObject;
                PositionBounds positionBounds = this.getPosition();
                if (positionBounds != null) {
                    int n;
                    try {
                        n = positionBounds.getBegin().getLine() + 1;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    this.tooltip = this.resourceName + ':' + n;
                }
            }
            return null;
        }
        return this.tooltip;
    }
}

