/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.ui.CheckNode;
import org.netbeans.modules.refactoring.ui.CheckRenderer;

class CheckNodeListener
implements MouseListener,
KeyListener {
    private final boolean isQuery;

    public CheckNodeListener(boolean bl) {
        this.isQuery = bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        JTree jTree = (JTree)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        int n2 = mouseEvent.getX();
        int n3 = jTree.getRowForLocation(n2, n = mouseEvent.getY());
        TreePath treePath = jTree.getPathForRow(n3);
        if (treePath != null) {
            CheckNode checkNode = (CheckNode)treePath.getLastPathComponent();
            if (this.isQuery) {
                if (mouseEvent.getClickCount() == 2) {
                    if (checkNode.getUserObject() instanceof RefactoringElement) {
                        CheckNodeListener.findInSource(checkNode);
                    } else if (jTree.isCollapsed(n3)) {
                        jTree.expandRow(n3);
                    } else {
                        jTree.collapseRow(n3);
                    }
                }
            } else {
                Rectangle rectangle = CheckRenderer.getCheckBoxRectangle();
                Rectangle rectangle2 = jTree.getPathBounds(treePath);
                rectangle.setLocation(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y);
                if (mouseEvent.getClickCount() == 1 && rectangle.contains(point)) {
                    boolean bl = !checkNode.isSelected();
                    checkNode.setSelected(bl);
                    if (checkNode.getSelectionMode() == 4) {
                        if (bl) {
                            jTree.expandPath(treePath);
                        } else {
                            jTree.collapsePath(treePath);
                        }
                    }
                    ((DefaultTreeModel)jTree.getModel()).nodeChanged(checkNode);
                    if (n3 == 0) {
                        jTree.revalidate();
                        jTree.repaint();
                    }
                } else if (mouseEvent.getClickCount() == 2 && !rectangle.contains(point)) {
                    if (checkNode.getUserObject() instanceof RefactoringElement) {
                        CheckNodeListener.findInSource(checkNode);
                    } else if (jTree.isCollapsed(n3)) {
                        jTree.expandRow(n3);
                    } else {
                        jTree.collapseRow(n3);
                    }
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        JTree jTree;
        TreePath treePath;
        if (keyEvent.getKeyCode() == 10 && (treePath = (jTree = (JTree)keyEvent.getSource()).getSelectionPath()) != null) {
            CheckNode checkNode = (CheckNode)treePath.getLastPathComponent();
            CheckNodeListener.findInSource(checkNode);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        JTree jTree;
        TreePath treePath;
        if (keyEvent.getKeyChar() == ' ' && (treePath = (jTree = (JTree)keyEvent.getSource()).getSelectionPath()) != null) {
            CheckNode checkNode;
            checkNode.setSelected(!(checkNode = (CheckNode)treePath.getLastPathComponent()).isSelected());
            keyEvent.consume();
        }
    }

    static void findInSource(CheckNode checkNode) {
        Object object = checkNode.getUserObject();
        if (object instanceof RefactoringElement) {
            ((RefactoringElement)object).openInEditor();
        }
    }
}

