/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.ui.MoveClassAction;
import org.openide.ErrorManager;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.PasteType;

public class ClipboardConvertor
implements ExClipboard.Convertor {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$refactoring$ui$MoveClassAction;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public Transferable convert(Transferable transferable) {
        Node[] nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)4);
        if (nodeArray != null && nodeArray.length > 0) {
            return NodeTransfer.createPaste((NodeTransfer.Paste)new RefactoringPaste(transferable, nodeArray));
        }
        return transferable;
    }

    private boolean getDOs(Node[] nodeArray, Set set) {
        DataObject dataObject;
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        boolean bl = false;
        for (int i = 0; i < nodeArray.length; ++i) {
            dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? ClipboardConvertor.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (!ClipboardConvertor.isOnClassPath(dataObject)) {
                return false;
            }
            if (dataObject instanceof DataFolder) {
                hashSet.add(dataObject);
            } else if (dataObject instanceof JavaDataObject) {
                bl = true;
            }
            set.add(dataObject);
        }
        if (bl) {
            return true;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            dataObject = (DataFolder)iterator.next();
            Enumeration enumeration = dataObject.children(true);
            while (enumeration.hasMoreElements()) {
                if (!(enumeration.nextElement() instanceof JavaDataObject)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isOnClassPath(DataObject dataObject) {
        if (dataObject == null) {
            return false;
        }
        return ((JMManager)JavaMetamodel.getManager()).getMergedClassPath().contains(dataObject.getPrimaryFile());
    }

    private class RefactoringPaste
    implements NodeTransfer.Paste {
        private Transferable orig;
        private Node nodes;

        RefactoringPaste(Transferable transferable) {
            this.orig = transferable;
        }

        RefactoringPaste(Transferable transferable, Node[] nodeArray) {
            this.orig = transferable;
            this.nodes = this.nodes;
        }

        public PasteType[] types(Node node) {
            if (node instanceof DataFolder.FolderNode) {
                return new PasteType[]{new RefactoringPasteType(this.orig, node)};
            }
            return node.getPasteTypes(this.orig);
        }
    }

    private class RefactoringPasteType
    extends PasteType {
        Node target;
        Transferable orig;

        RefactoringPasteType(Transferable transferable, Node node) {
            this.target = node;
            this.orig = transferable;
        }

        public Transferable paste() throws IOException {
            Node[] nodeArray = NodeTransfer.nodes((Transferable)this.orig, (int)4);
            HashSet hashSet = new HashSet(nodeArray.length);
            DataObject dataObject = (DataObject)this.target.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ClipboardConvertor.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            PasteType[] pasteTypeArray = this.target.getPasteTypes(this.orig);
            if (pasteTypeArray == null || pasteTypeArray.length == 0) {
                ErrorManager.getDefault().notify(1, (Throwable)new Exception("No paste type available"));
                return null;
            }
            if (!ClipboardConvertor.this.getDOs(nodeArray, hashSet) || !ClipboardConvertor.isOnClassPath(dataObject)) {
                pasteTypeArray[0].paste();
            } else {
                SwingUtilities.invokeLater(new Runnable(this, hashSet, pasteTypeArray){
                    private final /* synthetic */ HashSet val$set;
                    private final /* synthetic */ PasteType[] val$types;
                    private final /* synthetic */ RefactoringPasteType this$1;
                    {
                        this.this$1 = refactoringPasteType;
                        this.val$set = hashSet;
                        this.val$types = pasteTypeArray;
                    }

                    public void run() {
                        MoveClassAction moveClassAction = (MoveClassAction)MoveClassAction.findObject((Class)(class$org$netbeans$modules$refactoring$ui$MoveClassAction == null ? (class$org$netbeans$modules$refactoring$ui$MoveClassAction = ClipboardConvertor.class$("org.netbeans.modules.refactoring.ui.MoveClassAction")) : class$org$netbeans$modules$refactoring$ui$MoveClassAction));
                        moveClassAction.performAction(this.val$set, ((DataFolder)this.this$1.target.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ClipboardConvertor.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)).getPrimaryFile(), this.val$types[0]);
                    }
                });
            }
            return null;
        }
    }
}

