/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.jmi.reflect.RefObject;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EncapsulateFieldPanel
extends CustomRefactoringPanel {
    Field[] refactoredObjs;
    DefaultTableModel model;
    RefObject[] selectedObjects;
    ParametersPanel parent;
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final String[] columnNames = new String[]{EncapsulateFieldPanel.getString("LBL_ColField"), "    ", EncapsulateFieldPanel.getString("LBL_ColGetter"), "    ", EncapsulateFieldPanel.getString("LBL_ColSetter")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final Class[] columnTypes = new Class[]{Field.class, Boolean.class, String.class, Boolean.class, String.class};
    private boolean initialized = false;
    private JCheckBox jCheckAccess;
    private JComboBox jComboAccess;
    private JComboBox jComboField;
    private JLabel jLblAccessVis;
    private JLabel jLblFieldVis;
    private JLabel jLblTitle;
    private JScrollPane jScrollField;
    private JTable jTableFields;

    public EncapsulateFieldPanel(RefObject[] refObjectArray, ParametersPanel parametersPanel) {
        ClassDefinition classDefinition;
        Feature feature;
        String string = EncapsulateFieldPanel.getString("LBL_TitleEncapsulateFields");
        if (refObjectArray.length > 0 && (feature = JavaModelUtil.getDeclaringFeature((Element)((Element)refObjectArray[0]))) != null && (classDefinition = feature.getDeclaringClass()) instanceof JavaClass) {
            string = string + " - " + ((JavaClass)classDefinition).getName();
        }
        this.selectedObjects = refObjectArray;
        this.parent = parametersPanel;
        this.model = new TabM(columnNames, 0);
        this.initComponents();
        this.setName(string);
        this.jTableFields.setDefaultRenderer(Field.class, new UIUtilities.JavaElementTableCellRenderer());
        this.jScrollField.setBackground(this.jTableFields.getBackground());
        this.jScrollField.getViewport().setBackground(this.jTableFields.getBackground());
        this.jTableFields.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.jTableFields.setGridColor(UIManager.getColor("control"));
        }
    }

    public void initialize() {
        int n;
        if (this.initialized) {
            return;
        }
        this.refactoredObjs = this.initFields((Field)this.selectedObjects[0]);
        HashSet<String> hashSet = new HashSet<String>(this.selectedObjects.length);
        for (n = 0; n < this.selectedObjects.length; ++n) {
            hashSet.add(((Field)this.selectedObjects[n]).getName());
        }
        for (n = 0; n < this.refactoredObjs.length; ++n) {
            Field field = this.refactoredObjs[n];
            String string = field.getName();
            boolean bl = hashSet.contains(string);
            boolean bl2 = bl && !Modifier.isFinal(field.getModifiers());
            this.model.addRow(new Object[]{field, bl ? Boolean.TRUE : Boolean.FALSE, bl ? EncapsulateFieldRefactoringPlugin.computeGetterName(field) : null, bl2 ? Boolean.TRUE : Boolean.FALSE, bl2 ? EncapsulateFieldRefactoringPlugin.computeSetterName(field) : null});
        }
        this.packRows(this.jTableFields);
        this.jTableFields.getTableHeader().setReorderingAllowed(false);
        this.setColumnWidth(1);
        this.setColumnWidth(3);
        this.jTableFields.invalidate();
        this.jTableFields.repaint();
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                if (n == 1 || n == 3) {
                    Boolean bl = (Boolean)EncapsulateFieldPanel.this.model.getValueAt(n2, n);
                    if (bl.booleanValue()) {
                        if (n == 1) {
                            EncapsulateFieldPanel.this.model.setValueAt(EncapsulateFieldRefactoringPlugin.computeGetterName(EncapsulateFieldPanel.this.refactoredObjs[n2]), n2, n + 1);
                        } else {
                            EncapsulateFieldPanel.this.model.setValueAt(EncapsulateFieldRefactoringPlugin.computeSetterName(EncapsulateFieldPanel.this.refactoredObjs[n2]), n2, n + 1);
                        }
                    } else if (EncapsulateFieldPanel.this.model.getValueAt(n2, n + 1) != null) {
                        EncapsulateFieldPanel.this.model.setValueAt(null, n2, n + 1);
                    }
                } else {
                    String string = (String)EncapsulateFieldPanel.this.model.getValueAt(n2, n);
                    if (string == null | "".equals(string)) {
                        EncapsulateFieldPanel.this.model.setValueAt(Boolean.FALSE, n2, n - 1);
                    }
                }
                EncapsulateFieldPanel.this.parent.stateChanged(null);
            }
        });
        this.initialized = true;
    }

    private void setColumnWidth(int n) {
        TableColumn tableColumn = this.jTableFields.getColumnModel().getColumn(n);
        JCheckBox jCheckBox = new JCheckBox();
        int n2 = (int)jCheckBox.getPreferredSize().getWidth();
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setResizable(false);
    }

    private int getMinimumRowHeight(JTable jTable, int n) {
        int n2 = jTable.getRowHeight();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
            Component component = jTable.prepareRenderer(tableCellRenderer, n, i);
            int n3 = component.getMinimumSize().height;
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    private void packRows(JTable jTable) {
        int n = 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n2 = this.getMinimumRowHeight(jTable, i);
            if (n2 <= n) continue;
            n = n2;
        }
        jTable.setRowHeight(n);
        jTable.getTableHeader().setPreferredSize(new Dimension(jTable.getTableHeader().getPreferredSize().width, n));
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    private void initComponents() {
        this.jLblTitle = new JLabel();
        this.jScrollField = new JScrollPane();
        this.jTableFields = new JTable();
        this.jLblFieldVis = new JLabel();
        this.jComboField = new JComboBox();
        this.jLblAccessVis = new JLabel();
        this.jComboAccess = new JComboBox();
        this.jCheckAccess = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLblTitle.setLabelFor(this.jTableFields);
        Mnemonics.setLocalizedText((JLabel)this.jLblTitle, (String)EncapsulateFieldPanel.getString("LBL_FieldList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLblTitle, gridBagConstraints);
        this.jScrollField.setPreferredSize(new Dimension(300, 200));
        this.jTableFields.setModel(this.model);
        this.jScrollField.setViewportView(this.jTableFields);
        this.jTableFields.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_jTableFields"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 12, 2);
        this.add((Component)this.jScrollField, gridBagConstraints);
        this.jLblFieldVis.setLabelFor(this.jComboField);
        Mnemonics.setLocalizedText((JLabel)this.jLblFieldVis, (String)EncapsulateFieldPanel.getString("LBL_FieldVis"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        this.add((Component)this.jLblFieldVis, gridBagConstraints);
        this.jComboField.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jComboField.setSelectedIndex(3);
        this.jComboField.setPreferredSize(new Dimension(100, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jComboField, gridBagConstraints);
        this.jComboField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_fieldModifiers"));
        this.jLblAccessVis.setLabelFor(this.jComboAccess);
        Mnemonics.setLocalizedText((JLabel)this.jLblAccessVis, (String)EncapsulateFieldPanel.getString("LBL_AccessVis"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add((Component)this.jLblAccessVis, gridBagConstraints);
        this.jComboAccess.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jComboAccess.setSelectedIndex(0);
        this.jComboAccess.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jComboAccess, gridBagConstraints);
        this.jComboAccess.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_methodAcc"));
        this.jCheckAccess.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckAccess, (String)EncapsulateFieldPanel.getString("LBL_AccessorsEven"));
        this.jCheckAccess.setMargin(new Insets(12, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jCheckAccess, gridBagConstraints);
        this.jCheckAccess.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_useAccessors"));
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)EncapsulateFieldPanel.class, (String)string);
    }

    private Field[] initFields(Field field) {
        ClassDefinition classDefinition = field.getDeclaringClass();
        ArrayList arrayList = new ArrayList();
        List list = classDefinition.getFeatures();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Field) || e instanceof EnumConstant) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new Field[0]);
    }

    public Field[] getAllFields() {
        return this.refactoredObjs;
    }

    public boolean isCheckAccess() {
        return this.jCheckAccess.isSelected();
    }

    protected int[] getModifiers() {
        int[] nArray = new int[2];
        JComboBox jComboBox = this.jComboAccess;
        for (int i = 0; i < 2; ++i) {
            switch (jComboBox.getSelectedIndex()) {
                case 3: {
                    nArray[i] = 2;
                    break;
                }
                case 2: {
                    nArray[i] = 0;
                    break;
                }
                case 1: {
                    nArray[i] = 4;
                    break;
                }
                case 0: {
                    nArray[i] = 1;
                }
            }
            jComboBox = this.jComboField;
        }
        return nArray;
    }

    private static class TabM
    extends DefaultTableModel {
        public TabM(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        public Class getColumnClass(int n) {
            return columnTypes[n];
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1 || n2 == 3) {
                return true;
            }
            return (Boolean)this.getValueAt(n, n2 - 1);
        }
    }
}

