/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JEditorPane;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.MoveClassUI;
import org.netbeans.modules.refactoring.ui.MoveClassesUI;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

public class MoveClassAction
extends AbstractRefactoringAction {
    private boolean fromListener = false;
    private Set javaDataObjects;
    private FileObject targetFolder;
    private PasteType pasteType;

    public MoveClassAction() {
        super(NbBundle.getMessage((Class)MoveClassAction.class, (String)"LBL_MoveClassAction"), null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean enabled(Node[] nodeArray) {
        JEditorPane jEditorPane;
        if (nodeArray == null || nodeArray.length < 1) {
            return false;
        }
        Lookup lookup = nodeArray[0].getLookup();
        JavaDataObject javaDataObject = (JavaDataObject)lookup.lookup(JavaDataObject.class);
        if (javaDataObject != null && !((JMManager)JMManager.getManager()).mergedCPContains(javaDataObject.getPrimaryFile())) {
            return false;
        }
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent instanceof CloneableEditorSupport.Pane && (jEditorPane = ((CloneableEditorSupport.Pane)topComponent).getEditorPane()) != null) {
            return javaDataObject instanceof JavaDataObject;
        }
        jEditorPane = (Element)lookup.lookup(Element.class);
        if (javaDataObject != null && jEditorPane == null) {
            return true;
        }
        if (!(jEditorPane instanceof JavaClass)) {
            return false;
        }
        JavaClass javaClass = (JavaClass)jEditorPane;
        if (javaClass == null) {
            return false;
        }
        if (!javaClass.isValid()) {
            return false;
        }
        return javaClass.getDeclaringClass() == null;
    }

    protected RefactoringUI createRefactoringUI(Node[] nodeArray, Element element) {
        if (this.fromListener) {
            if (this.javaDataObjects.size() == 1 && this.javaDataObjects.iterator().next() instanceof JavaDataObject) {
                return new MoveClassUI((JavaDataObject)this.javaDataObjects.iterator().next(), this.targetFolder, this.pasteType);
            }
            return new MoveClassesUI(this.javaDataObjects, this.targetFolder, this.pasteType);
        }
        if (element != null) {
            if (element instanceof ElementReference) {
                element = ((ElementReference)element).getElement();
            }
            if (element instanceof JavaClass) {
                return new MoveClassUI((JavaClass)element);
            }
        }
        if (nodeArray.length > 1) {
            return new MoveClassesUI(this.getJDOs(nodeArray));
        }
        JavaClass javaClass = (JavaClass)nodeArray[0].getLookup().lookup(JavaClass.class);
        if (javaClass != null && javaClass.getDeclaringClass() == null) {
            return new MoveClassUI(javaClass);
        }
        return new MoveClassUI((JavaDataObject)nodeArray[0].getCookie(JavaDataObject.class));
    }

    public void performAction(final Set set, final FileObject fileObject, final PasteType pasteType) {
        Runnable runnable = new Runnable(){

            public void run() {
                MoveClassAction.this.fromListener = true;
                MoveClassAction.this.javaDataObjects = set;
                MoveClassAction.this.targetFolder = fileObject;
                MoveClassAction.this.pasteType = pasteType;
                MoveClassAction.super.performAction(null);
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(runnable, NbBundle.getMessage((Class)MoveClassAction.class, (String)"LBL_MoveClasses"));
    }

    public void performAction() {
        this.fromListener = false;
        super.performAction();
    }

    private Set getJDOs(Node[] nodeArray) {
        HashSet<JavaDataObject> hashSet = new HashSet<JavaDataObject>(nodeArray.length);
        for (int i = 0; i < nodeArray.length; ++i) {
            JavaDataObject javaDataObject = (JavaDataObject)nodeArray[i].getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? MoveClassAction.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject);
            if (javaDataObject == null) continue;
            hashSet.add(javaDataObject);
        }
        return hashSet;
    }
}

