/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.ui.RefactoringUIBypass;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class MoveClassUI
implements RefactoringUI,
RefactoringUIBypass {
    private JavaDataObject javaObject;
    private Resource resource;
    private JavaClass mainSourceClass;
    private MoveClassPanel panel;
    private MoveClassRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private JavaClass clazz = null;
    private FileObject targetFolder;
    private PasteType pasteType;

    static final String getString(String string) {
        return NbBundle.getMessage((Class)MoveClassUI.class, (String)string);
    }

    public MoveClassUI(JavaClass javaClass) {
        this.resource = javaClass.getResource();
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(this.resource);
        if (dataObject instanceof JavaDataObject) {
            this.javaObject = (JavaDataObject)dataObject;
        }
        this.clazz = javaClass;
        this.findMainClass();
    }

    public MoveClassUI(JavaDataObject javaDataObject) {
        this(javaDataObject, null, null);
    }

    public MoveClassUI(JavaDataObject javaDataObject, FileObject fileObject, PasteType pasteType) {
        this.disable = fileObject != null;
        this.targetFolder = fileObject;
        this.javaObject = javaDataObject;
        this.pasteType = pasteType;
        this.resource = JavaModel.getResource((FileObject)javaDataObject.getPrimaryFile());
        this.findMainClass();
    }

    public String getName() {
        return MoveClassUI.getString("LBL_MoveClass");
    }

    public String getDescription() {
        if (this.mainSourceClass == null) {
            return new MessageFormat(MoveClassUI.getString("DSC_MoveClass")).format(new Object[]{this.javaObject.getName(), this.packageName()});
        }
        if (this.mainSourceClass.isValid()) {
            return new MessageFormat(MoveClassUI.getString("DSC_MoveClass")).format(new Object[]{this.mainSourceClass.getName(), this.packageName()});
        }
        return "";
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parametersPanel) {
        if (this.panel == null) {
            ClassPath classPath;
            String string = null;
            if (this.targetFolder != null && (classPath = ClassPath.getClassPath((FileObject)this.targetFolder, (String)"classpath/source")) != null) {
                string = classPath.getResourceName(this.targetFolder, '.', false);
            }
            this.panel = new MoveClassPanel(parametersPanel, string != null ? string : MoveClassUI.getResPackageName(this.mainSourceClass), new MessageFormat(MoveClassUI.getString("LBL_MoveClassNamed")).format(new Object[]{this.mainSourceClass == null ? "" : this.mainSourceClass.getName()}), (FileObject)(this.targetFolder != null ? this.targetFolder : (this.javaObject != null ? this.javaObject.getPrimaryFile() : null)));
            this.panel.setCombosEnabled(!this.disable);
        }
        return this.panel;
    }

    private static String getResPackageName(JavaClass javaClass) {
        if (javaClass == null) {
            return "";
        }
        Resource resource = (Resource)javaClass.refImmediateComposite();
        String string = resource.getName();
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n).replace('/', '.');
    }

    private void findMainClass() {
        this.mainSourceClass = null;
        List list = this.resource.getClassifiers();
        int n = list.size();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            this.mainSourceClass = (JavaClass)list.get(0);
            return;
        }
        String string = this.resource.getName();
        int n2 = string.lastIndexOf(47);
        int n3 = string.indexOf(46);
        String string2 = null;
        if (n3 > -1) {
            string2 = string.substring(n2 + 1, n3);
        }
        Iterator iterator = list.iterator();
        for (int i = 0; i < n; ++i) {
            JavaClass javaClass = (JavaClass)iterator.next();
            if (string2 != null && string2.equals(javaClass.getName())) {
                this.mainSourceClass = javaClass;
                return;
            }
            if ((javaClass.getModifiers() & 1) <= 0) continue;
            this.mainSourceClass = javaClass;
        }
        if (this.mainSourceClass == null) {
            this.mainSourceClass = (JavaClass)list.get(0);
        }
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? MoveClassUI.getString("LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    private Problem setParameters(boolean bl) {
        if (this.panel == null) {
            return null;
        }
        this.targetPkgName = this.panel.getPackageName();
        this.refactoring.setTargetPackageName(this.targetPkgName);
        this.refactoring.setTargetClassPathRoot(this.panel.getRootFolder());
        if (bl) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        if (this.refactoring == null) {
            LinkedList<Resource> linkedList = new LinkedList<Resource>();
            linkedList.add(this.resource);
            this.refactoring = this.clazz != null ? new MoveClassRefactoring(this.clazz) : new MoveClassRefactoring(linkedList);
        }
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveClassUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }
}

