/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.MoveClassPanel;
import org.netbeans.modules.refactoring.ui.MoveClassUI;
import org.netbeans.modules.refactoring.ui.RefactoringUIBypass;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class MoveClassesUI
implements RefactoringUI,
RefactoringUIBypass {
    private List resources;
    private Set javaObjects;
    private MovePanel panel;
    private MoveClassRefactoring refactoring;
    private String targetPkgName = "";
    private boolean disable;
    private FileObject targetFolder;
    private PasteType pasteType;

    static final String getString(String string) {
        return NbBundle.getMessage((Class)MoveClassUI.class, (String)string);
    }

    public MoveClassesUI(Set set) {
        this(set, null, null);
    }

    public MoveClassesUI(Set set, FileObject fileObject, PasteType pasteType) {
        this.disable = fileObject != null;
        this.targetFolder = fileObject;
        this.javaObjects = set;
        this.pasteType = pasteType;
        if (!this.disable) {
            this.resources = new ArrayList(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.resources.add(JavaModel.getResource((FileObject)((JavaDataObject)iterator.next()).getPrimaryFile()));
            }
        }
    }

    public String getName() {
        return MoveClassesUI.getString("LBL_MoveClasses");
    }

    public String getDescription() {
        return this.getName();
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parametersPanel) {
        if (this.panel == null) {
            ClassPath classPath;
            String string = null;
            if (this.targetFolder != null && (classPath = ClassPath.getClassPath((FileObject)this.targetFolder, (String)"classpath/source")) != null) {
                string = classPath.getResourceName(this.targetFolder, '.', false);
            }
            this.panel = new MovePanel(parametersPanel, string != null ? string : MoveClassesUI.getDOPackageName((DataObject)((DataObject)this.javaObjects.iterator().next()).getFolder()), MoveClassesUI.getString("LBL_MoveClassesHeadline"));
        }
        return this.panel;
    }

    private static String getResPackageName(Resource resource) {
        String string = resource.getName();
        if (string.indexOf(47) == -1) {
            return "";
        }
        return string.substring(0, string.lastIndexOf(47)).replace('/', '.');
    }

    private static String getDOPackageName(DataObject dataObject) {
        return ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source").getResourceName(dataObject.getPrimaryFile(), '.', false);
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? MoveClassesUI.getString("LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    private Problem setParameters(boolean bl) {
        if (this.panel == null) {
            return null;
        }
        this.targetPkgName = this.panel.getPackageName();
        this.refactoring.setTargetClassPathRoot(this.panel.getRootFolder());
        this.refactoring.setTargetPackageName(this.targetPkgName);
        if (bl) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        if (this.refactoring == null) {
            this.refactoring = this.disable ? new MoveClassRefactoring(this.javaObjects, this.targetFolder) : new MoveClassRefactoring(this.resources);
        }
        return this.refactoring;
    }

    private final Vector getNodes() {
        Vector<Node> vector = new Vector<Node>(this.javaObjects.size());
        Iterator iterator = this.javaObjects.iterator();
        while (iterator.hasNext()) {
            vector.add(((DataObject)iterator.next()).getNodeDelegate());
        }
        return vector;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveClassesUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }

    class MovePanel
    extends MoveClassPanel {
        public MovePanel(ParametersPanel parametersPanel, String string, String string2) {
            super(parametersPanel, string, string2, MoveClassesUI.this.targetFolder != null ? MoveClassesUI.this.targetFolder : ((JavaDataObject)MoveClassesUI.this.javaObjects.iterator().next()).getPrimaryFile());
            this.setCombosEnabled(!MoveClassesUI.this.disable);
            JList jList = new JList(MoveClassesUI.this.getNodes());
            jList.setCellRenderer(new NodeRenderer());
            jList.setVisibleRowCount(5);
            JScrollPane jScrollPane = new JScrollPane(jList);
            this.bottomPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
            this.bottomPanel.setLayout(new BorderLayout());
            this.bottomPanel.add((Component)jScrollPane, "Center");
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$MoveClassesUI == null ? (class$org$netbeans$modules$refactoring$ui$MoveClassesUI = MoveClassesUI.class$("org.netbeans.modules.refactoring.ui.MoveClassesUI")) : class$org$netbeans$modules$refactoring$ui$MoveClassesUI), (String)"LBL_ListOfClasses"));
            this.bottomPanel.add((Component)jLabel, "North");
        }
    }
}

