/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Image;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class PackageDisplayUtils {
    private static final Image PACKAGE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/package.gif");
    private static final Image PACKAGE_EMPTY = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageEmpty.gif");
    private static final Image PACKAGE_PRIVATE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packagePrivate.gif");
    private static final Image PACKAGE_PUBLIC = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packagePublic.gif");

    private PackageDisplayUtils() {
    }

    public static String getDisplayLabel(FileObject fileObject, String string) {
        if (string.length() == 0) {
            return NbBundle.getMessage((Class)PackageDisplayUtils.class, (String)"LBL_DefaultPackage_PDU");
        }
        return string;
    }

    public static Image getIcon(FileObject fileObject, String string) {
        Boolean bl;
        if (PackageDisplayUtils.isEmpty(fileObject)) {
            return PACKAGE_EMPTY;
        }
        Boolean bl2 = bl = fileObject.isValid() ? AccessibilityQuery.isPubliclyAccessible((FileObject)fileObject) : null;
        if (bl != null) {
            if (bl.booleanValue()) {
                return PACKAGE_PUBLIC;
            }
            return PACKAGE_PRIVATE;
        }
        return PACKAGE;
    }

    private static boolean isEmpty(FileObject fileObject) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!fileObjectArray[i].isData()) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignificant(FileObject fileObject) throws IllegalArgumentException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return false;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        boolean bl = false;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
            if (fileObjectArray[i].isData()) {
                return true;
            }
            bl = true;
        }
        return !bl;
    }
}

