/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.ui.RenameAction;
import org.netbeans.spi.java.project.support.ui.PackageRenameHandler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class PackageRenameHandlerImpl
implements PackageRenameHandler {
    public void handleRename(Node node, String string) {
        DataFolder dataFolder = (DataFolder)node.getCookie(DataObject.class);
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (node.isLeaf()) {
            try {
                if (!CheckUtils.isValidPackageName(string)) {
                    String string2 = new MessageFormat(NbBundle.getMessage((Class)AbstractRefactoring.class, (String)"ERR_InvalidPackage")).format(new Object[]{string});
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 1));
                    return;
                }
                FileUtil.createFolder((FileObject)((JMManager)JMManager.getManager()).getMergedClassPath().findOwnerRoot(fileObject), (String)string.replace('.', '/'));
                while (dataFolder.getChildren().length == 0 && dataFolder.isDeleteAllowed()) {
                    DataFolder dataFolder2 = dataFolder.getFolder();
                    dataFolder.delete();
                    dataFolder = dataFolder2;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            return;
        }
        RenameAction renameAction = (RenameAction)RenameAction.findObject((Class)RenameAction.class, (boolean)true);
        renameAction.performAction(fileObject, string, true);
    }
}

