/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.refactoring.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PushDownPanel
extends CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_PullUp_Selected", "LBL_PullUp_Member", "LBL_PushDown_KeepAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, NamedElement.class, Boolean.class};
    private final PushDownRefactoring refactoring;
    private final TableModel tableModel;
    private Set selectedMembers;
    private JavaClass originalType;
    private Object[][] members = new Object[0][0];
    private JLabel chooseLabel;
    private JScrollPane membersScrollPane;
    private JTable membersTable;

    public PushDownPanel(PushDownRefactoring pushDownRefactoring, Set set) {
        this.refactoring = pushDownRefactoring;
        this.tableModel = new TableModel();
        this.selectedMembers = set;
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
    }

    public void initialize() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.refactoring.getSourceType().getFeatures());
        arrayList.addAll(this.refactoring.getSourceType().getInterfaceNames());
        Object[][] objectArray = new Object[arrayList.size()][3];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof JavaClass) && !(e instanceof Method) && !(e instanceof Field) && !(e instanceof MultipartId)) continue;
            objectArray[n][0] = this.selectedMembers.contains(e) ? Boolean.TRUE : Boolean.FALSE;
            objectArray[n][1] = e;
            objectArray[n][2] = e instanceof Method ? Boolean.FALSE : null;
            ++n;
        }
        this.members = new Object[n][3];
        if (n > 0) {
            System.arraycopy(objectArray, 0, this.members, 0, n);
        }
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new UIUtilities.JavaElementTableCellRenderer(){

            protected String extractText(Object object) {
                String string = super.extractText(object);
                if (object instanceof MultipartId) {
                    string = "implements " + string;
                }
                return string;
            }
        });
        this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Object object2 = jTable.getModel().getValueAt(n, 1);
                if (object2 instanceof Method && PushDownPanel.this.refactoring.getSourceType().isInterface() && !Modifier.isStatic(((Method)object2).getModifiers())) {
                    object = Boolean.TRUE;
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.membersScrollPane.setBackground(this.membersTable.getBackground());
        this.membersScrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
        UIUtilities.initColumnWidth(this.membersTable, 2, Boolean.TRUE, 4);
    }

    public PushDownRefactoring.MemberInfo[] getMembers() {
        ArrayList<PushDownRefactoring.MemberInfo> arrayList = new ArrayList<PushDownRefactoring.MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            Object object = this.members[i][1];
            PushDownRefactoring.MemberInfo memberInfo = object instanceof Field ? new PushDownRefactoring.MemberInfo((Field)object) : (object instanceof JavaClass ? new PushDownRefactoring.MemberInfo((JavaClass)object) : (object instanceof MultipartId ? new PushDownRefactoring.MemberInfo((MultipartId)object) : new PushDownRefactoring.MemberInfo((Method)object, (boolean)((Boolean)this.members[i][2]))));
            arrayList.add(memberInfo);
        }
        return arrayList.toArray(new PushDownRefactoring.MemberInfo[arrayList.size()]);
    }

    private void initComponents() {
        this.membersScrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.chooseLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.setName(NbBundle.getMessage((Class)PushDownPanel.class, (String)"LBL_PushDown_Header", (Object[])new Object[]{UIUtilities.getDisplayText((NamedElement)this.refactoring.getSourceType())}));
        this.membersScrollPane.setToolTipText("");
        this.membersTable.setModel(this.tableModel);
        this.membersScrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PushDownPanel.class, (String)"ACSD_MembersToPushDown"));
        this.membersTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PushDownPanel.class, (String)"ACSD_MembersToPushDownDescription"));
        this.add((Component)this.membersScrollPane, "Center");
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage((Class)PushDownPanel.class, (String)"LBL_PushDownLabel"));
        this.add((Component)this.chooseLabel, "North");
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return UIUtilities.getColumnName(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$PushDownPanel == null ? (class$org$netbeans$modules$refactoring$ui$PushDownPanel = PushDownPanel.class$("org.netbeans.modules.refactoring.ui.PushDownPanel")) : class$org$netbeans$modules$refactoring$ui$PushDownPanel), (String)COLUMN_NAMES[n]));
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASSES[n];
        }

        public int getRowCount() {
            return PushDownPanel.this.members.length;
        }

        public Object getValueAt(int n, int n2) {
            return PushDownPanel.this.members[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            ((PushDownPanel)PushDownPanel.this).members[n][n2] = object;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                if (PushDownPanel.this.members[n][2] == null) {
                    return false;
                }
                Object object = PushDownPanel.this.members[n][1];
                return !PushDownPanel.this.refactoring.getSourceType().isInterface() && !Modifier.isStatic(((Method)object).getModifiers());
            }
            return n2 == 0;
        }
    }
}

