/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.java.ui.nodes.elements.IconResolver;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.InvalidationListener;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.CheckNode;
import org.netbeans.modules.refactoring.ui.CheckNodeListener;
import org.netbeans.modules.refactoring.ui.CheckRenderer;
import org.netbeans.modules.refactoring.ui.RefactoringPanel;
import org.netbeans.modules.refactoring.ui.RefactoringPanelContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class RefactoringPanel
extends JPanel
implements InvalidationListener {
    private transient JTree tree = null;
    private transient JButton refreshButton = null;
    private transient JToggleButton expandButton = null;
    private JToolBar toolBar = null;
    private transient JButton refactorButton = null;
    private transient JButton cancelButton = null;
    private transient ButtonL buttonListener = null;
    private transient JButton rerunButton = null;
    private final RefactoringUI ui;
    private final boolean isQuery;
    private transient boolean isVisible = false;
    private transient RefactoringSession session = null;
    private transient ParametersPanel parametersPanel = null;
    private transient JScrollPane scrollPane = null;
    private transient JPanel southPanel;
    private Action callback = null;
    private static final int MAX_ROWS = 50;
    private transient JToggleButton logicalViewButton = null;
    private transient JToggleButton physicalViewButton = null;
    private transient ProgressListener progressListener;
    private transient JButton prevMatch = null;
    private transient JButton nextMatch = null;
    private WeakReference refCallerTC;
    static Image PACKAGE_BADGE;
    private static final byte LOGICAL = 0;
    private static final byte PHYSICAL = 1;
    private byte currentView = 0;
    RequestProcessor rp = new RequestProcessor();
    static final /* synthetic */ boolean $assertionsDisabled;

    public RefactoringPanel(RefactoringUI refactoringUI) {
        this(refactoringUI, null);
    }

    public RefactoringPanel(RefactoringUI refactoringUI, TopComponent topComponent) {
        if (topComponent != null) {
            this.refCallerTC = new WeakReference<TopComponent>(topComponent);
        }
        this.ui = refactoringUI;
        this.isQuery = refactoringUI.isQuery();
        this.initialize();
        this.refresh(true);
    }

    public RefactoringPanel(RefactoringUI refactoringUI, RefactoringSession refactoringSession, Action action) {
        this.session = refactoringSession;
        this.ui = refactoringUI;
        this.isQuery = refactoringUI.isQuery();
        this.callback = action;
        this.initialize();
        this.refresh(false);
    }

    public static void checkEventThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("This must happen in event thread!"));
        }
    }

    private void initialize() {
        JToolBar jToolBar;
        GridBagConstraints gridBagConstraints;
        RefactoringPanel.checkEventThread();
        this.setFocusCycleRoot(true);
        this.setLayout(new BorderLayout());
        JButton[] jButtonArray = this.getButtons();
        this.southPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < jButtonArray.length; ++i) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 0);
            this.southPanel.add((Component)jButtonArray[i], gridBagConstraints);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.southPanel.add((Component)jPanel, gridBagConstraints);
        if (!this.isQuery || this.callback != null) {
            this.add((Component)this.southPanel, "South");
        }
        if ((jToolBar = this.getToolBar()) != null) {
            this.add((Component)jToolBar, "West");
        }
        this.validate();
    }

    private JToolBar getToolBar() {
        RefactoringPanel.checkEventThread();
        this.refreshButton = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/refresh.png")));
        Dimension dimension = new Dimension(24, 24);
        this.refreshButton.setMaximumSize(dimension);
        this.refreshButton.setMinimumSize(dimension);
        this.refreshButton.setPreferredSize(dimension);
        this.refreshButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_refresh"));
        this.refreshButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_refresh").charAt(0));
        this.refreshButton.addActionListener(this.getButtonListener());
        this.expandButton = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/expandTree.png")));
        this.expandButton.setSelectedIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/colapseTree.png")));
        this.expandButton.setMaximumSize(dimension);
        this.expandButton.setMinimumSize(dimension);
        this.expandButton.setPreferredSize(dimension);
        this.expandButton.setSelected(true);
        this.expandButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_expandAll"));
        this.expandButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_expandAll").charAt(0));
        this.expandButton.addActionListener(this.getButtonListener());
        this.toolBar = new JToolBar(1);
        this.toolBar.setFloatable(false);
        this.logicalViewButton = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/logical_view.png")));
        this.logicalViewButton.setMaximumSize(dimension);
        this.logicalViewButton.setMinimumSize(dimension);
        this.logicalViewButton.setPreferredSize(dimension);
        this.logicalViewButton.setSelected(true);
        this.logicalViewButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_logicalView"));
        this.logicalViewButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_logicalView").charAt(0));
        this.logicalViewButton.addActionListener(this.getButtonListener());
        this.physicalViewButton = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/file_view.png")));
        this.physicalViewButton.setMaximumSize(dimension);
        this.physicalViewButton.setMinimumSize(dimension);
        this.physicalViewButton.setPreferredSize(dimension);
        this.physicalViewButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_physicalView"));
        this.physicalViewButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_physicalView").charAt(0));
        this.physicalViewButton.addActionListener(this.getButtonListener());
        this.nextMatch = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/nextmatch.png")));
        this.nextMatch.setMaximumSize(dimension);
        this.nextMatch.setMinimumSize(dimension);
        this.nextMatch.setPreferredSize(dimension);
        this.nextMatch.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_nextMatch"));
        this.nextMatch.addActionListener(this.getButtonListener());
        this.prevMatch = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/prevmatch.png")));
        this.prevMatch.setMaximumSize(dimension);
        this.prevMatch.setMinimumSize(dimension);
        this.prevMatch.setPreferredSize(dimension);
        this.prevMatch.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_prevMatch"));
        this.prevMatch.addActionListener(this.getButtonListener());
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.expandButton);
        this.toolBar.add(this.logicalViewButton);
        this.toolBar.add(this.physicalViewButton);
        this.toolBar.add(this.prevMatch);
        this.toolBar.add(this.nextMatch);
        return this.toolBar;
    }

    private JButton[] getButtons() {
        RefactoringPanel.checkEventThread();
        if (this.isQuery) {
            this.refactorButton = null;
            if (this.callback == null) {
                return new JButton[0];
            }
            this.rerunButton = new JButton((String)this.callback.getValue("Name"));
            this.rerunButton.addActionListener(this.getButtonListener());
            return new JButton[]{this.rerunButton};
        }
        this.refactorButton = new JButton(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"LBL_DoRefactor"));
        this.refactorButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_DoRefactor"));
        this.refactorButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_DoRefactor").charAt(0));
        this.refactorButton.addActionListener(this.getButtonListener());
        this.cancelButton = new JButton(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"LBL_CancelRefactor"));
        this.cancelButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_CancelRefactor").charAt(0));
        this.cancelButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_CancelRefactor"));
        this.cancelButton.addActionListener(this.getButtonListener());
        return new JButton[]{this.refactorButton, this.cancelButton};
    }

    void switchToLogicalView() {
        this.logicalViewButton.setSelected(true);
        if (this.currentView == 0) {
            return;
        }
        this.currentView = 0;
        this.physicalViewButton.setSelected(false);
        this.refresh(false);
    }

    void switchToPhysicalView() {
        this.physicalViewButton.setSelected(true);
        if (this.currentView == 1) {
            return;
        }
        this.currentView = 1;
        this.logicalViewButton.setSelected(false);
        this.refresh(false);
    }

    private CheckNode createNode(Object object, HashMap hashMap, CheckNode checkNode) {
        Object object2;
        boolean bl = this.currentView == 0;
        CheckNode checkNode2 = null;
        checkNode2 = object instanceof SourceGroup ? (CheckNode)hashMap.get(((SourceGroup)object).getRootFolder()) : (CheckNode)hashMap.get(object);
        if (checkNode2 != null) {
            return checkNode2;
        }
        Object object3 = null;
        String string = null;
        String string2 = null;
        Icon icon = null;
        boolean bl2 = false;
        if (object instanceof Project) {
            object2 = ProjectUtils.getInformation((Project)((Project)object));
            string2 = object2.getDisplayName();
            icon = object2.getIcon();
        } else if (object instanceof SourceGroup) {
            object2 = (SourceGroup)object;
            icon = object2.getIcon(false);
            if (icon == null) {
                try {
                    Image image = DataObject.find((FileObject)object2.getRootFolder()).getNodeDelegate().getIcon(1);
                    image = Utilities.mergeImages((Image)image, (Image)PACKAGE_BADGE, (int)7, (int)7);
                    icon = new ImageIcon(image);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            string2 = object2.getDisplayName();
            object3 = FileOwnerQuery.getOwner((FileObject)object2.getRootFolder());
        } else if (object instanceof RefactoringElement) {
            String string3;
            int n;
            object2 = (RefactoringElement)object;
            string2 = ((RefactoringElement)object2).getDisplayText();
            if (!(this.isQuery || (n = ((RefactoringElement)object2).getStatus()) != 2 && n != 3)) {
                string3 = n == 2 ? "LBL_InGuardedBlock" : "LBL_InReadOnlyFile";
                string2 = string2 + " [<font color=#CC0000>" + NbBundle.getMessage((Class)RefactoringPanel.class, (String)string3) + "</font>]";
                bl2 = true;
            }
            string2 = RefactoringPanel.normalize(string2);
            Element element = ((RefactoringElement)object2).getJavaElement();
            if (bl) {
                string3 = null;
                if (element == null) {
                    object3 = ((RefactoringElement)object2).getParentFile();
                } else {
                    object3 = element;
                    while ((object3 = ((RefObject)object3).refImmediateComposite()) != null && !(object3 instanceof Feature) && !(object3 instanceof Resource)) {
                    }
                    if (element instanceof Feature) {
                        string = IconResolver.getIconBase((Feature)((Feature)element));
                    }
                    if ((string3 = this.getPrefix(element)) == null) {
                        List list;
                        string = null;
                        object3 = element;
                        if (element instanceof Resource && !(list = ((Resource)element).getClassifiers()).isEmpty()) {
                            object3 = list.get(0);
                        }
                    } else {
                        string2 = string3 + string2;
                    }
                }
            } else {
                object3 = element != null ? element.getResource() : ((RefactoringElement)object2).getParentFile();
                string = null;
            }
        } else if (object instanceof Feature) {
            if (bl) {
                object3 = object;
                while ((object3 = ((RefObject)object3).refImmediateComposite()) != null && !(object3 instanceof Feature) && !(object3 instanceof Resource)) {
                }
                if (object3 instanceof Resource) {
                    object2 = JavaModel.getFileObject((Resource)((Resource)object3));
                    object3 = object2.getParent();
                }
            } else {
                ((NamedElement)object).getResource();
            }
            if (object instanceof JavaClass) {
                object2 = (JavaClass)object;
                string2 = object2.getSimpleName();
            } else {
                string2 = ((NamedElement)object).getName();
            }
            string = IconResolver.getIconBase((Feature)((Feature)object));
            if (object instanceof Constructor) {
                string2 = ((JavaClass)((Constructor)object).getDeclaringClass()).getSimpleName();
            } else if (object instanceof Initializer) {
                string2 = RefactoringPanel.getString("LBL_Initializer");
            }
        } else if (object instanceof JavaPackage) {
            string = "org/netbeans/modules/refactoring/resources/package";
            string2 = ((JavaPackage)object).getName();
            if ("".equals(string2)) {
                string2 = NbBundle.getMessage((Class)RefactoringPanel.class, (String)"LBL_DefaultPackage");
            }
            object3 = null;
        } else if (object instanceof ClassDefinition) {
            string2 = RefactoringPanel.getString("LBL_AnonymousClass");
            object3 = bl ? JavaModelUtil.getDeclaringFeature((Element)((ClassDefinition)object)) : ((Element)object).getResource();
        } else if (object instanceof Resource) {
            string = "org/netbeans/modules/java/resources/class";
            object2 = ((Resource)object).getName();
            string2 = ((String)object2).substring(((String)object2).lastIndexOf(47) + 1);
            FileObject fileObject = JavaModel.getFileObject((Resource)((Resource)object));
            object3 = bl ? fileObject.getParent() : FileOwnerQuery.getOwner((FileObject)fileObject);
        } else if (object instanceof FileObject) {
            DataObject dataObject;
            object2 = (FileObject)object;
            try {
                dataObject = DataObject.find((FileObject)((FileObject)object));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw (RuntimeException)new RuntimeException().initCause(dataObjectNotFoundException);
            }
            if (!$assertionsDisabled && dataObject == null) {
                throw new AssertionError();
            }
            Node node = dataObject.getNodeDelegate();
            if (!$assertionsDisabled && node == null) {
                throw new AssertionError();
            }
            if (object2.isFolder()) {
                string = "org/netbeans/modules/refactoring/resources/package";
                object3 = this.getSourceGroup((FileObject)object2);
                string2 = ClassPath.getClassPath((FileObject)object2, (String)"classpath/source").getResourceName((FileObject)object2).replace('/', '.');
                if ("".equals(string2)) {
                    string2 = NbBundle.getMessage((Class)RefactoringPanel.class, (String)"LBL_DefaultPackage");
                }
            } else {
                icon = new ImageIcon(node.getIcon(1));
                if (bl) {
                    if (this.getSourceGroup((FileObject)object2) == null) {
                        object3 = FileOwnerQuery.getOwner((FileObject)object2);
                        string2 = object3 != null ? FileUtil.getRelativePath((FileObject)((Project)object3).getProjectDirectory(), (FileObject)object2) : ClassPath.getClassPath((FileObject)object2, (String)"classpath/source").getResourceName((FileObject)object2);
                    } else {
                        object3 = object2.getParent();
                        string2 = node.getDisplayName();
                    }
                } else {
                    object3 = FileOwnerQuery.getOwner((FileObject)object2);
                    string2 = node.getDisplayName();
                }
            }
        } else if (object instanceof Variable) {
            string2 = ((NamedElement)object).getName();
            string = IconResolver.getIconBaseForVariable((Variable)((Variable)object));
            object3 = bl ? JavaModelUtil.getDeclaringFeature((Element)((Variable)object)) : ((Element)object).getResource();
        }
        checkNode2 = new CheckNode(object, string2, (Icon)(string == null ? (icon == null ? null : icon) : new ImageIcon(Utilities.loadImage((String)(string + ".gif")))));
        if (bl2) {
            checkNode2.setDisabled();
        }
        object2 = object3 == null ? checkNode : this.createNode(object3, hashMap, checkNode);
        ((DefaultMutableTreeNode)object2).add(checkNode2);
        if (object instanceof SourceGroup) {
            hashMap.put(((SourceGroup)object).getRootFolder(), checkNode2);
        } else {
            hashMap.put(object, checkNode2);
        }
        return checkNode2;
    }

    private String getPrefix(Element element) {
        if (element instanceof Constructor) {
            return ((JavaClass)((Constructor)element).getDeclaringClass()).getSimpleName() + "() ... ";
        }
        if (element instanceof Method) {
            return ((NamedElement)element).getName() + "() ... ";
        }
        if (element instanceof Initializer) {
            return RefactoringPanel.getString("LBL_Initializer") + " ... ";
        }
        if (element instanceof Field) {
            return ((NamedElement)element).getName() + " ... ";
        }
        return null;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage((Class)RefactoringPanel.class, (String)string);
    }

    private SourceGroup getSourceGroup(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!sourceGroupArray[i].getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroupArray[i];
        }
        return null;
    }

    protected void updateTitle() {
    }

    private void refactor() {
        RefactoringPanel.checkEventThread();
        RefactoringPanel.disableComponents(this);
        this.progressListener = new ProgressL();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RefactoringPanel.this.session.addProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.session.doRefactoring(true);
                    Object var2_1 = null;
                    RefactoringPanel.this.session.removeProgressListener(RefactoringPanel.this.progressListener);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    RefactoringPanel.this.session.removeProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.progressListener = null;
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            1.access$300(this.this$1).close();
                        }
                    });
                    throw throwable;
                }
                RefactoringPanel.this.progressListener = null;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }

            static /* synthetic */ RefactoringPanel access$300(1 var0) {
                return var0.RefactoringPanel.this;
            }
        });
    }

    private int cancel() {
        RefactoringPanel.checkEventThread();
        this.close();
        return 0;
    }

    void close() {
        if (this.isQuery) {
            RefactoringPanelContainer.getUsagesComponent().removePanel(this);
        } else {
            RefactoringPanelContainer.getRefactoringComponent().removePanel(this);
        }
        this.closeNotify();
    }

    private ButtonL getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new ButtonL();
        }
        return this.buttonListener;
    }

    public void expandAll() {
        RefactoringPanel.checkEventThread();
        final Cursor cursor = this.getCursor();
        this.expandButton.setEnabled(false);
        this.scrollPane.getViewport().remove(this.tree);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.rp.post(new Runnable(){

            public void run() {
                for (int i = 0; i < RefactoringPanel.this.tree.getRowCount(); ++i) {
                    RefactoringPanel.this.tree.expandRow(i);
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RefactoringPanel.access$700(3.access$600(this.this$1)).setViewportView(RefactoringPanel.access$500(3.access$600(this.this$1)));
                        3.access$600(this.this$1).setCursor(3.access$800(this.this$1));
                        RefactoringPanel.access$900(3.access$600(this.this$1)).setEnabled(true);
                        RefactoringPanel.access$900(3.access$600(this.this$1)).setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"HINT_collapseAll"));
                        3.access$600(this.this$1).requestFocus();
                    }
                });
            }

            static /* synthetic */ RefactoringPanel access$600(3 var0) {
                return var0.RefactoringPanel.this;
            }

            static /* synthetic */ Cursor access$800(3 var0) {
                return var0.cursor;
            }
        });
    }

    public void collapseAll() {
        RefactoringPanel.checkEventThread();
        this.expandButton.setEnabled(false);
        final Cursor cursor = this.getCursor();
        this.scrollPane.getViewport().remove(this.tree);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.rp.post(new Runnable(){

            public void run() {
                for (int i = RefactoringPanel.this.tree.getRowCount() - 1; i > 0; --i) {
                    RefactoringPanel.this.tree.collapseRow(i);
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RefactoringPanel.access$700(5.access$1000(this.this$1)).setViewportView(RefactoringPanel.access$500(5.access$1000(this.this$1)));
                        5.access$1000(this.this$1).setCursor(5.access$1100(this.this$1));
                        RefactoringPanel.access$900(5.access$1000(this.this$1)).setEnabled(true);
                        RefactoringPanel.access$900(5.access$1000(this.this$1)).setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"HINT_expandAll"));
                        5.access$1000(this.this$1).requestFocus();
                    }
                });
            }

            static /* synthetic */ RefactoringPanel access$1000(5 var0) {
                return var0.RefactoringPanel.this;
            }

            static /* synthetic */ Cursor access$1100(5 var0) {
                return var0.cursor;
            }
        });
    }

    public void invalidateObject() {
        if (this.isQuery) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                RefactoringPanel.this.setRefactoringEnabled(false, false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void refresh(boolean bl) {
        Object object;
        RefactoringPanel.checkEventThread();
        if (!this.isQuery) {
            JavaMetamodel.getUndoManager().saveAll();
        }
        if (bl) {
            if (this.parametersPanel == null) {
                this.parametersPanel = new ParametersPanel(this.ui);
            }
            if ((object = this.parametersPanel.showDialog()) == null) {
                return;
            }
            this.session = object;
        }
        object = this.ui.getDescription();
        this.setToolTipText("<html>" + (String)object + "</html>");
        final Collection collection = this.session.getRefactoringElements();
        this.setName(this.ui.getName());
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)RefactoringPanel.class, (String)(this.isQuery ? "LBL_PreparingUsagesTree" : "LBL_PreparingRefactoringTree")));
        RequestProcessor.getDefault().post(new Runnable((String)object, progressHandle, bl){
            private final /* synthetic */ String val$description;
            private final /* synthetic */ ProgressHandle val$progressHandle;
            private final /* synthetic */ boolean val$showParametersPanel;
            {
                this.val$description = string;
                this.val$progressHandle = progressHandle;
                this.val$showParametersPanel = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                HashSet<CloneableEditorSupport> hashSet = new HashSet<CloneableEditorSupport>();
                int n = 0;
                if (!RefactoringPanel.this.isQuery) {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        object = (RefactoringElement)iterator.next();
                        if (((RefactoringElement)object).getStatus() != 2 && ((RefactoringElement)object).getStatus() != 3) continue;
                        ++n;
                    }
                }
                int n2 = collection.size();
                object = new StringBuffer();
                ((StringBuffer)object).append(" [" + n2);
                ((StringBuffer)object).append(' ');
                ((StringBuffer)object).append(n2 == 1 ? NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_Occurence") : NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_Occurences"));
                if (n > 0) {
                    ((StringBuffer)object).append(',');
                    ((StringBuffer)object).append(' ');
                    ((StringBuffer)object).append("<font color=#CC0000>" + n);
                    ((StringBuffer)object).append(' ');
                    ((StringBuffer)object).append(n == 1 ? NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_Error") : NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_Errors"));
                    ((StringBuffer)object).append("</font>");
                }
                ((StringBuffer)object).append(']');
                CheckNode checkNode = new CheckNode(null, this.val$description + ((StringBuffer)object).toString(), new ImageIcon(Utilities.loadImage((String)("org/netbeans/modules/refactoring/resources/" + (RefactoringPanel.this.isQuery ? "findusages.png" : "refactoring.gif")))));
                HashMap hashMap = new HashMap();
                Cursor cursor = RefactoringPanel.this.getCursor();
                RefactoringPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                this.val$progressHandle.start(collection.size() / 10);
                int n3 = 0;
                try {
                    JavaModel.getJavaRepository().beginTrans(false);
                    try {
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            RefactoringElement refactoringElement = (RefactoringElement)iterator.next();
                            RefactoringPanel.this.createNode(refactoringElement, hashMap, checkNode);
                            PositionBounds positionBounds = refactoringElement.getPosition();
                            if (positionBounds != null) {
                                CloneableEditorSupport cloneableEditorSupport = positionBounds.getBegin().getCloneableEditorSupport();
                                hashSet.add(cloneableEditorSupport);
                            }
                            if (n3 % 10 == 0) {
                                this.val$progressHandle.progress(n3 / 10);
                            }
                            ++n3;
                        }
                    }
                    finally {
                        JavaModel.getJavaRepository().endTrans();
                    }
                    JavaMetamodel.getUndoManager().watch(hashSet, (InvalidationListener)RefactoringPanel.this);
                }
                finally {
                    this.val$progressHandle.finish();
                    RefactoringPanel.this.setCursor(cursor);
                }
                SwingUtilities.invokeLater(new Runnable(this, checkNode){
                    private final /* synthetic */ CheckNode val$root;
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$root = checkNode;
                    }

                    public void run() {
                        if (RefactoringPanel.access$500(8.access$1400(this.this$1)) == null) {
                            RefactoringPanel.access$502(8.access$1400(this.this$1), new JTree(this, this.val$root){
                                private final /* synthetic */ 9 this$2;
                                {
                                    this.this$2 = var1_1;
                                    super(treeNode);
                                }

                                public TreePath getNextMatch(String string, int n, Position.Bias bias) {
                                    try {
                                        return super.getNextMatch(string, n, bias);
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        return null;
                                    }
                                }
                            });
                            ToolTipManager.sharedInstance().registerComponent(RefactoringPanel.access$500(8.access$1400(this.this$1)));
                            RefactoringPanel.access$500(8.access$1400(this.this$1)).setCellRenderer(new CheckRenderer(RefactoringPanel.access$1200(8.access$1400(this.this$1))));
                            String string = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"ACSD_usagesTree");
                            RefactoringPanel.access$500(8.access$1400(this.this$1)).getAccessibleContext().setAccessibleDescription(string);
                            RefactoringPanel.access$500(8.access$1400(this.this$1)).getAccessibleContext().setAccessibleName(string);
                            CheckNodeListener checkNodeListener = new CheckNodeListener(RefactoringPanel.access$1200(8.access$1400(this.this$1)));
                            RefactoringPanel.access$500(8.access$1400(this.this$1)).addMouseListener(checkNodeListener);
                            RefactoringPanel.access$500(8.access$1400(this.this$1)).addKeyListener(checkNodeListener);
                            RefactoringPanel.access$500(8.access$1400(this.this$1)).setToggleClickCount(0);
                            RefactoringPanel.access$702(8.access$1400(this.this$1), new JScrollPane(RefactoringPanel.access$500(8.access$1400(this.this$1))));
                            8.access$1400(this.this$1).add((Component)RefactoringPanel.access$700(8.access$1400(this.this$1)), "Center");
                            8.access$1400(this.this$1).validate();
                        } else {
                            RefactoringPanel.access$500(8.access$1400(this.this$1)).setModel(new DefaultTreeModel(this.val$root));
                        }
                        RefactoringPanel.access$500(8.access$1400(this.this$1)).setRowHeight((int)((CheckRenderer)RefactoringPanel.access$500(8.access$1400(this.this$1)).getCellRenderer()).getPreferredSize().getHeight());
                        if (8.access$1500(this.this$1)) {
                            if (8.access$1600(this.this$1).size() < 50) {
                                8.access$1400(this.this$1).expandAll();
                            } else {
                                RefactoringPanel.access$900(8.access$1400(this.this$1)).setSelected(false);
                            }
                        } else if (RefactoringPanel.access$900(8.access$1400(this.this$1)).isSelected()) {
                            8.access$1400(this.this$1).expandAll();
                        } else {
                            RefactoringPanel.access$900(8.access$1400(this.this$1)).setSelected(false);
                        }
                        RefactoringPanel.access$500(8.access$1400(this.this$1)).setSelectionRow(0);
                        8.access$1400(this.this$1).requestFocus();
                        8.access$1400(this.this$1).setRefactoringEnabled(true, true);
                    }
                });
            }

            static /* synthetic */ RefactoringPanel access$1400(8 var0) {
                return var0.RefactoringPanel.this;
            }

            static /* synthetic */ boolean access$1500(8 var0) {
                return var0.val$showParametersPanel;
            }

            static /* synthetic */ Collection access$1600(8 var0) {
                return var0.collection;
            }
        });
        if (!this.isVisible) {
            RefactoringPanelContainer refactoringPanelContainer = this.isQuery ? RefactoringPanelContainer.getUsagesComponent() : RefactoringPanelContainer.getRefactoringComponent();
            refactoringPanelContainer.open();
            refactoringPanelContainer.requestActive();
            refactoringPanelContainer.addPanel(this);
            this.isVisible = true;
        }
        this.setRefactoringEnabled(false, true);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.refactorButton != null) {
            this.refactorButton.requestFocus();
        } else if (this.tree != null) {
            this.tree.requestFocus();
        }
    }

    void setRefactoringEnabled(boolean bl, boolean bl2) {
        RefactoringPanel.checkEventThread();
        if (this.tree != null) {
            if (!bl) {
                CheckNode checkNode = (CheckNode)this.tree.getModel().getRoot();
                if (!bl2) {
                    checkNode.setNeedsRefresh();
                } else {
                    checkNode.setDisabled();
                }
                this.tree.setModel(new DefaultTreeModel(checkNode, false));
            }
            this.tree.setEnabled(bl);
            if (this.refactorButton != null) {
                this.refactorButton.setEnabled(bl);
            }
        }
    }

    private static void disableComponents(Container container) {
        RefactoringPanel.checkEventThread();
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i].isEnabled()) {
                componentArray[i].setEnabled(false);
            }
            if (!(componentArray[i] instanceof Container)) continue;
            RefactoringPanel.disableComponents((Container)componentArray[i]);
        }
    }

    void selectNextUsage() {
        this.selectNextPrev(true);
    }

    void selectPrevUsage() {
        this.selectNextPrev(false);
    }

    private void selectNextPrev(boolean bl) {
        CheckNode checkNode;
        int n = this.getSelectedRow();
        int n2 = this.tree.getRowCount();
        do {
            TreePath treePath;
            if (bl) {
                if (++n >= n2) {
                    n = 0;
                }
            } else if (--n < 0) {
                n = n2 - 1;
            }
            if ((checkNode = (CheckNode)(treePath = this.tree.getPathForRow(n)).getLastPathComponent()).isLeaf()) continue;
            this.tree.expandRow(n);
            n2 = this.tree.getRowCount();
        } while (!checkNode.isLeaf());
        this.tree.setSelectionRow(n);
        CheckNodeListener.findInSource(checkNode);
    }

    private int getSelectedRow() {
        int[] nArray = this.tree.getSelectionRows();
        if (nArray == null || nArray.length == 0) {
            return 0;
        }
        return nArray[0];
    }

    private static String normalize(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        boolean bl = false;
        int n2 = 0;
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(cArray[i])) {
                if (bl) continue;
                cArray2[n2++] = 32;
                bl = true;
                continue;
            }
            cArray2[n2++] = cArray[i];
            bl = false;
        }
        return new String(cArray2, 0, n2);
    }

    protected void closeNotify() {
        TopComponent topComponent;
        UndoWatcher.stopWatching(this);
        if (this.tree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.tree);
        }
        if (this.refCallerTC != null && (topComponent = (TopComponent)this.refCallerTC.get()) != null && topComponent.isShowing()) {
            topComponent.requestActive();
        }
    }

    static /* synthetic */ JScrollPane access$700(RefactoringPanel refactoringPanel) {
        return refactoringPanel.scrollPane;
    }

    static /* synthetic */ JTree access$502(RefactoringPanel refactoringPanel, JTree jTree) {
        refactoringPanel.tree = jTree;
        return refactoringPanel.tree;
    }

    static /* synthetic */ JScrollPane access$702(RefactoringPanel refactoringPanel, JScrollPane jScrollPane) {
        refactoringPanel.scrollPane = jScrollPane;
        return refactoringPanel.scrollPane;
    }

    static {
        $assertionsDisabled = !RefactoringPanel.class.desiredAssertionStatus();
        PACKAGE_BADGE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageBadge.gif");
    }

    private static class ProgressL
    implements ProgressListener {
        private ProgressHandle handle;
        private Dialog d;
        private int counter;

        private ProgressL() {
        }

        public void start(ProgressEvent progressEvent) {
            SwingUtilities.invokeLater(new Runnable(this, progressEvent){
                private final /* synthetic */ ProgressEvent val$event;
                private final /* synthetic */ ProgressL this$0;
                {
                    this.this$0 = progressL;
                    this.val$event = progressEvent;
                }

                public void run() {
                    ProgressL.access$2902(this.this$0, 0);
                    String string = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_RefactorProgressLabel");
                    ProgressL.access$3002(this.this$0, ProgressHandleFactory.createHandle((String)string));
                    JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)ProgressL.access$3000(this.this$0));
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BorderLayout());
                    jPanel.setBorder(new EmptyBorder(12, 12, 11, 11));
                    JLabel jLabel = new JLabel(string);
                    jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
                    jPanel.add((Component)jLabel, "North");
                    jPanel.add((Component)jComponent, "Center");
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_RefactoringInProgress"), true, new Object[0], null, 0, null, null);
                    dialogDescriptor.setLeaf(true);
                    ProgressL.access$3102(this.this$0, DialogDisplayer.getDefault().createDialog(dialogDescriptor));
                    ((JDialog)ProgressL.access$3100(this.this$0)).setDefaultCloseOperation(0);
                    ProgressL.access$3000(this.this$0).start(this.val$event.getCount());
                    ProgressL.access$3100(this.this$0).show();
                }
            });
        }

        public void step(ProgressEvent progressEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ProgressL this$0;
                {
                    this.this$0 = progressL;
                }

                public void run() {
                    ProgressL.access$3000(this.this$0).progress(ProgressL.access$2904(this.this$0));
                }
            });
        }

        public void stop(ProgressEvent progressEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ProgressL this$0;
                {
                    this.this$0 = progressL;
                }

                public void run() {
                    ProgressL.access$3000(this.this$0).finish();
                    ProgressL.access$3100(this.this$0).hide();
                }
            });
        }

        static /* synthetic */ int access$2902(ProgressL progressL, int n) {
            progressL.counter = n;
            return progressL.counter;
        }

        static /* synthetic */ ProgressHandle access$3002(ProgressL progressL, ProgressHandle progressHandle) {
            progressL.handle = progressHandle;
            return progressL.handle;
        }

        static /* synthetic */ ProgressHandle access$3000(ProgressL progressL) {
            return progressL.handle;
        }

        static /* synthetic */ Dialog access$3102(ProgressL progressL, Dialog dialog) {
            progressL.d = dialog;
            return progressL.d;
        }

        static /* synthetic */ Dialog access$3100(ProgressL progressL) {
            return progressL.d;
        }

        static /* synthetic */ int access$2904(ProgressL progressL) {
            return ++progressL.counter;
        }
    }

    private class ButtonL
    implements ActionListener {
        private ButtonL() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == RefactoringPanel.this.cancelButton) {
                RefactoringPanel.this.cancel();
            } else if (object == RefactoringPanel.this.refactorButton) {
                RefactoringPanel.this.refactor();
            } else if (object == RefactoringPanel.this.rerunButton) {
                RefactoringPanel.this.close();
                RefactoringPanel.this.callback.actionPerformed(actionEvent);
            } else if (object == RefactoringPanel.this.expandButton && RefactoringPanel.this.tree != null) {
                if (RefactoringPanel.this.expandButton.isSelected()) {
                    RefactoringPanel.this.expandAll();
                } else {
                    RefactoringPanel.this.collapseAll();
                }
            } else if (object == RefactoringPanel.this.refreshButton) {
                RefactoringPanel.this.refresh(true);
            } else if (object == RefactoringPanel.this.physicalViewButton) {
                RefactoringPanel.this.switchToPhysicalView();
            } else if (object == RefactoringPanel.this.logicalViewButton) {
                RefactoringPanel.this.switchToLogicalView();
            } else if (object == RefactoringPanel.this.nextMatch) {
                RefactoringPanel.this.selectNextUsage();
            } else if (object == RefactoringPanel.this.prevMatch) {
                RefactoringPanel.this.selectPrevUsage();
            }
        }
    }
}

