/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.RefactoringUIBypass;
import org.netbeans.modules.refactoring.ui.RenameAction;
import org.netbeans.modules.refactoring.ui.RenamePanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private final String oldName;
    private final String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private RefObject jmiObject;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;

    RenameRefactoringUI(RefObject refObject, FileObject fileObject, boolean bl) {
        this.jmiObject = refObject;
        this.pkgRename = bl;
        if (refObject == null || refObject instanceof JavaPackage) {
            Node[] nodeArray;
            if (fileObject == null && (fileObject = JavaMetamodel.getManager().getClassPath().findResource(((JavaPackage)refObject).getName().replace('.', '/'))) == null) {
                nodeArray = TopComponent.getRegistry().getActivatedNodes();
                DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
                fileObject = dataObject.getFolder().getPrimaryFile();
            }
            this.refactoring = this.createMoveClassRefactoring(fileObject, bl);
            Node[] nodeArray2 = nodeArray = refObject != null ? ((JavaPackage)refObject).getName() : null;
            this.oldName = !bl ? fileObject.getName() : (nodeArray != null ? ("".equals(nodeArray) ? NbBundle.getBundle((String)"org.netbeans.modules.java.project.Bundle").getString("LBL_DefaultPackage") : nodeArray) : ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject).replace('/', '.'));
        } else if (refObject instanceof JavaClass) {
            this.refactoring = new RenameRefactoring(refObject);
            RefFeatured refFeatured = refObject.refImmediateComposite();
            if (refFeatured instanceof Resource) {
                FileObject fileObject2 = JavaModel.getFileObject((Resource)((Resource)refFeatured));
                String string = fileObject2.getName();
                Iterator iterator = ((Resource)refFeatured).getClassifiers().iterator();
                while (iterator.hasNext()) {
                    String string2;
                    Object e = iterator.next();
                    if (!(e instanceof JavaClass) || !string.equals(string2 = ((JavaClass)e).getSimpleName())) continue;
                    string = ((JavaClass)refObject).getSimpleName();
                    break;
                }
                this.oldName = string;
            } else {
                this.oldName = ((JavaClass)refObject).getSimpleName();
            }
        } else {
            this.refactoring = new RenameRefactoring(refObject);
            this.oldName = refObject instanceof NamedElement ? (refObject instanceof Resource ? JavaMetamodel.getManager().getDataObject((Resource)refObject).getName() : ((NamedElement)refObject).getName()) : "";
        }
        this.dispOldName = this.oldName;
    }

    public RenameRefactoringUI(RefObject refObject) {
        this(refObject, (FileObject)null, true);
    }

    private MoveClassRefactoring createMoveClassRefactoring(FileObject fileObject, boolean bl) {
        return new MoveClassRefactoring(fileObject, bl);
    }

    RenameRefactoringUI(RefObject refObject, String string) {
        this.refactoring = new RenameRefactoring(refObject);
        this.jmiObject = refObject;
        this.oldName = string;
        this.dispOldName = string;
        this.fromListener = true;
    }

    RenameRefactoringUI(FileObject fileObject, String string, boolean bl) {
        this.refactoring = this.createMoveClassRefactoring(fileObject, bl);
        this.pkgRename = bl;
        this.oldName = string;
        this.dispOldName = string;
        this.fromListener = true;
        this.byPassFolder = fileObject;
        this.byPassPakageRename = bl;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parametersPanel) {
        if (this.panel == null) {
            String string = this.oldName;
            String string2 = "";
            if (this.jmiObject instanceof JavaClass) {
                string2 = ((JavaClass)this.jmiObject).isInterface() ? RenameRefactoringUI.getString("LBL_Interface") : RenameRefactoringUI.getString("LBL_Class");
            } else if (this.jmiObject instanceof Method) {
                string2 = RenameRefactoringUI.getString("LBL_Method");
            } else if (this.jmiObject instanceof Field) {
                string2 = RenameRefactoringUI.getString("LBL_Field");
            } else if (this.jmiObject instanceof LocalVariable) {
                string2 = RenameRefactoringUI.getString("LBL_LocalVar");
            } else if (this.jmiObject instanceof JavaPackage || this.jmiObject == null && this.fromListener) {
                string2 = this.pkgRename ? RenameRefactoringUI.getString("LBL_Package") : RenameRefactoringUI.getString("LBL_Folder");
            } else if (this.jmiObject instanceof Parameter) {
                string2 = RenameRefactoringUI.getString("LBL_Parameter");
            }
            string2 = string2 + " " + string;
            this.panel = new RenamePanel(string, parametersPanel, NbBundle.getMessage((Class)RenamePanel.class, (String)"LBL_Rename") + " " + string2, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)RenameRefactoringUI.class, (String)string);
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchJavadoc());
        } else {
            ((MoveClassRefactoring)this.refactoring).setTargetPackageName(this.newName);
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
        } else {
            ((MoveClassRefactoring)this.refactoring).setTargetPackageName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage((Class)RenameAction.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage((Class)RenameAction.class, (String)"LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        String string = this.jmiObject instanceof JavaPackage ? ".JavaPackage" : (this.jmiObject instanceof JavaClass ? ".JavaClass" : (this.jmiObject instanceof Method ? ".Method" : (this.jmiObject instanceof Field ? ".Field" : "")));
        return new HelpCtx(RenameRefactoringUI.class.getName() + string);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Object object = this.byPassFolder != null ? DataFolder.findFolder((FileObject)this.byPassFolder) : JMManager.getManager().getDataObject(((Element)((RenameRefactoring)this.refactoring).getRefactoredObject()).getResource());
        object.rename(this.panel.getNameValue());
    }
}

