/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.CallableFeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.RefactoringModule;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.ui.SafeDeleteUI;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SafeDeletePanel
extends CustomRefactoringPanel {
    private final transient Collection elements;
    private final transient SafeDeleteRefactoring refactoring;
    private boolean initialized = false;
    private String methodDeclaringClass = null;
    private ButtonGroup buttonGroup;
    private JPanel jPanel3;
    private JLabel label;
    private JCheckBox searchInComments;

    public SafeDeletePanel(SafeDeleteRefactoring safeDeleteRefactoring, Collection collection) {
        this.setName(NbBundle.getMessage((Class)SafeDeletePanel.class, (String)"LBL_SafeDel"));
        this.elements = collection;
        this.refactoring = safeDeleteRefactoring;
        this.initComponents();
    }

    String getMethodDeclaringClass() {
        return this.methodDeclaringClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        String string;
        this.searchInComments.setEnabled(true);
        if (this.initialized) {
            return;
        }
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            if (this.elements.size() > 1) {
                Object object;
                Iterator iterator = this.elements.iterator();
                Object var3_3 = null;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!(object instanceof Resource)) continue;
                    var3_3 = object;
                    break;
                }
                if (var3_3 != null) {
                    object = this.getElementName(var3_3);
                    string = NbBundle.getMessage((Class)SafeDeletePanel.class, (String)"LBL_SafeDelHeader", object);
                } else {
                    iterator = this.elements.iterator();
                    object = (Element)iterator.next();
                    String string2 = this.getElementName((Element)object);
                    String string3 = this.getElementName((Element)iterator.next());
                    string = NbBundle.getMessage((Class)SafeDeletePanel.class, (String)"LBL_SafeDel_Elements", (Object)string2, (Object)string3);
                }
            } else {
                Element element = (Element)this.elements.iterator().next();
                string = this.getCustomString(element);
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SafeDeletePanel.this.label.setText(string);
                SafeDeletePanel.this.validate();
            }
        });
        this.initialized = true;
    }

    public void requestFocus() {
        super.requestFocus();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.label, "North");
        this.searchInComments.setSelected((Boolean)RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_SafeDelInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SafeDeletePanel.this.searchInCommentsItemStateChanged(itemEvent);
            }
        });
        this.jPanel3.add((Component)this.searchInComments, "South");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.jPanel3, "North");
    }

    private void searchInCommentsItemStateChanged(ItemEvent itemEvent) {
        Boolean bl = itemEvent.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", bl);
        this.refactoring.setCheckInComments(bl);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width + 30, dimension.height + 30);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public String getHeader(CallableFeature callableFeature) {
        if (((CallableFeatureImpl)callableFeature).getParser() == null) {
            if (callableFeature instanceof Method) {
                return ((Method)callableFeature).getName();
            }
            if (callableFeature instanceof Constructor) {
                return this.getSimpleName(callableFeature.getDeclaringClass());
            }
            return "";
        }
        int n = ((MetadataElement)callableFeature).getPartStartOffset((ElementPartKind)ElementPartKindEnum.HEADER);
        int n2 = ((MetadataElement)callableFeature).getPartEndOffset((ElementPartKind)ElementPartKindEnum.HEADER);
        String string = callableFeature.getResource().getSourceText().substring(n, n2);
        if (string.length() > 50) {
            string = string.substring(0, 49) + "...";
        }
        return CheckUtils.htmlize(string);
    }

    public String getSimpleName(ClassDefinition classDefinition) {
        if (classDefinition instanceof JavaClass) {
            return ((JavaClass)classDefinition).getSimpleName();
        }
        return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_AnonymousClass");
    }

    private String getCustomString(Object object) {
        if (object instanceof ElementReference) {
            NamedElement namedElement = ((ElementReference)object).getElement();
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelRefWarning", (Object)namedElement.getName());
        }
        if (object instanceof Method) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelMethod", (Object)this.getHeader((CallableFeature)object), (Object)this.getSimpleName(((CallableFeature)object).getDeclaringClass()));
        }
        if (object instanceof Constructor) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelConstructor", (Object)this.getHeader((CallableFeature)object), (Object)this.getSimpleName(((CallableFeature)object).getDeclaringClass()));
        }
        if (object instanceof Field) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelField", (Object)((Field)object).getName(), (Object)this.getSimpleName(((Field)object).getDeclaringClass()));
        }
        if (object instanceof Variable) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelVariable", (Object)((Variable)object).getName());
        }
        if (object instanceof NamedElement) {
            String string = ((NamedElement)object).getName();
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelHeader", (Object)string);
        }
        return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDelHeader", (Object)object);
    }

    private String getElementName(Element element) {
        if (element instanceof Resource) {
            FileObject fileObject = JavaModel.getFileObject((Resource)((Resource)element));
            return fileObject.getNameExt();
        }
        return element.toString();
    }
}

