/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.elements.IconResolver;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class UIUtilities {
    private UIUtilities() {
    }

    public static String getDisplayText(NamedElement namedElement) {
        if (namedElement == null || !namedElement.isValid()) {
            return NbBundle.getMessage((Class)UIUtilities.class, (String)"LBL_NotAvailable");
        }
        if (namedElement instanceof JavaClass) {
            return ((JavaClass)namedElement).getSimpleName();
        }
        if (namedElement instanceof CallableFeature) {
            CallableFeature callableFeature = (CallableFeature)namedElement;
            StringBuffer stringBuffer = new StringBuffer(callableFeature.getName());
            stringBuffer.append('(');
            Iterator iterator = callableFeature.getParameters().iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                stringBuffer.append(UIUtilities.getDisplayText((NamedElement)parameter.getType()));
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                if (!parameter.isVarArg()) continue;
                stringBuffer.append("...");
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        return namedElement.getName();
    }

    public static String getIconBase(NamedElement namedElement) {
        if (namedElement instanceof Feature) {
            return IconResolver.getIconBase((Feature)((Feature)namedElement));
        }
        if (namedElement instanceof Resource) {
            return "org/netbeans/modules/java/resources/class";
        }
        if (namedElement instanceof JavaPackage) {
            return "org/netbeans/modules/refactoring/resources/package";
        }
        return null;
    }

    public static String getColumnName(String string) {
        return string == null || string.length() == 0 ? " " : string;
    }

    public static void initColumnWidth(JTable jTable, int n, Object object, int n2) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n3 = component.getPreferredSize().width;
        component = jTable.getDefaultRenderer(jTable.getModel().getColumnClass(n)).getTableCellRendererComponent(jTable, object, false, false, 0, n);
        n3 = Math.max(n3, component.getPreferredSize().width) + 2 * n2;
        tableColumn.setPreferredWidth(n3);
        if (object instanceof Boolean) {
            tableColumn.setMaxWidth(n3);
        }
    }

    public static class BooleanTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final JLabel emptyLabel = new JLabel();

        public BooleanTableCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.emptyLabel.setBorder(noFocusBorder);
            this.emptyLabel.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent;
            if (object == null) {
                jComponent = this.emptyLabel;
            } else {
                this.setSelected((Boolean)object);
                this.setEnabled(jTable.getModel().isCellEditable(n, n2));
                jComponent = this;
            }
            jComponent.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            jComponent.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            jComponent.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
            return jComponent;
        }
    }

    public static class JavaElementListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, this.extractText(object), n, bl, bl2);
            String string = this.extractIconBase(object);
            if (string != null) {
                this.setIcon(new ImageIcon(Utilities.loadImage((String)(string + ".gif"))));
            }
            return this;
        }

        protected String extractIconBase(Object object) {
            if (object instanceof NamedElement) {
                return UIUtilities.getIconBase((NamedElement)object);
            }
            return null;
        }

        protected String extractText(Object object) {
            if (object instanceof NamedElement) {
                return UIUtilities.getDisplayText((NamedElement)object);
            }
            return object.toString();
        }
    }

    public static class JavaElementTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, this.extractText(object), bl, bl2, n, n2);
            String string = this.extractIconBase(object);
            this.setIcon(string == null ? null : new ImageIcon(Utilities.loadImage((String)(string + ".gif"))));
            return this;
        }

        protected String extractIconBase(Object object) {
            if (object instanceof NamedElement) {
                return UIUtilities.getIconBase((NamedElement)object);
            }
            return null;
        }

        protected String extractText(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof NamedElement) {
                return UIUtilities.getDisplayText((NamedElement)object);
            }
            return object.toString();
        }
    }
}

