/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.UndoManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class UndoAction
extends CallableSystemAction
implements PropertyChangeListener {
    private UndoManager undoManager;

    public UndoAction() {
        this.putValue("Name", UndoAction.getString("LBL_Undo"));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.undoManager = JavaMetamodel.getUndoManager();
        this.undoManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.updateState();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateState();
    }

    private void updateState() {
        String string = this.undoManager.getUndoDescription();
        String string2 = UndoAction.getString("LBL_Undo");
        if (string != null) {
            string2 = string2 + " [" + string + "]";
        }
        final String string3 = string2;
        Runnable runnable = new Runnable(){

            public void run() {
                UndoAction.this.setEnabled(UndoAction.this.undoManager.isUndoAvailable());
                UndoAction.this.putValue("Name", string3);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static final String getString(String string) {
        return NbBundle.getMessage((Class)UndoAction.class, (String)string);
    }

    public void performAction() {
        this.undoManager.undo();
        this.undoManager.saveAll();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    protected boolean asynchronous() {
        return true;
    }
}

