/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.netbeans.modules.classfile.AnnotationComponent;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPName;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;

public class Annotation {
    ClassName type;
    AnnotationComponent[] components;
    boolean runtimeVisible;

    static void load(DataInputStream dataInputStream, ConstantPool constantPool, boolean bl, Map map) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = Annotation.loadAnnotation(dataInputStream, constantPool, bl);
            map.put(annotation.getType(), annotation);
        }
    }

    static Annotation loadAnnotation(DataInputStream dataInputStream, ConstantPool constantPool, boolean bl) throws IOException {
        ClassName className;
        CPEntry cPEntry = constantPool.get(dataInputStream.readUnsignedShort());
        if (cPEntry.getTag() == 7) {
            className = ((CPClassInfo)cPEntry).getClassName();
        } else {
            String string = ((CPName)cPEntry).getName();
            className = ClassName.getClassName(string);
        }
        int n = dataInputStream.readUnsignedShort();
        ArrayList<AnnotationComponent> arrayList = new ArrayList<AnnotationComponent>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(AnnotationComponent.load(dataInputStream, constantPool, bl));
        }
        AnnotationComponent[] annotationComponentArray = new AnnotationComponent[arrayList.size()];
        arrayList.toArray(annotationComponentArray);
        return new Annotation(constantPool, className, annotationComponentArray, bl);
    }

    Annotation(ConstantPool constantPool, ClassName className, AnnotationComponent[] annotationComponentArray, boolean bl) {
        this.type = className;
        this.components = annotationComponentArray;
        this.runtimeVisible = bl;
    }

    public final ClassName getType() {
        return this.type;
    }

    public final AnnotationComponent[] getComponents() {
        return (AnnotationComponent[])this.components.clone();
    }

    public final AnnotationComponent getComponent(String string) {
        for (int i = 0; i < this.components.length; ++i) {
            AnnotationComponent annotationComponent = this.components[i];
            if (!annotationComponent.getName().equals(string)) continue;
            return annotationComponent;
        }
        return null;
    }

    public boolean isRuntimeVisible() {
        return this.runtimeVisible;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@");
        stringBuffer.append(this.type);
        stringBuffer.append(" runtimeVisible=");
        stringBuffer.append(this.runtimeVisible);
        int n = this.components.length;
        if (n > 0) {
            stringBuffer.append(" { ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.components[i]);
                if (i >= n - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
        }
        return stringBuffer.toString();
    }
}

