/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.ExceptionTableEntry;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.classfile.LocalVariableTableEntry;
import org.netbeans.modules.classfile.LocalVariableTypeTableEntry;
import org.netbeans.modules.classfile.StackMapFrame;

public final class Code {
    private static final boolean debug = false;
    private int maxStack;
    private int maxLocals;
    private byte[] byteCodes;
    private ExceptionTableEntry[] exceptionTable;
    private int[] lineNumberTable;
    private LocalVariableTableEntry[] localVariableTable;
    private LocalVariableTypeTableEntry[] localVariableTypeTable;
    private StackMapFrame[] stackMapTable;

    Code(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        if (dataInputStream == null) {
            throw new IllegalArgumentException("input stream not specified");
        }
        if (constantPool == null) {
            throw new IllegalArgumentException("constant pool not specified");
        }
        this.loadCode(dataInputStream, constantPool);
    }

    private void loadCode(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.maxStack = dataInputStream.readUnsignedShort();
        this.maxLocals = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readInt();
        this.byteCodes = new byte[n];
        dataInputStream.readFully(this.byteCodes);
        this.exceptionTable = ExceptionTableEntry.loadExceptionTable(dataInputStream, constantPool);
        this.loadCodeAttributes(dataInputStream, constantPool);
    }

    private void loadCodeAttributes(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            int n2;
            CPEntry cPEntry = constantPool.get(dataInputStream.readUnsignedShort());
            if (!(cPEntry instanceof CPUTF8Info)) {
                throw new InvalidClassFormatException();
            }
            CPUTF8Info cPUTF8Info = (CPUTF8Info)cPEntry;
            String string = cPUTF8Info.getName();
            if (string.equals("LineNumberTable")) {
                this.loadLineNumberTable(dataInputStream, constantPool);
                continue;
            }
            if (string.equals("LocalVariableTable")) {
                this.localVariableTable = LocalVariableTableEntry.loadLocalVariableTable(dataInputStream, constantPool);
                continue;
            }
            if (string.equals("LocalVariableTypeTable")) {
                this.localVariableTypeTable = LocalVariableTypeTableEntry.loadLocalVariableTypeTable(dataInputStream, constantPool);
                continue;
            }
            if (string.equals("StackMapTable")) {
                this.stackMapTable = StackMapFrame.loadStackMapTable(dataInputStream, constantPool);
                continue;
            }
            for (int j = dataInputStream.readInt(); (n2 = (int)dataInputStream.skip(j)) > 0 && n2 < j; j -= n2) {
            }
        }
        if (this.lineNumberTable == null) {
            this.lineNumberTable = new int[0];
        }
        if (this.localVariableTable == null) {
            this.localVariableTable = new LocalVariableTableEntry[0];
        }
        if (this.localVariableTypeTable == null) {
            this.localVariableTypeTable = new LocalVariableTypeTableEntry[0];
        }
        if (this.stackMapTable == null) {
            this.stackMapTable = new StackMapFrame[0];
        }
    }

    private void loadLineNumberTable(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.lineNumberTable = new int[n * 2];
        for (int i = 0; i < n; ++i) {
            this.lineNumberTable[i * 2] = dataInputStream.readUnsignedShort();
            this.lineNumberTable[i * 2 + 1] = dataInputStream.readUnsignedShort();
        }
    }

    public final int getMaxStack() {
        return this.maxStack;
    }

    public final int getMaxLocals() {
        return this.maxLocals;
    }

    public final byte[] getByteCodes() {
        return (byte[])this.byteCodes.clone();
    }

    public final ExceptionTableEntry[] getExceptionTable() {
        return (ExceptionTableEntry[])this.exceptionTable.clone();
    }

    public final int[] getLineNumberTable() {
        return (int[])this.lineNumberTable.clone();
    }

    public final LocalVariableTableEntry[] getLocalVariableTable() {
        return (LocalVariableTableEntry[])this.localVariableTable.clone();
    }

    public final LocalVariableTypeTableEntry[] getLocalVariableTypeTable() {
        return (LocalVariableTypeTableEntry[])this.localVariableTypeTable.clone();
    }

    public final StackMapFrame[] getStackMapTable() {
        return (StackMapFrame[])this.stackMapTable.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Code: bytes=");
        stringBuffer.append(this.byteCodes.length);
        stringBuffer.append(", stack=");
        stringBuffer.append(this.maxStack);
        stringBuffer.append(", locals=");
        stringBuffer.append(this.maxLocals);
        return stringBuffer.toString();
    }
}

