/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.Annotation;
import org.netbeans.modules.classfile.ArrayElementValue;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.ClassElementValue;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.EnumElementValue;
import org.netbeans.modules.classfile.NestedElementValue;
import org.netbeans.modules.classfile.PrimitiveElementValue;

public abstract class ElementValue {
    static final /* synthetic */ boolean $assertionsDisabled;

    static ElementValue load(DataInputStream dataInputStream, ConstantPool constantPool, boolean bl) throws IOException {
        char c = (char)dataInputStream.readByte();
        switch (c) {
            case 'e': {
                return ElementValue.loadEnumValue(dataInputStream, constantPool);
            }
            case 'c': {
                int n = dataInputStream.readUnsignedShort();
                return new ClassElementValue(constantPool, n);
            }
            case '@': {
                Annotation annotation = Annotation.loadAnnotation(dataInputStream, constantPool, bl);
                return new NestedElementValue(constantPool, annotation);
            }
            case '[': {
                ElementValue[] elementValueArray = new ElementValue[dataInputStream.readUnsignedShort()];
                for (int i = 0; i < elementValueArray.length; ++i) {
                    elementValueArray[i] = ElementValue.load(dataInputStream, constantPool, bl);
                }
                return new ArrayElementValue(constantPool, elementValueArray);
            }
        }
        if (!$assertionsDisabled && "BCDFIJSZs".indexOf(c) < 0) {
            throw new AssertionError((Object)"invalid annotation tag");
        }
        return new PrimitiveElementValue(constantPool, dataInputStream.readUnsignedShort());
    }

    private static ElementValue loadEnumValue(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        CPEntry cPEntry = constantPool.get(n);
        if (cPEntry.getTag() == 9) {
            CPFieldInfo cPFieldInfo = (CPFieldInfo)cPEntry;
            String string = cPFieldInfo.getClassName().getInternalName();
            String string2 = cPFieldInfo.getFieldName();
            return new EnumElementValue(string, string2);
        }
        int n2 = dataInputStream.readUnsignedShort();
        return new EnumElementValue(constantPool, n, n2);
    }

    ElementValue() {
    }

    static {
        $assertionsDisabled = !ElementValue.class.desiredAssertionStatus();
    }
}

