/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPFieldMethodInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.ElementValue;
import org.netbeans.modules.classfile.Field;
import org.netbeans.modules.classfile.Parameter;

public final class Method
extends Field {
    private Code code;
    private CPClassInfo[] exceptions;
    private Parameter[] parameters;
    private ElementValue annotationDefault;

    static Method[] loadMethods(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile, boolean bl) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        Method[] methodArray = new Method[n];
        for (int i = 0; i < n; ++i) {
            methodArray[i] = new Method(dataInputStream, constantPool, classFile, bl);
        }
        return methodArray;
    }

    Method(DataInputStream dataInputStream, ConstantPool constantPool, ClassFile classFile, boolean bl) throws IOException {
        super(dataInputStream, constantPool, classFile, bl);
    }

    public final Code getCode() {
        DataInputStream dataInputStream;
        if (this.code == null && (dataInputStream = this.attributes.getStream("Code")) != null) {
            try {
                this.code = new Code(dataInputStream, this.classFile.constantPool);
                dataInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("invalid Code attribute");
            }
        }
        return this.code;
    }

    public final CPClassInfo[] getExceptionClasses() {
        if (this.exceptions == null) {
            DataInputStream dataInputStream = this.attributes.getStream("Exceptions");
            if (dataInputStream != null) {
                try {
                    this.exceptions = ClassFile.getCPClassList(dataInputStream, this.classFile.constantPool);
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println("invalid Exceptions attribute");
                }
            }
            if (this.exceptions == null) {
                this.exceptions = new CPClassInfo[0];
            }
        }
        return (CPClassInfo[])this.exceptions.clone();
    }

    public final boolean isBridge() {
        return (this.access & 0x40) == 64;
    }

    public final boolean isVarArgs() {
        return (this.access & 0x80) == 128;
    }

    public final boolean isSynchronized() {
        return (this.access & 0x20) == 32;
    }

    public final boolean isNative() {
        return (this.access & 0x100) == 256;
    }

    public final boolean isAbstract() {
        return (this.access & 0x400) == 1024;
    }

    public final List getParameters() {
        if (this.parameters == null) {
            this.parameters = Parameter.makeParams(this);
        }
        return Arrays.asList(this.parameters);
    }

    public final String getReturnType() {
        String string = this.getDescriptor();
        int n = string.indexOf(41) + 1;
        return string.substring(n);
    }

    public final String getReturnSignature() {
        String string = this.getReturnType();
        return CPFieldMethodInfo.getSignature(string, true);
    }

    public ElementValue getAnnotationDefault() {
        DataInputStream dataInputStream;
        if (this.annotationDefault == null && (dataInputStream = this.attributes.getStream("AnnotationDefault")) != null) {
            try {
                this.annotationDefault = ElementValue.load(dataInputStream, this.classFile.constantPool, false);
                dataInputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("invalid AnnotationDefault attribute");
            }
        }
        return this.annotationDefault;
    }

    public String toString() {
        Code code;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(", params (");
        this.getParameters();
        for (int i = 0; i < this.parameters.length; ++i) {
            stringBuffer.append(this.parameters[i].toString());
            if (i + 1 >= this.parameters.length) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("), returns ");
        stringBuffer.append(this.getReturnSignature());
        CPClassInfo[] cPClassInfoArray = this.getExceptionClasses();
        if (cPClassInfoArray.length > 0) {
            stringBuffer.append(", throws");
            for (int i = 0; i < cPClassInfoArray.length; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(cPClassInfoArray[i].getName());
            }
        }
        if (this.getAnnotationDefault() != null) {
            stringBuffer.append(", default \"");
            stringBuffer.append(this.annotationDefault.toString());
            stringBuffer.append("\" ");
        }
        if ((code = this.getCode()) != null) {
            stringBuffer.append(' ');
            stringBuffer.append(code.toString());
        }
        return stringBuffer.toString();
    }

    public final String getDeclaration() {
        return CPMethodInfo.getFullMethodName(this.getName(), this.getDescriptor());
    }
}

