/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.modules.classfile.Annotation;
import org.netbeans.modules.classfile.AttributeMap;
import org.netbeans.modules.classfile.CPFieldMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.Field;
import org.netbeans.modules.classfile.LocalVariableTableEntry;
import org.netbeans.modules.classfile.Method;

public final class Parameter
extends Field {
    static /* synthetic */ Class class$org$netbeans$modules$classfile$Parameter;

    static Parameter[] makeParams(Method method) {
        ArrayList arrayList = new ArrayList();
        ParamIterator paramIterator = new ParamIterator(method);
        while (paramIterator.hasNext()) {
            arrayList.add(paramIterator.next());
        }
        return arrayList.toArray(new Parameter[0]);
    }

    private static Parameter createParameter(String string, String string2, ClassFile classFile, DataInputStream dataInputStream, DataInputStream dataInputStream2) {
        return new Parameter(string, string2, classFile, dataInputStream, dataInputStream2);
    }

    private Parameter(String string, String string2, ClassFile classFile, DataInputStream dataInputStream, DataInputStream dataInputStream2) {
        super(string, string2, classFile);
        this.loadParameterAnnotations(dataInputStream, dataInputStream2);
    }

    private void loadParameterAnnotations(DataInputStream dataInputStream, DataInputStream dataInputStream2) {
        super.loadAnnotations();
        if (this.annotations == null && (dataInputStream != null || dataInputStream2 != null)) {
            this.annotations = new HashMap(2);
        }
        try {
            if (dataInputStream != null) {
                Annotation.load(dataInputStream, this.classFile.getConstantPool(), true, this.annotations);
            }
        }
        catch (IOException iOException) {
            System.err.println("invalid RuntimeVisibleParameterAnnotations attribute");
        }
        try {
            if (dataInputStream2 != null) {
                Annotation.load(dataInputStream2, this.classFile.getConstantPool(), false, this.annotations);
            }
        }
        catch (IOException iOException) {
            System.err.println("invalid RuntimeInvisibleParameterAnnotations attribute");
        }
    }

    public final String getDeclaration() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CPFieldMethodInfo.getSignature(this.getDescriptor(), false));
        String string = this.getName();
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("name=");
        stringBuffer.append(this.getName());
        stringBuffer.append(" type=");
        stringBuffer.append(this.getDescriptor());
        if (this.getTypeSignature() != null) {
            stringBuffer.append(", signature=");
            stringBuffer.append(this.typeSignature);
        }
        this.loadAnnotations();
        if (this.annotations.size() > 0) {
            Iterator iterator = this.annotations.values().iterator();
            stringBuffer.append(", annotations={ ");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
        }
        return stringBuffer.toString();
    }

    private static class ParamIterator
    implements Iterator {
        ClassFile classFile;
        String signature;
        LocalVariableTableEntry[] localVars;
        int ivar;
        int isig;
        DataInputStream visibleAnnotations;
        DataInputStream invisibleAnnotations;
        static final /* synthetic */ boolean $assertionsDisabled;

        ParamIterator(Method method) {
            this.classFile = method.getClassFile();
            this.signature = method.getDescriptor();
            if (!$assertionsDisabled && this.signature.charAt(0) != '(') {
                throw new AssertionError();
            }
            this.isig = 1;
            this.ivar = method.isStatic() ? 0 : 1;
            Code code = method.getCode();
            this.localVars = code != null ? code.getLocalVariableTable() : new LocalVariableTableEntry[]{};
            AttributeMap attributeMap = method.getAttributes();
            try {
                this.visibleAnnotations = this.getParamAttr(attributeMap, "RuntimeVisibleParameterAnnotations");
            }
            catch (IOException iOException) {
                System.err.println("invalid RuntimeVisibleParameterAnnotations attribute");
            }
            try {
                this.invisibleAnnotations = this.getParamAttr(attributeMap, "RuntimeInvisibleParameterAnnotations");
            }
            catch (IOException iOException) {
                System.err.println("invalid RuntimeInvisibleParameterAnnotations attribute");
            }
        }

        private DataInputStream getParamAttr(AttributeMap attributeMap, String string) throws IOException {
            DataInputStream dataInputStream = attributeMap.getStream(string);
            if (dataInputStream != null) {
                dataInputStream.readByte();
            }
            return dataInputStream;
        }

        public boolean hasNext() {
            return this.signature.charAt(this.isig) != ')';
        }

        public Object next() {
            if (this.hasNext()) {
                int n;
                String string = "";
                for (n = 0; n < this.localVars.length; ++n) {
                    LocalVariableTableEntry localVariableTableEntry = this.localVars[n];
                    if (localVariableTableEntry.index != this.ivar || localVariableTableEntry.startPC != 0) continue;
                    string = this.localVars[n].getName();
                    break;
                }
                ++this.ivar;
                n = this.isig;
                while (this.isig < this.signature.length()) {
                    char c = this.signature.charAt(this.isig);
                    switch (c) {
                        case '[': {
                            ++this.isig;
                            break;
                        }
                        case 'B': 
                        case 'C': 
                        case 'F': 
                        case 'I': 
                        case 'S': 
                        case 'V': 
                        case 'Z': {
                            String string2 = this.signature.substring(n, ++this.isig);
                            return Parameter.createParameter(string, string2, this.classFile, this.visibleAnnotations, this.invisibleAnnotations);
                        }
                        case 'D': 
                        case 'J': {
                            ++this.ivar;
                            String string3 = this.signature.substring(n, ++this.isig);
                            return Parameter.createParameter(string, string3, this.classFile, this.visibleAnnotations, this.invisibleAnnotations);
                        }
                        case 'L': {
                            int n2 = this.signature.indexOf(59, this.isig) + 1;
                            String string4 = this.signature.substring(this.isig, n2);
                            this.isig = n2;
                            return Parameter.createParameter(string, string4, this.classFile, this.visibleAnnotations, this.invisibleAnnotations);
                        }
                    }
                }
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$classfile$Parameter == null ? (class$org$netbeans$modules$classfile$Parameter = Parameter.class$("org.netbeans.modules.classfile.Parameter")) : class$org$netbeans$modules$classfile$Parameter).desiredAssertionStatus();
        }
    }
}

