/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.ver1_2;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.impl.DetailImpl;
import com.sun.xml.messaging.saaj.soap.impl.FaultImpl;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;
import com.sun.xml.messaging.saaj.soap.ver1_2.Detail1_2Impl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class Fault1_2Impl
extends FaultImpl {
    protected DetailImpl createDetail() {
        return new Detail1_2Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument());
    }

    protected NameImpl getDetailName() {
        return NameImpl.createSOAP12Name("Detail");
    }

    private NameImpl getFaultCodeName() {
        return NameImpl.createSOAP12Name("Code");
    }

    private NameImpl getFaultNodeName() {
        return NameImpl.createSOAP12Name("Node");
    }

    private NameImpl getFaultReasonName() {
        return NameImpl.createSOAP12Name("Reason");
    }

    private NameImpl getFaultReasonTextName() {
        return NameImpl.createSOAP12Name("Text");
    }

    private NameImpl getFaultRoleName() {
        return NameImpl.createSOAP12Name("Role");
    }

    private NameImpl getXmlLangName() {
        return NameImpl.createXmlName("lang");
    }

    public String getFaultNode() {
        SOAPElement faultNode = this.findChild(this.getFaultNodeName());
        if (faultNode == null) {
            return null;
        }
        return faultNode.getNodeValue();
    }

    public String getFaultRole() {
        SOAPElement faultRole = this.findChild(this.getFaultRoleName());
        if (faultRole == null) {
            return null;
        }
        return faultRole.getNodeValue();
    }

    public String getFirstFaultReasonText() {
        SOAPElement reasonText = this.getFirstFaultReasonTextElement();
        if (reasonText == null) {
            return null;
        }
        return reasonText.getValue();
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        throw new SOAPExceptionImpl("EncodingStyle attribute cannot appear in Fault");
    }

    public void setFaultNode(String uri) throws SOAPException {
        SOAPElement faultNode = this.findChild(this.getFaultNodeName());
        if (faultNode != null) {
            faultNode.detachNode();
        }
        faultNode = this.addElement(this.getFaultNodeName());
        faultNode.addTextNode(uri);
    }

    public void setFaultRole(String uri) throws SOAPException {
        SOAPElement faultRole = this.findChild(this.getFaultRoleName());
        if (faultRole != null) {
            faultRole.detachNode();
        }
        faultRole = this.addElement(this.getFaultRoleName());
        faultRole.addTextNode(uri);
    }

    public Locale getFirstFaultReasonTextLocale() {
        SOAPElement reasonText = this.getFirstFaultReasonTextElement();
        if (reasonText == null) {
            return null;
        }
        return Fault1_2Impl.xmlLangToLocale(reasonText.getAttributeValue(this.getXmlLangName()));
    }

    public Map getFaultReasonTexts() {
        HashMap<String, String> textsMap = new HashMap<String, String>();
        SOAPElement reason = this.getFaultReasonElement();
        if (reason == null) {
            return textsMap;
        }
        Iterator textIt = reason.getChildElements(this.getFaultReasonTextName());
        while (textIt.hasNext()) {
            SOAPElement text = (SOAPElement)textIt.next();
            String key = text.getAttributeValue(this.getXmlLangName());
            String value = text.getValue();
            textsMap.put(key, value);
        }
        return textsMap;
    }

    private SOAPElement getFaultReasonElement() {
        return this.findChild(this.getFaultReasonName());
    }

    private SOAPElement getFirstFaultReasonTextElement() {
        SOAPElement reason = this.getFaultReasonElement();
        if (reason == null) {
            return null;
        }
        return (SOAPElement)reason.getFirstChild();
    }

    protected DetailImpl createDetail(Name name) {
        return new Detail1_2Impl(((SOAPDocument)((Object)this.getOwnerDocument())).getDocument(), name);
    }

    public Fault1_2Impl(SOAPDocumentImpl ownerDocument, String prefix) {
        super(ownerDocument, NameImpl.createFault1_2Name(null, prefix));
    }

    protected static String localeToXmlLang(Locale locale) {
        String xmlLang = locale.getLanguage();
        String country = locale.getCountry();
        if (!"".equals(country)) {
            xmlLang = xmlLang + "-" + country;
        }
        return xmlLang;
    }

    protected static Locale xmlLangToLocale(String xmlLang) {
        if (xmlLang == null) {
            return null;
        }
        int index = xmlLang.indexOf("-");
        if (index == -1) {
            index = xmlLang.indexOf("_");
        }
        if (index == -1) {
            return new Locale(xmlLang, "");
        }
        String language = xmlLang.substring(0, index);
        String country = xmlLang.substring(index + 1);
        return new Locale(language, country);
    }

    public void addFaultReasonText(String text, Locale locale) throws SOAPException {
        if (locale == null) {
            throw new IllegalArgumentException("locale is required and must not be null");
        }
        String xmlLang = Fault1_2Impl.localeToXmlLang(locale);
        SOAPElement reason = this.getFaultReasonElement();
        if (reason == null) {
            reason = this.addChildElement(this.getFaultReasonName());
        }
        SOAPElement reasonText = reason.addChildElement(this.getFaultReasonTextName());
        reasonText.addAttribute(this.getXmlLangName(), xmlLang);
        reasonText.addTextNode(text);
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        return super.addElement(name);
    }

    public Fault1_2Impl(SOAPDocumentImpl ownerDoc, String name, String prefix) {
        super(ownerDoc, NameImpl.createFault1_2Name(name, prefix));
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        if (name.getLocalName().equals("encodingStyle") && name.getURI().equals("http://www.w3.org/2002/06/soap-envelope")) {
            throw new SOAPExceptionImpl("EncodingStyle attribute cannot appear in Fault");
        }
        return super.addAttribute(name, value);
    }
}

