/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import org.netbeans.modules.css.CSSObject;
import org.netbeans.modules.css.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.MapFormat;

public final class CSSLoader
extends UniFileLoader {
    private static final long serialVersionUID = -6638807099960633333L;
    private static final String CSS_EXT = "css";
    private static final String CSS_MIME = "text/css";

    public CSSLoader() {
        super("org.netbeans.modules.css.CSSObject");
    }

    protected void initialize() {
        super.initialize();
        ExtensionList extensionList = this.getExtensions();
        extensionList.addExtension(CSS_EXT);
        extensionList.addMimeType(CSS_MIME);
        this.setExtensions(extensionList);
    }

    protected String actionsContext() {
        return "Loaders/text/css/Actions/";
    }

    protected String defaultDisplayName() {
        return Util.THIS.getString("PROP_CSSLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new CSSObject(fileObject, this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new CSSFileEntry(multiDataObject, fileObject);
    }

    public static class CSSFileEntry
    extends FileEntry.Format {
        private static final long serialVersionUID = 2833661760805697888L;

        CSSFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        protected Format createFormat(FileObject fileObject, String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Date date = new Date();
            hashMap.put("NAME", string);
            hashMap.put("DATE", DateFormat.getDateInstance(1).format(date));
            hashMap.put("TIME", DateFormat.getTimeInstance(3).format(date));
            hashMap.put("USER", System.getProperty("user.name"));
            MapFormat mapFormat = new MapFormat(hashMap);
            mapFormat.setLeftBrace("__");
            mapFormat.setRightBrace("__");
            mapFormat.setExactMatch(false);
            return mapFormat;
        }
    }
}

