/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.io.IOException;
import org.netbeans.modules.css.CSSObject;
import org.netbeans.modules.css.actions.CSSDisplayer;
import org.netbeans.modules.css.actions.Util;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.flute.parser.Parser;

public class CheckStyleAction
extends CookieAction
implements ErrorHandler,
DocumentHandler {
    private static final long serialVersionUID = -6638807099960633338L;
    private CSSObject csso;
    private CSSDisplayer disp;
    private boolean failed;
    private int warnings;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public int mode() {
        return 8;
    }

    public Class[] cookieClasses() {
        return new Class[]{CSSObject.class};
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return;
        }
        if (nodeArray[0] == null) {
            return;
        }
        this.failed = false;
        this.warnings = 0;
        this.disp = new CSSDisplayer();
        Parser parser = new Parser();
        parser.setErrorHandler(this);
        parser.setDocumentHandler(this);
        for (int i = 0; i < nodeArray.length; ++i) {
            this.csso = (CSSObject)nodeArray[i].getCookie(class$org$netbeans$modules$css$CSSObject == null ? CheckStyleAction.class$("org.netbeans.modules.css.CSSObject") : class$org$netbeans$modules$css$CSSObject);
            if (this.csso == null) continue;
            try {
                SaveCookie saveCookie = (SaveCookie)this.csso.getCookie(class$org$openide$cookies$SaveCookie == null ? CheckStyleAction.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (saveCookie != null) {
                    saveCookie.save();
                }
                String string = this.csso.getPrimaryFile().getURL().toExternalForm();
                parser.parseStyleSheet(string);
                continue;
            }
            catch (IOException iOException) {
                this.failed = true;
                continue;
            }
            catch (CSSParseException cSSParseException) {
                this.failed = true;
            }
        }
        if (this.failed || this.warnings > 0) {
            this.disp.moveToFront();
        }
        StatusDisplayer.getDefault().setStatusText(Util.THIS.getString("TEXT_PART_CSS_checking") + this.getStatus() + ".");
    }

    private String getStatus() {
        return this.failed ? Util.THIS.getString("TEXT_PART_failed") : (this.warnings > 1 ? Util.THIS.getString("TEXT_PART_finished_with_warnings") : Util.THIS.getString("TEXT_PART_finished"));
    }

    public String getName() {
        return Util.THIS.getString("NAME_check_CSS");
    }

    protected String iconResource() {
        return "org/netbeans/modules/css/resources/checkStyleAction.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public void warning(CSSParseException cSSParseException) throws CSSException {
        this.disp.display((DataObject)this.csso, cSSParseException);
        ++this.warnings;
    }

    public void error(CSSParseException cSSParseException) throws CSSException {
        this.disp.display((DataObject)this.csso, cSSParseException);
        this.failed = true;
    }

    public void fatalError(CSSParseException cSSParseException) throws CSSException {
        this.disp.display((DataObject)this.csso, cSSParseException);
        this.failed = true;
    }

    public void startDocument(InputSource inputSource) throws CSSException {
    }

    public void endDocument(InputSource inputSource) throws CSSException {
    }

    public void comment(String string) throws CSSException {
    }

    public void ignorableAtRule(String string) throws CSSException {
    }

    public void namespaceDeclaration(String string, String string2) throws CSSException {
    }

    public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
    }

    public void startMedia(SACMediaList sACMediaList) throws CSSException {
    }

    public void endMedia(SACMediaList sACMediaList) throws CSSException {
    }

    public void startPage(String string, String string2) throws CSSException {
    }

    public void endPage(String string, String string2) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void startSelector(SelectorList selectorList) throws CSSException {
    }

    public void endSelector(SelectorList selectorList) throws CSSException {
    }

    public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
    }
}

