/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import org.netbeans.modules.css.CSSObject;
import org.netbeans.modules.css.actions.Util;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CookieAction;
import org.openide.util.datatransfer.ExClipboard;

public abstract class CopyStyleAction
extends CookieAction {
    protected static final String comment = Util.THIS.getString("Style-Comment") + "\n";
    private static final long serialVersionUID = -6638807099960633334L;

    public int mode() {
        return 8;
    }

    public Class[] cookieClasses() {
        return new Class[]{CSSObject.class};
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return;
        }
        if (nodeArray[0] == null) {
            return;
        }
        CSSObject cSSObject = (CSSObject)nodeArray[0].getCookie(CSSObject.class);
        if (cSSObject != null) {
            String string = this.createText(cSSObject);
            StringSelection stringSelection = new StringSelection(string);
            ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
            exClipboard.setContents((Transferable)stringSelection, null);
            StatusDisplayer.getDefault().setStatusText(Util.THIS.getString("MSG_Style_tag_in_clipboard"));
        }
    }

    protected abstract String createText(CSSObject var1);

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected String getHref(FileObject fileObject) {
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)2);
        if (uRL != null) {
            return uRL.toExternalForm();
        }
        return fileObject.getPath();
    }

    public static final class HTML
    extends CopyStyleAction {
        private static final long serialVersionUID = -6638807099960633336L;

        protected String createText(CSSObject cSSObject) {
            return comment + "<link rel=\"StyleSheet\" type=\"text/css\" href=\"" + this.getHref(cSSObject.getPrimaryFile()) + "\" media=\"screen\" >";
        }

        public String getName() {
            return Util.THIS.getString("Copy-HTML-Style");
        }
    }

    public static final class XML
    extends CopyStyleAction {
        private static final long serialVersionUID = -6638807099960633335L;

        protected String createText(CSSObject cSSObject) {
            return comment + "<?xml-stylesheet type=\"text/css\" href=\"" + this.getHref(cSSObject.getPrimaryFile()) + "\" ?>";
        }

        public String getName() {
            return Util.THIS.getString("Copy-XML-Style");
        }
    }
}

