/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRLSelector;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLEntryImpl;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CrlRevocationChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final PublicKey mInitPubKey;
    private final List<CertStore> mStores;
    private final String mSigProvider;
    private final Date mCurrentTime;
    private PublicKey mPrevPubKey;
    private boolean mCRLSignFlag;
    private HashSet<X509CRL> mPossibleCRLs;
    private HashSet<X509CRL> mApprovedCRLs;
    private final PKIXParameters mParams;
    private final Collection<X509Certificate> mExtraCerts;
    private static final boolean[] mCrlSignUsage = new boolean[]{false, false, false, false, false, false, true};
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};

    CrlRevocationChecker(PublicKey publicKey, PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this(publicKey, pKIXParameters, null);
    }

    CrlRevocationChecker(PublicKey publicKey, PKIXParameters pKIXParameters, Collection<X509Certificate> collection) throws CertPathValidatorException {
        this.mInitPubKey = publicKey;
        this.mParams = pKIXParameters;
        this.mStores = pKIXParameters.getCertStores();
        this.mSigProvider = pKIXParameters.getSigProvider();
        this.mExtraCerts = collection;
        Date date = pKIXParameters.getDate();
        this.mCurrentTime = date != null ? date : new Date();
        this.init(false);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.mPrevPubKey = this.mInitPubKey;
        this.mCRLSignFlag = true;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        this.verifyRevocationStatus(x509Certificate, this.mPrevPubKey, this.mCRLSignFlag, true);
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
            publicKey = BasicChecker.makeInheritedParamsKey(publicKey, this.mPrevPubKey);
        }
        this.mPrevPubKey = publicKey;
        this.mCRLSignFlag = this.certCanSignCrl(x509Certificate);
    }

    public boolean check(X509Certificate x509Certificate, PublicKey publicKey, boolean bl) throws CertPathValidatorException {
        this.verifyRevocationStatus(x509Certificate, publicKey, bl, true);
        return this.certCanSignCrl(x509Certificate);
    }

    public boolean certCanSignCrl(X509Certificate x509Certificate) {
        try {
            boolean[] blArray = x509Certificate.getKeyUsage();
            if (blArray != null) {
                KeyUsageExtension keyUsageExtension = new KeyUsageExtension(blArray);
                Boolean bl = (Boolean)keyUsageExtension.get("crl_sign");
                return bl;
            }
            return true;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.certCanSignCRL() unexpected exception");
            }
            return false;
        }
    }

    private void verifyRevocationStatus(X509Certificate x509Certificate, PublicKey publicKey, boolean bl, boolean bl2) throws CertPathValidatorException {
        this.verifyRevocationStatus(x509Certificate, publicKey, bl, bl2, null);
    }

    private void verifyRevocationStatus(X509Certificate x509Certificate, PublicKey publicKey, boolean bl, boolean bl2, Set<X509Certificate> set) throws CertPathValidatorException {
        Object object;
        String string = "revocation status";
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() ---checking " + string + "...");
        }
        if (set != null && set.contains(x509Certificate)) {
            throw new CertPathValidatorException("circular dependency - cert can't vouch for CRL");
        }
        if (!bl) {
            if (bl2 && this.verifyWithSeparateSigningKey(x509Certificate, publicKey, bl, set)) {
                return;
            }
            throw new CertPathValidatorException("cert can't vouch for CRL");
        }
        this.mPossibleCRLs = new HashSet();
        this.mApprovedCRLs = new HashSet();
        boolean[] blArray = new boolean[9];
        try {
            object = new X509CRLSelector();
            ((X509CRLSelector)object).setCertificateChecking(x509Certificate);
            ((X509CRLSelector)object).setDateAndTime(this.mCurrentTime);
            for (CertStore object2 : this.mStores) {
                this.mPossibleCRLs.addAll(object2.getCRLs((CRLSelector)object));
            }
            Iterator<X509CRL> iterator = DistributionPointFetcher.getInstance();
            this.mApprovedCRLs.addAll(((DistributionPointFetcher)((Object)iterator)).getCRLs((CRLSelector)object, publicKey, this.mSigProvider, this.mStores, blArray));
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus() unexpected exception: " + exception.getMessage());
            }
            throw new CertPathValidatorException(exception);
        }
        if (this.mPossibleCRLs.isEmpty() && this.mApprovedCRLs.isEmpty()) {
            if (bl2 && this.verifyWithSeparateSigningKey(x509Certificate, publicKey, bl, set)) {
                return;
            }
            throw new CertPathValidatorException(string + " check failed: no CRL found");
        }
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() crls.size() = " + this.mPossibleCRLs.size());
        }
        this.mApprovedCRLs.addAll(this.verifyPossibleCRLs(this.mPossibleCRLs, x509Certificate, publicKey, blArray));
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyRevocationStatus() approved crls.size() = " + this.mApprovedCRLs.size());
        }
        if (this.mApprovedCRLs.isEmpty() || !Arrays.equals(blArray, ALL_REASONS)) {
            if (bl2 && this.verifyWithSeparateSigningKey(x509Certificate, publicKey, bl, set)) {
                return;
            }
            throw new CertPathValidatorException("Could not determine revocation status");
        }
        if (debug != null) {
            object = x509Certificate.getSerialNumber();
            debug.println("starting the final sweep...");
            debug.println("CrlRevocationChecker.verifyRevocationStatus cert SN: " + ((BigInteger)object).toString());
        }
        boolean bl3 = false;
        for (X509CRL x509CRL : this.mApprovedCRLs) {
            Set<String> set2;
            X509CRLEntry x509CRLEntry = x509CRL.getRevokedCertificate(x509Certificate);
            if (x509CRLEntry == null) continue;
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyRevocationStatus CRL entry: " + x509CRLEntry.toString());
            }
            int n = 0;
            try {
                set2 = X509CRLEntryImpl.toImpl(x509CRLEntry);
                Integer n2 = ((X509CRLEntryImpl)((Object)set2)).getReasonCode();
                n = n2 == null ? 0 : n2;
            }
            catch (Exception exception) {
                throw new CertPathValidatorException(exception);
            }
            boolean bl4 = bl3 = n == 6;
            if (!bl3 && n != 8) {
                throw new CertPathValidatorException("Certificate has been revoked, reason: " + CrlRevocationChecker.reasonToString(n));
            }
            set2 = x509CRLEntry.getCriticalExtensionOIDs();
            if (set2 == null || set2.isEmpty()) continue;
            set2.remove(PKIXExtensions.ReasonCode_Id.toString());
            if (set2.isEmpty()) continue;
            throw new CertPathValidatorException("Unrecognized critical extension(s) in revoked CRL entry: " + set2);
        }
        if (bl3) {
            throw new CertPathValidatorException("Certificate is on hold");
        }
    }

    private boolean verifyWithSeparateSigningKey(X509Certificate x509Certificate, PublicKey publicKey, boolean bl, Set<X509Certificate> set) {
        String string = "revocation status";
        if (debug != null) {
            debug.println("CrlRevocationChecker.verifyWithSeparateSigningKey() ---checking " + string + "...");
        }
        if (set != null && set.contains(x509Certificate)) {
            return false;
        }
        if (!bl) {
            publicKey = null;
        }
        try {
            HashSet<PublicKey> hashSet = new HashSet<PublicKey>();
            if (publicKey != null) {
                hashSet.add(publicKey);
            }
            while (true) {
                PublicKey publicKey2 = this.buildToNewKey(x509Certificate, hashSet, set);
                try {
                    this.verifyRevocationStatus(x509Certificate, publicKey2, true, false);
                    return true;
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    hashSet.add(publicKey2);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CrlRevocationChecker.verifyWithSeparateSigningKey() got exception " + exception);
            }
            return false;
        }
    }

    private PublicKey buildToNewKey(X509Certificate x509Certificate, Set<PublicKey> set, Set<X509Certificate> set2) throws CertPathBuilderException {
        if (debug != null) {
            debug.println("CrlRevocationChecker.buildToNewKey() starting work");
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            PKIXBuilderParameters pKIXBuilderParameters;
            RejectKeySelector rejectKeySelector = new RejectKeySelector(set);
            rejectKeySelector.setSubject(x509Certificate.getIssuerX500Principal().getName());
            rejectKeySelector.setKeyUsage(mCrlSignUsage);
            if (this.mParams instanceof PKIXBuilderParameters) {
                pKIXBuilderParameters = (PKIXBuilderParameters)this.mParams.clone();
                pKIXBuilderParameters.setTargetCertConstraints(rejectKeySelector);
                pKIXBuilderParameters.setPolicyQualifiersRejected(true);
            } else {
                pKIXBuilderParameters = new PKIXBuilderParameters(this.mParams.getTrustAnchors(), (CertSelector)rejectKeySelector);
                pKIXBuilderParameters.setInitialPolicies(this.mParams.getInitialPolicies());
                pKIXBuilderParameters.setCertStores(this.mParams.getCertStores());
                pKIXBuilderParameters.setExplicitPolicyRequired(this.mParams.isExplicitPolicyRequired());
                pKIXBuilderParameters.setPolicyMappingInhibited(this.mParams.isPolicyMappingInhibited());
                pKIXBuilderParameters.setAnyPolicyInhibited(this.mParams.isAnyPolicyInhibited());
                pKIXBuilderParameters.setDate(this.mParams.getDate());
                pKIXBuilderParameters.setCertPathCheckers(this.mParams.getCertPathCheckers());
                pKIXBuilderParameters.setSigProvider(this.mParams.getSigProvider());
            }
            if (this.mInitPubKey != null) {
                object6 = pKIXBuilderParameters.getTrustAnchors();
                object5 = new HashSet<TrustAnchor>();
                object4 = object6.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    object2 = ((TrustAnchor)object3).getCAPublicKey();
                    if (object2 != null) {
                        if (!object2.equals(this.mInitPubKey)) continue;
                        object5.add(object3);
                        continue;
                    }
                    object = ((TrustAnchor)object3).getTrustedCert();
                    object2 = ((Certificate)object).getPublicKey();
                    if (!object2.equals(this.mInitPubKey)) continue;
                    object5.add(object3);
                }
                pKIXBuilderParameters.setTrustAnchors((Set<TrustAnchor>)object5);
            }
            pKIXBuilderParameters.setRevocationEnabled(false);
            if (this.mExtraCerts != null) {
                object6 = new CollectionCertStoreParameters(this.mExtraCerts);
                object5 = CertStore.getInstance("Collection", (CertStoreParameters)object6);
                pKIXBuilderParameters.addCertStore((CertStore)object5);
            }
            if (Builder.USE_AIA) {
                block25: {
                    object6 = null;
                    try {
                        object6 = X509CertImpl.toImpl(x509Certificate);
                    }
                    catch (CertificateException certificateException) {
                        if (debug == null) break block25;
                        debug.println("CrlRevocationChecker.buildToNewKey: error decoding cert: " + certificateException);
                    }
                }
                object5 = null;
                if (object6 != null) {
                    object5 = ((X509CertImpl)object6).getAuthorityInfoAccessExtension();
                }
                if (object5 != null && (object4 = ((AuthorityInfoAccessExtension)object5).getAccessDescriptions()) != null) {
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (AccessDescription)object3.next();
                        object = Builder.createCertStore((AccessDescription)object2);
                        if (object == null) continue;
                        if (debug != null) {
                            debug.println("adding AIAext CertStore");
                        }
                        pKIXBuilderParameters.addCertStore((CertStore)object);
                    }
                }
            }
            object6 = CertPathBuilder.getInstance("PKIX");
            if (debug != null) {
                debug.println("CrlRevocationChecker.buildToNewKey() about to try build ...");
            }
            object5 = (PKIXCertPathBuilderResult)((CertPathBuilder)object6).build(pKIXBuilderParameters);
            if (debug != null) {
                debug.println("CrlRevocationChecker.buildToNewKey() about to check revocation ...");
            }
            set2 = set2 == null ? new HashSet<X509Certificate>() : new HashSet<X509Certificate>(set2);
            set2.add(x509Certificate);
            object4 = ((PKIXCertPathValidatorResult)object5).getTrustAnchor();
            object3 = ((TrustAnchor)object4).getCAPublicKey();
            if (object3 == null) {
                object2 = ((TrustAnchor)object4).getTrustedCert();
                object3 = ((Certificate)object2).getPublicKey();
            }
            boolean bl = true;
            object = ((PKIXCertPathBuilderResult)object5).getCertPath();
            List<? extends Certificate> list = ((CertPath)object).getCertificates();
            for (int i = list.size() - 1; i >= 0; --i) {
                X509Certificate x509Certificate2 = (X509Certificate)list.get(i);
                if (debug != null) {
                    debug.println("CrlRevocationChecker.buildToNewKey() index " + i + " checking " + x509Certificate2);
                }
                this.verifyRevocationStatus(x509Certificate2, (PublicKey)object3, bl, true, set2);
                bl = this.certCanSignCrl(x509Certificate);
                object3 = x509Certificate2.getPublicKey();
            }
            if (debug != null) {
                debug.println("CrlRevocationChecker.buildToNewKey() got key " + ((PKIXCertPathValidatorResult)object5).getPublicKey());
            }
            return ((PKIXCertPathValidatorResult)object5).getPublicKey();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CertPathBuilderException(invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CertPathBuilderException(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertPathBuilderException(noSuchAlgorithmException);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathBuilderException(certPathValidatorException);
        }
    }

    private static String reasonToString(int n) {
        switch (n) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "key compromise";
            }
            case 2: {
                return "CA compromise";
            }
            case 3: {
                return "affiliation changed";
            }
            case 4: {
                return "superseded";
            }
            case 5: {
                return "cessation of operation";
            }
            case 6: {
                return "certificate hold";
            }
            case 8: {
                return "remove from CRL";
            }
        }
        return "unrecognized reason code";
    }

    private Collection<X509CRL> verifyPossibleCRLs(Set<X509CRL> set, X509Certificate x509Certificate, PublicKey publicKey, boolean[] blArray) throws CertPathValidatorException {
        try {
            Object object;
            Object object2;
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
            if (debug != null) {
                debug.println("CRLRevocationChecker.verifyPossibleCRLs: Checking CRLDPs for " + x509CertImpl.getSubjectX500Principal());
            }
            CRLDistributionPointsExtension cRLDistributionPointsExtension = x509CertImpl.getCRLDistributionPointsExtension();
            List<Object> list = null;
            if (cRLDistributionPointsExtension == null) {
                object2 = (X500Name)x509CertImpl.getIssuerDN();
                object = new DistributionPoint(new GeneralNames().add(new GeneralName((GeneralNameInterface)object2)), null, null);
                list = Collections.singletonList(object);
            } else {
                list = (List<Object>)cRLDistributionPointsExtension.get("points");
            }
            object2 = new HashSet();
            object = DistributionPointFetcher.getInstance();
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !Arrays.equals(blArray, ALL_REASONS)) {
                DistributionPoint distributionPoint = (DistributionPoint)iterator.next();
                for (X509CRL x509CRL : set) {
                    if (!((DistributionPointFetcher)object).verifyCRL(x509CertImpl, distributionPoint, x509CRL, blArray, publicKey, this.mSigProvider)) continue;
                    object2.add(x509CRL);
                }
            }
            return object2;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("Exception while verifying CRL: " + exception.getMessage());
            }
            return Collections.emptySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RejectKeySelector
    extends X509CertSelector {
        private final Set<PublicKey> badKeySet;

        RejectKeySelector(Collection<PublicKey> collection) {
            this.badKeySet = new HashSet<PublicKey>(collection);
        }

        @Override
        public boolean match(Certificate certificate) {
            if (!super.match(certificate)) {
                return false;
            }
            if (this.badKeySet.contains(certificate.getPublicKey())) {
                if (debug != null) {
                    debug.println("RejectCertSelector.match: bad key");
                }
                return false;
            }
            if (debug != null) {
                debug.println("RejectCertSelector.match: returning true");
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RejectCertSelector: [\n");
            stringBuilder.append(super.toString());
            stringBuilder.append(this.badKeySet);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

