/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.projects.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class RunToCursorActionProvider
extends ActionsProviderSupport {
    private EditorContext editor = (EditorContext)DebuggerManager.getDebuggerManager().lookupFirst(null, EditorContext.class);
    private LineBreakpoint breakpoint;
    static /* synthetic */ Class class$org$netbeans$api$debugger$jpda$JPDADebugger;

    public RunToCursorActionProvider() {
        Listener listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener((PropertyChangeListener)((Object)listener));
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)((Object)listener));
        DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)listener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
            }
        });
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object object) {
        this.removeBreakpoint();
        this.createBreakpoint(LineBreakpoint.create((String)this.editor.getCurrentURL(), (int)this.editor.getCurrentLineNumber()));
        this.invokeAction();
    }

    public void postAction(Object object, final Runnable runnable) {
        final LineBreakpoint lineBreakpoint = LineBreakpoint.create((String)this.editor.getCurrentURL(), (int)this.editor.getCurrentLineNumber());
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RunToCursorActionProvider.this.removeBreakpoint();
                RunToCursorActionProvider.this.createBreakpoint(lineBreakpoint);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            RunToCursorActionProvider.access$600(2.access$500(this.this$1));
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                }
                finally {
                    runnable.run();
                }
            }

            static /* synthetic */ RunToCursorActionProvider access$500(2 var0) {
                return var0.RunToCursorActionProvider.this;
            }
        });
    }

    private void invokeAction() {
        ((ActionProvider)MainProjectManager.getDefault().getMainProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug", MainProjectManager.getDefault().getMainProject().getLookup());
    }

    private boolean shouldBeEnabled() {
        int n;
        if (this.editor.getCurrentLineNumber() < 0) {
            return false;
        }
        if (!this.editor.getCurrentURL().endsWith(".java")) {
            return false;
        }
        Project project = MainProjectManager.getDefault().getMainProject();
        if (project == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] stringArray = actionProvider.getSupportedActions();
        int n2 = stringArray.length;
        for (n = 0; n < n2 && !"debug".equals(stringArray[n]); ++n) {
        }
        if (n == n2) {
            return false;
        }
        return ((ActionProvider)project.getLookup().lookup(ActionProvider.class)).isActionEnabled("debug", MainProjectManager.getDefault().getMainProject().getLookup());
    }

    private void createBreakpoint(LineBreakpoint lineBreakpoint) {
        lineBreakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)lineBreakpoint);
        this.breakpoint = lineBreakpoint;
    }

    private void removeBreakpoint() {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
    }

    static /* synthetic */ void access$600(RunToCursorActionProvider runToCursorActionProvider) {
        runToCursorActionProvider.invokeAction();
    }

    private class Listener
    extends DebuggerManagerAdapter {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "state") {
                int n = (Integer)propertyChangeEvent.getNewValue();
                if (n == 4 || n == 3) {
                    RunToCursorActionProvider.this.removeBreakpoint();
                }
                return;
            }
            RunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, RunToCursorActionProvider.this.shouldBeEnabled());
        }

        public void engineAdded(DebuggerEngine debuggerEngine) {
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = RunToCursorActionProvider.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
            if (jPDADebugger == null) {
                return;
            }
            jPDADebugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }

        public void engineRemoved(DebuggerEngine debuggerEngine) {
            JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, class$org$netbeans$api$debugger$jpda$JPDADebugger == null ? (class$org$netbeans$api$debugger$jpda$JPDADebugger = RunToCursorActionProvider.class$("org.netbeans.api.debugger.jpda.JPDADebugger")) : class$org$netbeans$api$debugger$jpda$JPDADebugger);
            if (jPDADebugger == null) {
                return;
            }
            jPDADebugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
        }
    }
}

