/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;

public class SourcePathProviderImpl
extends SourcePathProvider {
    private static boolean verbose = System.getProperty("netbeans.debugger.sourcepathproviderimpl") != null;
    private static final Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
    private static final Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
    private Session session;
    private ClassPath originalSourcePath;
    private ClassPath smartSteppingSourcePath;
    private String[] sourceRoots;
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);

    public SourcePathProviderImpl(ContextProvider contextProvider) {
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        if (map != null) {
            this.smartSteppingSourcePath = (ClassPath)map.get("sourcepath");
            ClassPath classPath = (ClassPath)map.get("jdksources");
            if (classPath == null && JavaPlatform.getDefault() != null) {
                classPath = JavaPlatform.getDefault().getSourceFolders();
            }
            this.originalSourcePath = classPath == null ? this.smartSteppingSourcePath : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.smartSteppingSourcePath, classPath});
        } else {
            HashSet hashSet = new HashSet(GlobalPathRegistry.getDefault().getSourceRoots());
            this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])hashSet.toArray(new FileObject[hashSet.size()]));
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
            int n = javaPlatformArray.length;
            for (int i = 0; i < n; ++i) {
                FileObject[] fileObjectArray = javaPlatformArray[i].getSourceFolders().getRoots();
                int n2 = fileObjectArray.length;
                for (int j = 0; j < n2; ++j) {
                    hashSet.remove(fileObjectArray[j]);
                }
            }
            this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])hashSet.toArray(new FileObject[hashSet.size()]));
        }
        this.sourceRoots = SourcePathProviderImpl.getRoots(Arrays.asList(this.smartSteppingSourcePath.getRoots()).iterator());
        if (verbose) {
            System.out.println("SPPI: init originalSourcePath " + this.originalSourcePath);
        }
        if (verbose) {
            System.out.println("SPPI: init smartSteppingSourcePath " + this.smartSteppingSourcePath);
        }
    }

    public String getURL(String string, boolean bl) {
        if (verbose) {
            System.out.println("SPPI: getURL " + string + " global " + bl);
        }
        FileObject fileObject = null;
        string = SourcePathProviderImpl.normalize(string);
        if (!bl) {
            fileObject = this.smartSteppingSourcePath.findResource(string);
            if (verbose) {
                System.out.println("SPPI:   fo " + fileObject);
            }
        } else {
            fileObject = this.originalSourcePath.findResource(string);
            if (verbose) {
                System.out.println("SPPI:   fo " + fileObject);
            }
            if (fileObject == null) {
                fileObject = GlobalPathRegistry.getDefault().findResource(string);
            }
            if (verbose) {
                System.out.println("SPPI:   fo2 " + fileObject);
            }
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return fileObject.getURL().toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            if (verbose) {
                System.out.println("SPPI:   FileStateInvalidException");
            }
            return null;
        }
    }

    public String getRelativePath(String string, char c, boolean bl) {
        FileObject fileObject = null;
        if (verbose) {
            System.out.println("SPPI: getRelativePath " + string);
        }
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (verbose) {
                System.out.println("SPPI:   fo " + fileObject);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        }
        if (classPath == null) {
            return null;
        }
        return classPath.getResourceName(fileObject, c, bl);
    }

    public String[] getOriginalSourceRoots() {
        return SourcePathProviderImpl.getRoots(GlobalPathRegistry.getDefault().getSourceRoots().iterator());
    }

    public String[] getSourceRoots() {
        return this.sourceRoots;
    }

    public void setSourceRoots(String[] stringArray) {
        int n = stringArray.length;
        FileObject[] fileObjectArray = new FileObject[n];
        for (int i = 0; i < n; ++i) {
            fileObjectArray[i] = this.getFileObject(stringArray[i]);
        }
        ClassPath classPath = this.smartSteppingSourcePath;
        this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
        this.sourceRoots = stringArray;
        this.pcs.firePropertyChange("sourceRoots", classPath, this.smartSteppingSourcePath);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private static String normalize(String string) {
        Matcher matcher = thisDirectoryPattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$1");
            matcher = thisDirectoryPattern.matcher(string);
        }
        matcher = parentDirectoryPattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).equals("..")) continue;
            string = string.substring(0, matcher.start()) + matcher.group(1) + string.substring(matcher.end());
            matcher = parentDirectoryPattern.matcher(string);
        }
        return string;
    }

    private static String[] getRoots(Iterator iterator) {
        String[] stringArray;
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            File file = null;
            try {
                file = stringArray.getFileSystem() instanceof JarFileSystem ? ((JarFileSystem)stringArray.getFileSystem()).getJarFile() : FileUtil.toFile((FileObject)stringArray);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            if (file == null) continue;
            treeSet.add(file.getAbsolutePath());
        }
        stringArray = new String[treeSet.size()];
        return treeSet.toArray(stringArray);
    }

    private FileObject getFileObject(String string) {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (FileUtil.isArchiveFile((FileObject)fileObject)) {
            fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
        }
        return fileObject;
    }
}

