/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.projects.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;

public class StepIntoActionProvider
extends ActionsProviderSupport {
    public StepIntoActionProvider() {
        Listener listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener(listener);
        this.setEnabled(ActionsManager.ACTION_STEP_INTO, this.shouldBeEnabled());
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_STEP_INTO);
    }

    public void doAction(Object object) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        StepIntoActionProvider.this.invokeAction();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
        } else {
            this.invokeAction();
        }
    }

    public void postAction(Object object, Runnable runnable) {
        this.invokeAction();
        runnable.run();
    }

    private void invokeAction() {
        ((ActionProvider)MainProjectManager.getDefault().getMainProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug.stepinto", MainProjectManager.getDefault().getMainProject().getLookup());
    }

    private boolean shouldBeEnabled() {
        int n;
        Project project = MainProjectManager.getDefault().getMainProject();
        if (project == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] stringArray = actionProvider.getSupportedActions();
        int n2 = stringArray.length;
        for (n = 0; n < n2 && !"debug.stepinto".equals(stringArray[n]); ++n) {
        }
        if (n == n2) {
            return false;
        }
        return actionProvider.isActionEnabled("debug.stepinto", MainProjectManager.getDefault().getMainProject().getLookup());
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            StepIntoActionProvider.this.setEnabled(ActionsManager.ACTION_STEP_INTO, StepIntoActionProvider.this.shouldBeEnabled());
        }
    }
}

