/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.projects;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private String expression;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (jPDADebugger == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part == null) {
            return null;
        }
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        try {
            StyledDocument styledDocument = editorCookie.openDocument();
            JEditorPane jEditorPane = ToolTipAnnotation.getCurrentEditor();
            if (jEditorPane == null) {
                return null;
            }
            ToolTipAnnotation toolTipAnnotation = this;
            synchronized (toolTipAnnotation) {
                this.expression = ToolTipAnnotation.getIdentifier(styledDocument, jEditorPane, NbDocument.findLineOffset((StyledDocument)styledDocument, (int)part.getLine().getLineNumber()) + part.getColumn());
                if (this.expression == null) {
                    return null;
                }
            }
            RequestProcessor.getDefault().post((Runnable)this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string;
        ToolTipAnnotation toolTipAnnotation = this;
        synchronized (toolTipAnnotation) {
            string = this.expression;
        }
        if (string == null) {
            return;
        }
        toolTipAnnotation = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (toolTipAnnotation == null) {
            return;
        }
        JPDADebugger jPDADebugger = (JPDADebugger)toolTipAnnotation.lookupFirst(null, JPDADebugger.class);
        if (jPDADebugger == null) {
            return;
        }
        JPDAThread jPDAThread = jPDADebugger.getCurrentThread();
        if (jPDAThread == null || !jPDAThread.isSuspended()) {
            return;
        }
        String string2 = null;
        try {
            Variable variable = jPDADebugger.evaluate(string);
            String string3 = variable.getType();
            String string4 = variable.getValue();
            if (variable instanceof ObjectVariable) {
                try {
                    string2 = string + " = " + (string3.length() == 0 ? "" : "(" + string3 + ") ") + ((ObjectVariable)variable).getToStringValue();
                }
                catch (InvalidExpressionException invalidExpressionException) {
                    string2 = string + " = " + (string3.length() == 0 ? "" : "(" + string3 + ") ") + string4;
                }
            } else {
                string2 = string + " = " + (string3.length() == 0 ? "" : "(" + string3 + ") ") + string4;
            }
        }
        catch (InvalidExpressionException invalidExpressionException) {
            string2 = string + " = >" + invalidExpressionException.getMessage() + "<";
        }
        this.firePropertyChange("shortDescription", null, string2);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && (Character.isJavaIdentifierPart(string.charAt(n5 - 1)) || string.charAt(n5 - 1) == '.'); --n5) {
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            return string.substring(n5, n4);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    static JEditorPane getCurrentEditor() {
        EditorCookie editorCookie = ToolTipAnnotation.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    private static EditorCookie getCurrentEditorCookie() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0];
        return (EditorCookie)node.getCookie(EditorCookie.class);
    }
}

