/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class J2SEInstallImpl
extends PlatformInstall {
    private static final String APPLE_JAVAVM_FRAMEWORK_PATH = "/System/Library/Frameworks/JavaVM.framework/Versions/";
    private boolean winOS;

    J2SEInstallImpl(boolean bl) {
        this.winOS = bl;
    }

    static J2SEInstallImpl create() {
        boolean bl = Utilities.isWindows();
        return new J2SEInstallImpl(bl);
    }

    public boolean accept(FileObject fileObject) {
        File file;
        if (!fileObject.isFolder()) {
            return false;
        }
        if (!(Utilities.getOperatingSystem() != 4096 || (file = FileUtil.toFile((FileObject)fileObject)) != null && file.getAbsolutePath().startsWith(APPLE_JAVAVM_FRAMEWORK_PATH))) {
            return false;
        }
        file = Util.findTool("java", Collections.singleton(fileObject));
        if (file == null) {
            return false;
        }
        file = Util.findTool("javac", Collections.singleton(fileObject));
        return file != null;
    }

    public WizardDescriptor.InstantiatingIterator createIterator(FileObject fileObject) {
        try {
            return new J2SEWizardIterator(fileObject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)J2SEInstallImpl.class, (String)"TXT_J2SEPlatform");
    }
}

